/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.blocks;

import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.mcreator.ars_technica.ConfigHandler;
import net.mcreator.ars_technica.common.blocks.SourceEngineBlock;
import net.mcreator.ars_technica.init.ArsTechnicaModSounds;
import net.mcreator.ars_technica.setup.BlockRegistry;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SourceEngineBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int MAX_SPEED = 256;
    protected boolean fueled = false;
    protected boolean hasRedstoneSignal = false;
    protected ScrollValueBehaviour generatedSpeed;
    public int generatedStressUnitsRatio = 100;
    protected int tickCount = 0;

    public boolean isFueled() {
        return this.fueled;
    }

    public void setGeneratedStressUnitsRatio(int ratio) {
        this.generatedStressUnitsRatio = ratio;
        this.updateGeneratedRotation();
    }

    public void setPowered(boolean powered) {
        boolean willRun;
        boolean wasRunning = !this.hasRedstoneSignal && this.fueled;
        this.hasRedstoneSignal = powered;
        boolean bl = willRun = !this.hasRedstoneSignal && this.fueled;
        if (wasRunning != willRun) {
            this.onRotationStateChanged();
        } else {
            this.notifyUpdate();
        }
    }

    public float calculateAddedStressCapacity() {
        float capacity = (float)BlockStressValues.getCapacity((Block)this.getStressConfigKey());
        int ratioMultipliedCapacity = Math.round(this.getStressCapacityMultiplier() * capacity);
        this.lastCapacityProvided = ratioMultipliedCapacity;
        return ratioMultipliedCapacity;
    }

    private float getStressCapacityMultiplier() {
        return (float)this.generatedStressUnitsRatio / 100.0f;
    }

    public SourceEngineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityRegistry.SOURCE_ENGINE_BLOCK_ENTITY.get(), pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)CreateLang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.value = 0;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.generatedStressUnitsRatio = compound.m_128451_("GeneratedStressUnitsRatio");
        this.fueled = compound.m_128471_("Fueled");
        this.hasRedstoneSignal = compound.m_128471_("HasRedstoneSignal");
        super.read(compound, clientPacket);
    }

    protected void writeCommon(CompoundTag compound) {
        compound.m_128405_("GeneratedStressUnitsRatio", this.generatedStressUnitsRatio);
        compound.m_128379_("Fueled", this.fueled);
        compound.m_128379_("HasRedstoneSignal", this.hasRedstoneSignal);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        this.writeCommon(compound);
        super.write(compound, clientPacket);
    }

    public void writeSafe(CompoundTag compound) {
        this.writeCommon(compound);
        super.writeSafe(compound);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!IRotate.StressImpact.isEnabled()) {
            return added;
        }
        if (this.overStressed) {
            return true;
        }
        CreateLang.translate((String)"gui.goggles.source_consumption", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (this.fueled && !this.hasRedstoneSignal) {
            int sourceCostTotal = this.getSourceCost();
            CreateLang.number((double)sourceCostTotal).space().translate("ars_nouveau.unit.source", new Object[0]).style(ChatFormatting.DARK_PURPLE).space().add(CreateLang.translate((String)"gui.goggles.per_second", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        if (this.hasRedstoneSignal) {
            CreateLang.translate((String)"ars_nouveau.has_redstone_signal", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
        } else if (!this.fueled) {
            CreateLang.translate((String)"ars_nouveau.lacks_source", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        }
        return true;
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        if (this.tickCount % 20 == 0 && !this.hasRedstoneSignal) {
            this.consumeSource();
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    protected void consumeSource() {
        int sourceCost = this.getSourceCost();
        if (sourceCost == 0) {
            return;
        }
        boolean success = SourceUtil.takeSourceWithParticles((BlockPos)this.f_58858_, (Level)this.f_58857_, (int)10, (int)sourceCost) != null;
        boolean fueledStateChanged = success != this.fueled;
        this.fueled = success;
        if (fueledStateChanged) {
            this.onRotationStateChanged();
            this.notifyUpdate();
        }
    }

    private void onRotationStateChanged() {
        this.updateGeneratedRotation();
        Vec3 pos = this.m_58899_().m_252807_();
        SoundEvent event = this.fueled && !this.hasRedstoneSignal ? (SoundEvent)ArsTechnicaModSounds.SOURCE_ENGINE_START.get() : (SoundEvent)ArsTechnicaModSounds.SOURCE_ENGINE_STOP.get();
        this.m_58904_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, event, SoundSource.BLOCKS, 0.25f, 1.0f);
    }

    private int getSourceCost() {
        if (this.overStressed) {
            return 0;
        }
        int absoluteSpeed = Math.abs(this.generatedSpeed.value);
        double rawSourceCost = (double)absoluteSpeed * (Double)ConfigHandler.Common.SOURCE_MOTOR_SPEED_TO_SOURCE_MULTIPLIER.get();
        float stressCapacityMultiplier = this.getStressCapacityMultiplier();
        if (stressCapacityMultiplier == 0.0f) {
            return 0;
        }
        int sourceCost = (int)Math.round((double)stressCapacityMultiplier * rawSourceCost);
        if (sourceCost == 0) {
            return 1;
        }
        return sourceCost;
    }

    public float getGeneratedSpeed() {
        if (!this.fueled || this.hasRedstoneSignal) {
            return 0.0f;
        }
        if (!((SourceEngineBlock)((Object)BlockRegistry.SOURCE_ENGINE.get())).m_49966_().m_60713_(this.m_58900_().m_60734_())) {
            return 0.0f;
        }
        return SourceEngineBlockEntity.convertToDirection((float)this.generatedSpeed.value, (Direction)((Direction)this.m_58900_().m_61143_((Property)SourceEngineBlock.FACING)));
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)SourceEngineBlock.FACING);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.m_61143_((Property)SourceEngineBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.of((PoseStack)ms).rotateZDegrees(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)SourceEngineBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

