/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mcreator.ars_technica.client.events.ModParticles;
import net.mcreator.ars_technica.common.entity.ArcaneProcessEntity;
import net.mcreator.ars_technica.common.entity.Colorable;
import net.mcreator.ars_technica.common.helpers.PlayerHelpers;
import net.mcreator.ars_technica.common.helpers.RecipeHelpers;
import net.mcreator.ars_technica.common.helpers.SpellResolverHelpers;
import net.mcreator.ars_technica.init.ArsTechnicaModSounds;
import net.mcreator.ars_technica.network.ParticleEffectPacket;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.mcreator.ars_technica.setup.NetworkHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcaneHammerEntity
extends Entity
implements GeoEntity,
Colorable {
    private static float UNSCALED_CHARGE_TIME = 2.0f;
    private static float UNSCALED_TIME_TILL_OBLITERATE = 0.25f;
    private static float UNSCALED_TIME_TILL_DISCARD = 1.0f;
    private static float AMPS_SIZE_MULTIPLIER = 0.33333334f;
    private static float AMPS_SPEED_MULTIPLIER = -0.05f;
    private long createdTime;
    private long chargedTime;
    private Entity target;
    private final Level world;
    private Entity caster;
    private SpellResolver resolver;
    private float ampScalar = 1.5f;
    private float amps = 0.0f;
    private boolean processItems = false;
    private boolean didObliterate = false;
    private boolean isCharging = true;
    private boolean chargeAnimationPlayed = false;
    private Color color;
    private float yaw;
    private float size = 1.0f;
    private float alpha = 0.0f;
    private float speed = 1.0f;
    private AnimationController<ArcaneHammerEntity> animationController;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.m_135353_(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    private static Vec3 getTargetPosition(Entity target) {
        return target.m_20318_(1.0f).m_82520_(0.0, 0.5, 0.0);
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(yaw));
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    protected void setAlpha(float alpha) {
        this.f_19804_.m_135381_(ALPHA, (Object)Float.valueOf(alpha));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    protected void setColor(Color color) {
        this.f_19804_.m_135381_(COLOR, (Object)color.getColor());
    }

    public float getSize() {
        return this.size;
    }

    protected void setSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    protected void setSpeed(float speed) {
        float clamped;
        this.speed = clamped = Math.max(0.6f, speed);
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(clamped));
    }

    public ArcaneHammerEntity(@Nullable Entity target, Vec3 position, Level world, Entity caster, Color color, SpellResolver resolver, SpellStats spellStats) {
        super((EntityType)EntityRegistry.ARCANE_HAMMER_ENTITY.get(), world);
        this.world = world;
        this.caster = caster;
        this.processItems = spellStats.isSensitive();
        this.resolver = resolver;
        this.amps = (float)spellStats.getAmpMultiplier();
        this.target = target;
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.setColor(color);
        this.setSize(1.0f + this.amps * AMPS_SIZE_MULTIPLIER);
        this.setSpeed(1.0f + this.amps * AMPS_SPEED_MULTIPLIER);
        this.createdTime = world.m_46467_();
    }

    public ArcaneHammerEntity(EntityType<ArcaneHammerEntity> entityType, Level world) {
        super(entityType, world);
        this.world = world;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.playWorldSound((SoundEvent)ArsTechnicaModSounds.OBLITERATE_CHARGE.get(), 0.75f, this.speed);
        this.playWorldSound((SoundEvent)ArsTechnicaModSounds.OBLITERATE_CHARGE_LARGE.get(), this.getLargeSoundVolume(), this.speed);
        this.createdTime = this.world.m_46467_();
    }

    private void playWorldSound(SoundEvent soundEvent, float volume, float pitch) {
        Vec3 pos = this.m_20318_(1.0f);
        this.world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, soundEvent, SoundSource.BLOCKS, volume, pitch);
    }

    private float getChargeSpeed() {
        return this.speed * 3.0f;
    }

    private float getLargeSoundVolume() {
        return Math.min(1.0f, this.amps * 0.125f * 0.4f);
    }

    public void m_8119_() {
        float totalElapsedTime;
        if (this.target != null && !this.didObliterate) {
            this.m_146884_(ArcaneHammerEntity.getTargetPosition(this.target));
        }
        if ((totalElapsedTime = (float)(this.world.m_46467_() - this.createdTime) / 20.0f) >= UNSCALED_CHARGE_TIME / this.getChargeSpeed() && this.isCharging) {
            this.isCharging = false;
            this.chargedTime = this.world.m_46467_();
            if (this.world.f_46443_) {
                this.setAnimationSpeed(1.0f);
            }
            this.playWorldSound((SoundEvent)ArsTechnicaModSounds.OBLITERATE_SWING.get(), 1.0f, 1.0f);
        }
        if (!this.isCharging) {
            float elapsedPostChargeTime = (float)(this.world.m_46467_() - this.chargedTime) / 20.0f;
            if (elapsedPostChargeTime >= UNSCALED_TIME_TILL_OBLITERATE && !this.didObliterate && !this.world.f_46443_) {
                this.obliterate();
            }
            if (elapsedPostChargeTime >= UNSCALED_TIME_TILL_DISCARD) {
                this.m_146870_();
            }
        }
    }

    protected void obliterate() {
        Vec3 pos;
        if (this.target != null) {
            if (!this.processItems) {
                Entity entity;
                Witch witch;
                DamageSource damageSource = this.getDamageSource();
                this.target.m_6469_(damageSource, this.getDamage());
                Entity entity2 = this.target;
                if (entity2 instanceof Witch && (witch = (Witch)entity2).m_21223_() <= 0.0f && this.caster != null && (entity = this.caster) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    this.triggerAdvancement(serverPlayer);
                }
            }
            if (this.resolver != null) {
                this.resolver.onResolveEffect(this.world, (HitResult)new EntityHitResult(this.target));
            }
        } else {
            pos = this.m_20318_(1.0f).m_82520_(-1.0, -1.0, -1.0);
            BlockPos blockPos = new BlockPos((int)Math.round(pos.f_82479_), (int)Math.round(pos.f_82480_), (int)Math.round(pos.f_82481_));
            if (this.resolver != null) {
                this.resolver.onResolveEffect(this.world, (HitResult)new BlockHitResult(pos, Direction.UP, blockPos, false));
            }
        }
        pos = this.m_20318_(1.0f);
        this.playWorldSound((SoundEvent)ArsTechnicaModSounds.OBLITERATE_SMASH.get(), 0.75f, 1.0f);
        this.playWorldSound((SoundEvent)ArsTechnicaModSounds.OBLITERATE_SHOCKWAVE.get(), this.getLargeSoundVolume(), 1.0f);
        this.didObliterate = true;
        this.handleItems();
    }

    private void triggerAdvancement(ServerPlayer player) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(ResourceLocation.fromNamespaceAndPath((String)"ars_technica", (String)"hammered_witch"));
        player.m_8960_().m_135988_(advancement, "triggered_by_obliterate");
    }

    protected float getDamage() {
        float ampsDamage = this.ampScalar * this.amps;
        float focusDamage = SpellResolverHelpers.shouldDoubleOutputs(this.resolver) ? ampsDamage : 0.0f;
        return 5.0f + ampsDamage + focusDamage;
    }

    protected void handleItems() {
        List itemEntities = this.world.m_45976_(ItemEntity.class, this.m_20191_().m_82400_(1.0));
        if (this.processItems) {
            this.processItems(itemEntities);
            this.sendProcessingParticles();
        } else {
            itemEntities.forEach(Entity::m_146870_);
        }
    }

    private void processItems(List<ItemEntity> itemEntities) {
        itemEntities.forEach(itemEntity -> {
            ItemStack itemStack = itemEntity.m_32055_();
            Optional<ProcessingRecipe<RecipeWrapper>> recipe = RecipeHelpers.getCrushingRecipeForItemStack(itemStack, this.world);
            ArrayList list = new ArrayList();
            if (recipe.isPresent()) {
                int rolls = itemStack.m_41613_();
                for (int roll = 0; roll < rolls; ++roll) {
                    List rolledResults = recipe.get().rollResults();
                    for (int i = 0; i < rolledResults.size(); ++i) {
                        ItemStack stack = (ItemStack)rolledResults.get(i);
                        if (SpellResolverHelpers.shouldDoubleOutputs(this.resolver) && RecipeHelpers.isChanceBased(stack, recipe.get())) {
                            stack.m_41769_(stack.m_41613_());
                        }
                        ItemHelper.addToList((ItemStack)stack, list);
                    }
                }
                list.forEach(result -> {
                    ItemEntity resultEntity = new ItemEntity(this.world, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
                    this.world.m_7967_((Entity)resultEntity);
                });
                itemEntity.m_146870_();
            }
        });
    }

    protected DamageSource getDamageSource() {
        Holder.Reference magicDamageType = this.world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_);
        DamageSource hammerDamageSource = new DamageSource((Holder)magicDamageType, (Entity)this, this.caster);
        return hammerDamageSource;
    }

    private void sendProcessingParticles() {
        Vec3 pos = this.m_20182_();
        List<ServerPlayer> nearbyPlayers = PlayerHelpers.getNearbyPlayers(pos, this.world);
        ParticleType particleType = ParticleTypes.f_123805_;
        for (ServerPlayer player : nearbyPlayers) {
            for (int i = 0; i < 10; ++i) {
                Vec3 finalPos = pos.m_82520_(Math.random() / 2.0, 0.0, Math.random() / 2.0);
                ParticleEffectPacket packet = new ParticleEffectPacket(finalPos, (ParticleType)ModParticles.SPIRAL_DUST_TYPE.get(), ParticleColor.fromInt((int)this.color.getColor()));
                NetworkHandler.CHANNEL.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        this.animationController = new AnimationController((GeoAnimatable)this, "hammerController", 0, this::smashAnimationPredicate);
        this.animationController.setCustomInstructionKeyframeHandler(event -> {
            CustomInstructionKeyframeData keyframeData = event.getKeyframeData();
            String instructions = keyframeData.getInstructions();
            if (instructions != null) {
                String[] instructionList;
                for (String instruction : instructionList = instructions.split(";")) {
                    if (!(instruction = instruction.trim()).startsWith("alpha=")) continue;
                    String[] parts = instruction.split("=");
                    this.setAlpha(Float.parseFloat(parts[1]));
                }
            }
        });
        controllerRegistrar.add(new AnimationController[]{this.animationController});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState smashAnimationPredicate(AnimationState<?> event) {
        if (!this.isCharging) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("smash"));
            return PlayState.CONTINUE;
        }
        if (!this.chargeAnimationPlayed) {
            this.setAnimationSpeed(this.getChargeSpeed());
            event.getController().setAnimation(RawAnimation.begin().thenPlay("charge"));
            this.chargeAnimationPlayed = true;
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private void setAnimationSpeed(float speed) {
        if (this.animationController != null) {
            this.animationController.setAnimationSpeed((double)speed);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(ALPHA, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(1.0f));
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (COLOR.equals(key)) {
            this.color = new Color(((Integer)this.f_19804_.m_135370_(COLOR)).intValue());
        }
        if (YAW.equals(key)) {
            this.yaw = ((Float)this.f_19804_.m_135370_(YAW)).floatValue();
        }
        if (SIZE.equals(key)) {
            this.size = ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
        }
        if (ALPHA.equals(key)) {
            this.alpha = ((Float)this.f_19804_.m_135370_(ALPHA)).floatValue();
        }
        if (SPEED.equals(key)) {
            this.speed = ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
        }
    }

    protected void m_7378_(CompoundTag p_20052_) {
    }

    protected void m_7380_(CompoundTag p_20139_) {
    }
}

