/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.entity.fusion;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.mcreator.ars_technica.ConfigHandler;
import net.mcreator.ars_technica.common.entity.Colorable;
import net.mcreator.ars_technica.common.entity.fusion.AllArcaneFusionTypes;
import net.mcreator.ars_technica.common.entity.fusion.ArcaneFusionParticles;
import net.mcreator.ars_technica.common.entity.fusion.ArcaneFusionType;
import net.mcreator.ars_technica.common.entity.fusion.fluids.ArcaneFusionFluids;
import net.mcreator.ars_technica.common.entity.fusion.fluids.FluidSourceProvider;
import net.mcreator.ars_technica.common.helpers.FluidHelper;
import net.mcreator.ars_technica.common.helpers.recipe.MixingRecipeHelpers;
import net.mcreator.ars_technica.init.ArsTechnicaModSounds;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcaneFusionEntity
extends Entity
implements GeoEntity,
Colorable {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private ArcaneFusionType fusionType;
    private final ArcaneFusionParticles particleHandler;
    private final ArcaneFusionFluids fluidHandler;
    private long createdTime;
    private float elapsedTime;
    private int tickCount = 0;
    private boolean impacted = false;
    private boolean swung = false;
    private boolean failed = false;
    private static final EntityDataAccessor<Boolean> FAILED = SynchedEntityData.m_135353_(ArcaneFusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private double aoe = 1.0;
    private Entity caster;
    private final Level world;
    private ItemEntity resultEntity;
    private List<FluidStack> resultLiquids;
    public static float CHARGE_TIME = 1.65f;
    public static float SWING_TIME = 0.35f;
    public static float IMPACT_TIME = CHARGE_TIME + SWING_TIME;
    public static float REMOVE_TIME = IMPACT_TIME + 1.0f;
    private AnimationController<ArcaneFusionEntity> animationController;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SynchedEntityData m_20088_() {
        return this.f_19804_;
    }

    public boolean getImpacted() {
        return this.impacted;
    }

    public boolean getSwung() {
        return this.swung;
    }

    public float getElapsedTime() {
        return this.elapsedTime;
    }

    public RandomSource getRandom() {
        return this.f_19796_;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public ArcaneFusionType getFusionType() {
        return this.fusionType;
    }

    public ArcaneFusionEntity(@Nullable Entity target, Vec3 position, Level world, Entity caster, Color color, SpellResolver resolver, SpellStats spellStats, String fusionTypeId) {
        super((EntityType)EntityRegistry.ARCANE_FUSION_ENTITY.get(), world);
        this.world = world;
        this.aoe = 1.0 + spellStats.getAoeMultiplier();
        this.caster = caster;
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.createdTime = world.m_46467_();
        this.particleHandler = new ArcaneFusionParticles(this, world);
        this.fluidHandler = new ArcaneFusionFluids(this, world);
        this.f_19804_.m_135381_(TYPE, (Object)fusionTypeId);
        this.fusionType = AllArcaneFusionTypes.getTypeFromId(fusionTypeId);
    }

    public ArcaneFusionEntity(EntityType<ArcaneFusionEntity> entityType, Level world) {
        super(entityType, world);
        this.world = world;
        this.particleHandler = new ArcaneFusionParticles(this, world);
        this.fluidHandler = new ArcaneFusionFluids(this, world);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.createdTime = this.world.m_46467_();
        this.handleIngredients();
    }

    public void m_8119_() {
        this.elapsedTime = (float)(this.world.m_46467_() - this.createdTime) / 20.0f;
        ++this.tickCount;
        if (this.elapsedTime > REMOVE_TIME) {
            this.m_146870_();
        }
        if (this.world.f_46443_ && this.fusionType != null) {
            this.particleHandler.handleParticles();
        }
        if (this.failed) {
            return;
        }
        if (this.elapsedTime > CHARGE_TIME && !this.swung) {
            this.playWorldSound((SoundEvent)ArsTechnicaModSounds.FUSE_SWING.get(), 0.75f, 1.0f);
            this.swung = true;
        }
        if (this.elapsedTime > IMPACT_TIME && !this.impacted) {
            this.playWorldSound((SoundEvent)ArsTechnicaModSounds.FUSE_IMPACT.get(), 0.75f, 1.0f);
            this.outputResults();
            this.impacted = true;
        }
    }

    private void playWorldSound(SoundEvent soundEvent, float volume, float pitch) {
        Vec3 pos = this.m_20318_(1.0f);
        this.world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, soundEvent, SoundSource.BLOCKS, volume, pitch);
    }

    protected void outputResults() {
        if (this.resultEntity != null) {
            this.world.m_7967_((Entity)this.resultEntity);
        }
        if (this.resultLiquids != null) {
            for (FluidStack fluidStack : this.resultLiquids) {
                FluidHelper.dumpFluid(fluidStack, this.world, this.m_20318_(1.0f), 4);
            }
        }
    }

    protected void handleIngredients() {
        if (this.world.f_46443_ || this.fusionType == null) {
            return;
        }
        List<FluidSourceProvider> fluids = this.fluidHandler.pickupFluids();
        List itemEntities = this.world.m_45976_(ItemEntity.class, this.m_20191_().m_82400_(this.aoe));
        if (itemEntities.isEmpty() && fluids.isEmpty()) {
            this.onFailure("no nearby items/fluids were found");
            return;
        }
        this.tryCombineIngredients(itemEntities, fluids);
    }

    protected void tryCombineIngredients(List<ItemEntity> itemEntities, List<FluidSourceProvider> fluids) {
        Optional<MixingRecipeHelpers.MixingRecipeResult> result = MixingRecipeHelpers.getMixingRecipe(itemEntities, fluids, this.world, this.fusionType);
        if (result.isPresent()) {
            int maxFluidIterations;
            int recipeIterations;
            int n;
            MixingRecipeHelpers.MixingRecipeResult resultObj = result.get();
            MixingRecipe recipe = resultObj.recipe;
            List<ItemEntity> ingredients = resultObj.usedEntities;
            List<FluidSourceProvider> fluidIngredients = resultObj.usedFluids;
            int maxItemIterations = Integer.MAX_VALUE;
            if (!ingredients.isEmpty()) {
                HashMap<ItemEntity, Integer> usageMap = new HashMap<ItemEntity, Integer>();
                for (ItemEntity itemEntity2 : ingredients) {
                    usageMap.put(itemEntity2, usageMap.getOrDefault(itemEntity2, 0) + 1);
                }
                for (Map.Entry entry : usageMap.entrySet()) {
                    ItemEntity itemEntity2 = (ItemEntity)entry.getKey();
                    int usedCount = (Integer)entry.getValue();
                    int totalAvailable = itemEntity2.m_32055_().m_41613_();
                    int entityMaxIterations = totalAvailable / usedCount;
                    maxItemIterations = Math.min(maxItemIterations, entityMaxIterations);
                }
            }
            if ((n = Math.min(recipeIterations = Math.min(maxItemIterations, maxFluidIterations = recipe.getFluidIngredients().isEmpty() ? Integer.MAX_VALUE : fluidIngredients.stream().mapToInt(fluidSource -> {
                FluidStack requiredFluid = recipe.getFluidIngredients().stream().flatMap(ingredient -> ingredient.getMatchingFluidStacks().stream()).filter(matchingFluid -> matchingFluid.getFluid().equals(fluidSource.getFluidStack().getFluid())).findFirst().orElse(null);
                return (int)Math.floor(fluidSource.getMbAmount() / requiredFluid.getAmount());
            }).min().orElse(0)), (int)Math.round(this.aoe * 4.0))) <= 0) {
                this.onFailure("there were not enough resources for a found recipe");
                return;
            }
            if (ingredients != null && !ingredients.isEmpty()) {
                this.particleHandler.setIngredientsForParticles(ingredients);
            }
            ingredients.forEach(itemEntity -> {
                ItemStack item = itemEntity.m_32055_();
                item.m_41764_(item.m_41613_() - clampedRecipeIterations);
                if (item.m_41613_() <= 0) {
                    itemEntity.m_146870_();
                }
            });
            fluidIngredients.forEach(fluidSource -> {
                FluidStack requiredFluid = recipe.getFluidIngredients().stream().flatMap(ingredient -> ingredient.getMatchingFluidStacks().stream()).filter(matchingFluid -> matchingFluid.getFluid().equals(fluidSource.getFluidStack().getFluid())).findFirst().orElse(null);
                if (requiredFluid != null) {
                    int mbToDrain = requiredFluid.getAmount() * clampedRecipeIterations;
                    fluidSource.drainFluid(mbToDrain, this.world);
                }
            });
            this.setItemResult(recipe, n);
            this.setFluidResult(recipe, n);
            this.playWorldSound((SoundEvent)ArsTechnicaModSounds.FUSE_CHARGE.get(), 0.75f, 1.0f);
        } else {
            this.onFailure("no recipes were found for nearby items/fluids");
        }
    }

    private void onFailure(String failureReason) {
        this.failed = true;
        this.f_19804_.m_135381_(FAILED, (Object)true);
        this.playWorldSound((SoundEvent)ArsTechnicaModSounds.FUSE_FAILED.get(), 0.75f, 1.0f);
        Entity entity = this.caster;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)ConfigHandler.Common.FUSE_FAILURE_CHAT_MESSAGE_ENABLED.get()).booleanValue()) {
                player.m_213846_((Component)Component.m_237113_((String)("Fuse failed because " + failureReason)));
            }
        }
    }

    private void setItemResult(MixingRecipe recipe, int recipeIterations) {
        RegistryAccess registryAccess = this.world.m_9598_();
        ItemStack recipeItemResult = recipe.m_8043_(registryAccess);
        ItemStack itemOutput = recipeItemResult.m_41777_();
        itemOutput.m_41764_(itemOutput.m_41613_() * recipeIterations);
        this.resultEntity = new ItemEntity(this.world, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemOutput);
    }

    private void setFluidResult(MixingRecipe recipe, int recipeIterations) {
        NonNullList fluidResults = recipe.getFluidResults();
        this.resultLiquids = fluidResults.stream().map(fluidStack -> {
            int newAmount = fluidStack.getAmount() * recipeIterations;
            return new FluidStack(fluidStack, newAmount);
        }).collect(Collectors.toList());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        this.animationController = new AnimationController((GeoAnimatable)this, "fusionController", 0, this::fuseAnimationPredicate);
        controllerRegistrar.add(new AnimationController[]{this.animationController});
    }

    private PlayState fuseAnimationPredicate(AnimationState<?> event) {
        if (this.failed) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("fail"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("charge"));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TYPE, (Object)"");
        this.f_19804_.m_135372_(FAILED, (Object)false);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        this.particleHandler.onSyncedDataUpdated(key);
        if (TYPE.equals(key)) {
            String typeId = (String)this.f_19804_.m_135370_(TYPE);
            this.fusionType = AllArcaneFusionTypes.getTypeFromId(typeId);
        }
        if (FAILED.equals(key)) {
            this.failed = (Boolean)this.f_19804_.m_135370_(FAILED);
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    @Override
    public Color getColor() {
        return Color.WHITE;
    }

    @Override
    public double getAlpha() {
        return 1.0;
    }
}

