/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import java.util.Set;
import javax.annotation.Nonnull;
import net.mcreator.ars_technica.common.entity.fusion.ArcaneFusionEntity;
import net.mcreator.ars_technica.common.glyphs.EffectSuperheat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.object.Color;

public class EffectFuse
extends AbstractEffect {
    public static final EffectFuse INSTANCE = new EffectFuse();

    private EffectFuse() {
        super(ResourceLocation.fromNamespaceAndPath((String)"ars_technica", (String)"glyph_fuse"), "Fuse");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity target = rayTraceResult.m_82443_();
        Vec3 position = target.m_20318_(1.0f);
        this.resolve(target, position, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Vec3 position = rayTraceResult.m_82450_();
        this.resolve(null, position, world, shooter, spellStats, spellContext, resolver);
    }

    private void resolve(@Nullable Entity target, Vec3 position, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Color color = new Color(spellContext.getColors().getColor());
        String fusionTypeId = this.getFusionType(spellContext);
        SpellContext newContext = spellContext.makeChildContext();
        spellContext.setCanceled(true);
        ArcaneFusionEntity arcaneFusionEntity = new ArcaneFusionEntity(target, position, world, (Entity)shooter, color, resolver.getNewResolver(newContext), spellStats, fusionTypeId);
        world.m_7967_((Entity)arcaneFusionEntity);
    }

    private String getFusionType(SpellContext spellContext) {
        String fusionType = "regular";
        if (spellContext.hasNextPart()) {
            while (spellContext.hasNextPart()) {
                AbstractSpellPart next = spellContext.nextPart();
                if (!(next instanceof AbstractEffect)) continue;
                if (next == EffectSmelt.INSTANCE) {
                    fusionType = "heated";
                    break;
                }
                if (next != EffectSuperheat.INSTANCE) break;
                fusionType = "super";
                break;
            }
        }
        return fusionType;
    }

    public int getDefaultManaCost() {
        return 75;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Fuses items by slamming them together at breakneck speed. Use Smelt for heated mixing, use Superheat for super-heated mixing (if enabled in config)";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }
}

