/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.Set;
import javax.annotation.Nonnull;
import net.mcreator.ars_technica.common.entity.ArcaneHammerEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.object.Color;

public class EffectObliterate
extends AbstractEffect {
    public static final EffectObliterate INSTANCE = new EffectObliterate();
    private static float DEFAULT_SPEED = 4.0f;

    private EffectObliterate() {
        super(ResourceLocation.fromNamespaceAndPath((String)"ars_technica", (String)"glyph_obliterate"), "Obliterate");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity target = rayTraceResult.m_82443_();
        Vec3 position = target.m_20318_(1.0f);
        this.resolve(target, position, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Vec3 position = rayTraceResult.m_82425_().m_252807_().m_82520_(0.0, 0.5, 0.0);
        this.resolve(null, position, world, shooter, spellStats, spellContext, resolver);
    }

    private void resolve(@Nullable Entity target, Vec3 position, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Color color = new Color(spellContext.getColors().getColor());
        SpellContext newContext = spellContext.makeChildContext();
        spellContext.setCanceled(true);
        ArcaneHammerEntity arcaneHammerEntity = new ArcaneHammerEntity(target, position, world, (Entity)shooter, color, resolver.getNewResolver(newContext), spellStats);
        this.setYaw(position, shooter, arcaneHammerEntity);
        world.m_7967_((Entity)arcaneHammerEntity);
    }

    private void setYaw(Vec3 position, @NotNull LivingEntity shooter, ArcaneHammerEntity arcaneHammerEntity) {
        Vec3 direction = position.m_82546_(shooter.m_20182_()).m_82541_();
        Vec3 rotation = new Vec3(0.0, 0.0, 0.0);
        float yaw = (float)(-Math.atan2(direction.m_7094_(), direction.m_7096_()) + 1.5707963267948966);
        arcaneHammerEntity.setYaw(yaw);
    }

    public int getDefaultManaCost() {
        return 100;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentSensitive.INSTANCE, AugmentAmplify.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Obliterates foes by sheer force with an arcane hammer. Use Sensitive to crush items instead of destroying them";
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }
}

