/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.ars_technica.common.crafting.DynamicCraftingContainer;
import net.mcreator.ars_technica.common.glyphs.AbstractItemResolveEffect;
import net.mcreator.ars_technica.common.helpers.CraftingHelpers;
import net.mcreator.ars_technica.common.helpers.ItemHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EffectPack
extends AbstractItemResolveEffect {
    public static final EffectPack INSTANCE = new EffectPack();

    private EffectPack() {
        super(ResourceLocation.fromNamespaceAndPath((String)"ars_technica", (String)"glyph_pack"), "Pack");
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double amplifier = spellStats.getAmpMultiplier();
        Map<Item, List<ItemEntity>> groupedItems = entityList.stream().collect(Collectors.groupingBy(itemEntity -> itemEntity.m_32055_().m_41720_()));
        Map<Item, List> packableItems = groupedItems.entrySet().stream().filter(entry -> this.isPackable((Item)entry.getKey(), world, amplifier)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<Item, List> entry2 : packableItems.entrySet()) {
            this.packItems(entry2.getKey(), entry2.getValue(), spellStats, world, pos, amplifier);
        }
    }

    private boolean isPackable(Item item, Level world, double amplifier) {
        int packGridSize = this.getPackGridSize(amplifier);
        return this.hasCraftingRecipe(item, packGridSize, world);
    }

    private boolean hasCraftingRecipe(Item item, int gridSize, Level world) {
        DynamicCraftingContainer tempContainer = new DynamicCraftingContainer(gridSize, gridSize);
        ItemStack itemStack = new ItemStack((ItemLike)item, gridSize * gridSize);
        for (int i = 0; i < gridSize * gridSize; ++i) {
            tempContainer.m_6836_(i, itemStack);
        }
        Optional recipe = world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)tempContainer, world);
        return recipe.isPresent();
    }

    private int getPackGridSize(double amplifier) {
        int value = (int)amplifier + 2;
        value = Math.max(value, 1);
        value = Math.min(value, 3);
        return value;
    }

    private void packItems(Item item, List<ItemEntity> itemEntities, SpellStats spellStats, Level world, BlockPos pos, double amplifier) {
        int gridSize = this.getPackGridSize(amplifier);
        int packSize = gridSize * gridSize;
        int totalItemCount = itemEntities.stream().mapToInt(entity -> entity.m_32055_().m_41613_()).sum();
        int totalPacks = totalItemCount / packSize;
        DynamicCraftingContainer container = new DynamicCraftingContainer(gridSize, gridSize);
        CraftingHelpers.setSquareShape(container, new ItemStack((ItemLike)item), gridSize);
        for (int i = 0; i < totalPacks; ++i) {
            ItemStack packedItem = CraftingHelpers.getItem(container, item, world);
            if (packedItem.m_41619_()) continue;
            ItemHelpers.createItemEntity(packedItem, world, pos);
        }
        int totalItemsToRemove = totalPacks * packSize;
        ItemHelpers.subtractItemsFromItemEntities(itemEntities, totalItemsToRemove, item, pos, world);
    }

    public int getDefaultManaCost() {
        return 10;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentAOE.INSTANCE, AugmentDampen.INSTANCE});
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentDampen.INSTANCE.getRegistryName(), 1);
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Condenses identical items, crafting them into 2x2 recipes. May be augmented with Amplify to use 3x3 recipes instead, or Dampen to craft 1x1 recipes.";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }
}

