/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.datagen;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.simibubi.create.AllItems;
import java.nio.file.Path;
import net.mcreator.ars_technica.common.items.threads.PressurePerk;
import net.mcreator.ars_technica.datagen.ATTagsProvider;
import net.mcreator.ars_technica.datagen.ConditionalApparatusRecipeBuilder;
import net.mcreator.ars_technica.recipe.TechnomancerArmorRecipe;
import net.mcreator.ars_technica.setup.ArsElementalModItems;
import net.mcreator.ars_technica.setup.ItemsRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ATApparatusProvider
extends ApparatusRecipeProvider {
    private static final TagKey<Item> BRASS_INGOT_TAG = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"ingots/brass"));
    public static final Ingredient BRASS_INGOT = Ingredient.m_204132_(BRASS_INGOT_TAG);

    public ATApparatusProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        this.addTechnomancerArmorRecipes();
        this.addCurioRecipes();
        this.addIngredientRecipes();
        this.addEquipmentRecipes();
        this.addThreadRecipes();
        Path output = this.generator.getPackOutput().m_245114_();
        for (EnchantingApparatusRecipe g : this.recipes) {
            if (g == null) continue;
            Path path = ATApparatusProvider.getRecipePath(output, g.m_6423_().m_135815_());
            this.saveStable(cache, g.asRecipe(), path);
        }
    }

    private ConditionalApparatusRecipeBuilder conditionalBuilder() {
        return ConditionalApparatusRecipeBuilder.conditionalBuilder();
    }

    protected void addTechnomancerArmorRecipes() {
        this.recipes.add(new TechnomancerArmorRecipe(this.conditionalBuilder().withResult((ItemLike)ItemsRegistry.TECHNOMANCER_HELMET.get()).withReagent(Ingredient.m_204132_(ATTagsProvider.ATItemTagsProvider.MAGIC_HOOD)).withPedestalItem((ItemLike)ArsElementalModItems.MARK_OF_MASTERY.get()).withPedestalItem((ItemLike)Items.f_42418_).withPedestalItem(BRASS_INGOT).withPedestalItem((ItemLike)AllItems.GOGGLES).withSourceCost(7000).keepNbtOfReagent(true).build()));
        this.recipes.add(new TechnomancerArmorRecipe(this.conditionalBuilder().withResult((ItemLike)ItemsRegistry.TECHNOMANCER_CHESTPLATE.get()).withReagent(Ingredient.m_204132_(ATTagsProvider.ATItemTagsProvider.MAGIC_ROBE)).withPedestalItem((ItemLike)ArsElementalModItems.MARK_OF_MASTERY.get()).withPedestalItem((ItemLike)Items.f_42418_).withPedestalItem(2, BRASS_INGOT).withSourceCost(7000).keepNbtOfReagent(true).build()));
        this.recipes.add(new TechnomancerArmorRecipe(this.conditionalBuilder().withResult((ItemLike)ItemsRegistry.TECHNOMANCER_LEGGINGS.get()).withReagent(Ingredient.m_204132_(ATTagsProvider.ATItemTagsProvider.MAGIC_LEG)).withPedestalItem((ItemLike)ArsElementalModItems.MARK_OF_MASTERY.get()).withPedestalItem((ItemLike)Items.f_42418_).withPedestalItem(2, BRASS_INGOT).withSourceCost(7000).keepNbtOfReagent(true).build()));
        this.recipes.add(new TechnomancerArmorRecipe(this.conditionalBuilder().withResult((ItemLike)ItemsRegistry.TECHNOMANCER_BOOTS.get()).withReagent(Ingredient.m_204132_(ATTagsProvider.ATItemTagsProvider.MAGIC_BOOT)).withPedestalItem((ItemLike)ArsElementalModItems.MARK_OF_MASTERY.get()).withPedestalItem((ItemLike)Items.f_42418_).withPedestalItem(2, BRASS_INGOT).withSourceCost(7000).keepNbtOfReagent(true).build()));
    }

    protected void addCurioRecipes() {
        this.recipes.add(this.conditionalBuilder().withConfigCondition("recipeFocusTransmutationEnabled").withResult(ItemsRegistry.TRANSMUTATION_FOCUS).withReagent((ItemLike)com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, BRASS_INGOT).withPedestalItem((ItemLike)Items.f_42648_).withPedestalItem(ItemsRegistry.CALIBRATED_PRECISION_MECHANISM).withPedestalItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42616_})).build());
    }

    protected void addIngredientRecipes() {
        this.recipes.add(this.conditionalBuilder().withConfigCondition("recipeCalibratedPrecisionMechanismEnabled").withResult(ItemsRegistry.CALIBRATED_PRECISION_MECHANISM).withReagent((ItemLike)AllItems.PRECISION_MECHANISM).withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151049_})).withPedestalItem(4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry.SOURCE_GEM})).withSourceCost(500).build());
    }

    protected void addEquipmentRecipes() {
        this.recipes.add(this.conditionalBuilder().withConfigCondition("recipeRunicSpannerEnabled").withResult(ItemsRegistry.RUNIC_SPANNER).withReagent((ItemLike)AllItems.WRENCH).withPedestalItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})).withPedestalItem(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemsRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).withPedestalItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry.MANIPULATION_ESSENCE})).withSourceCost(500).build());
        this.recipes.add(this.conditionalBuilder().withConfigCondition("recipeSpyMonocleEnabled").withResult(ItemsRegistry.SPY_MONOCLE).withReagent((ItemLike)Items.f_151059_).withPedestalItem(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemsRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).build());
    }

    protected void addThreadRecipes() {
        this.recipes.add(this.conditionalBuilder().withConfigCondition("recipeThreadPressureEnabled").withResult((ItemLike)this.getPerkItem(PressurePerk.INSTANCE.getRegistryName())).withReagent((ItemLike)com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry.BLANK_THREAD).withPedestalItem(3, Ingredient.m_43929_((ItemLike[])new ItemLike[]{com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry.AIR_ESSENCE})).withPedestalItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllItems.COPPER_BACKTANK})).withPedestalItem(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemsRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).build());
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_technica/recipes/" + str + ".json");
    }

    public String m_6055_() {
        return "Ars Technica Apparatus";
    }
}

