/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.mixin;

import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.mcreator.ars_technica.ArsTechnicaMod;
import net.mcreator.ars_technica.common.api.IRuneTileModifier;
import net.mcreator.ars_technica.common.helpers.CooldownHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RuneTile.class})
public class RuneTileMixin
implements IRuneTileModifier,
IHaveGoggleInformation {
    @Shadow(remap=false)
    public int ticksUntilCharge;
    @Unique
    private int ticksUntilChargeCount = -1;

    @Inject(method={"castSpell"}, at={@At(value="TAIL")}, remap=false)
    private void modifyTicksUntilCharge(Entity entity, CallbackInfo ci) {
        if (entity == null) {
            return;
        }
        ArsTechnicaMod.LOGGER.info((Object)entity.m_9236_().m_46467_());
        if (this.ticksUntilChargeCount != -1) {
            this.ticksUntilCharge = this.ticksUntilChargeCount;
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    private void saveTicksUntilChargeCount(CompoundTag tag, CallbackInfo ci) {
        tag.m_128405_("ticksUntilChargeCount", this.ticksUntilChargeCount);
    }

    @Inject(method={"load"}, at={@At(value="HEAD")})
    private void loadTicksUntilChargeCount(CompoundTag tag, CallbackInfo ci) {
        this.ticksUntilChargeCount = tag.m_128451_("ticksUntilChargeCount");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.text((String)"Cooldown: ").forGoggles(tooltip);
        int ticksUntilCharge = this.ticksUntilChargeCount == -1 ? 40 : this.ticksUntilChargeCount;
        CreateLang.text((String)CooldownHelper.getCooldownText(ticksUntilCharge)).forGoggles(tooltip);
        return true;
    }

    @Override
    public void setTicksUntilChargeCount(int ticks) {
        this.ticksUntilChargeCount = ticks;
    }

    @Override
    public int getTicksUntilChargeCount() {
        if (this.ticksUntilChargeCount == -1) {
            return 40;
        }
        return this.ticksUntilChargeCount;
    }
}

