/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.init;

import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.mojang.logging.LogUtils;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.arsdelight.compat.thirst.ThirstCompat;
import dev.xkmc.arsdelight.init.data.ADApparatusRecipeGen;
import dev.xkmc.arsdelight.init.data.ADConfigGen;
import dev.xkmc.arsdelight.init.data.ADGLMProvider;
import dev.xkmc.arsdelight.init.data.ADLangData;
import dev.xkmc.arsdelight.init.data.ADModConfig;
import dev.xkmc.arsdelight.init.data.RecipeGen;
import dev.xkmc.arsdelight.init.data.TagGen;
import dev.xkmc.arsdelight.init.food.ADFood;
import dev.xkmc.arsdelight.init.registrate.ADBlocks;
import dev.xkmc.arsdelight.init.registrate.ADEffects;
import dev.xkmc.arsdelight.init.registrate.ADEmptyRecipe;
import dev.xkmc.arsdelight.init.registrate.ADItems;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.serial.config.PacketHandler;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;

@Mod(value="arsdelight")
@Mod.EventBusSubscriber(modid="arsdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ArsDelight {
    public static final String MODID = "arsdelight";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final L2Registrate REGISTRATE = new L2Registrate("arsdelight");
    public static final PacketHandler HANDLER = new PacketHandler(new ResourceLocation("arsdelight", "main"), 1, new Function[0]);
    public static final RegistryEntry<CreativeModeTab> TAB = REGISTRATE.buildModCreativeTab("arsdelight", "Ars Nouveau's Flavors & Delight", e -> e.m_257737_(ADFood.SOURCE_BERRY_PIE_SLICE::asStack));

    public ArsDelight() {
        ADItems.register();
        ADEffects.register();
        ADModConfig.init();
        ADGLMProvider.register();
        ADEmptyRecipe.register();
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, TagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, TagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipes);
        REGISTRATE.addDataGenerator(ProviderType.LANG, ADLangData::genLang);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        ADFood.CHIMERA_MEAT.get().withTooltip((Component)ADLangData.KNIFE_KILL.get(((EntityType)ModEntities.WILDEN_BOSS.get()).m_20676_()));
        ADFood.WILDEN_MEAT.get().withTooltip((Component)ADLangData.KNIFE_KILL.get(((EntityType)ModEntities.WILDEN_HUNTER.get()).m_20676_()));
        ((ModItem)ADItems.CHIMERA_HORN.get()).withTooltip((Component)ADLangData.AXE_KILL.get(((EntityType)ModEntities.WILDEN_BOSS.get()).m_20676_()));
        ADFood.BOWL_OF_WILDEN_SALAD.get().withTooltip((Component)ADLangData.GRAB.get(ADBlocks.SALAD.asStack().m_41786_(), Items.f_42399_.m_5456_().m_7968_().m_41786_()));
        ADFood.BOWL_OF_HONEY_GLAZED_CHIMERA.get().withTooltip((Component)ADLangData.GRAB.get(ADBlocks.CHIMERA.asStack().m_41786_(), Items.f_42399_.m_5456_().m_7968_().m_41786_()));
        ADFood.HORN_ROLL.get().withTooltip((Component)ADLangData.GRAB.get(ADBlocks.SALAD.asStack().m_41786_(), ADItems.CHIMERA_HORN.m_5456_().m_7968_().m_41786_()));
        if (((Boolean)ADModConfig.COMMON.enableThirstCompat.get()).booleanValue() && ModList.get().isLoaded("thirst")) {
            ThirstCompat.init();
        }
        event.enqueueWork(() -> {
            LinkedHashSet<Block> set = new LinkedHashSet<Block>(((BlockEntityType)ModBlockEntityTypes.CABINET.get()).f_58915_);
            set.add((Block)ADBlocks.ARCHWOOD_CABINET.get());
            ((BlockEntityType)ModBlockEntityTypes.CABINET.get()).f_58915_ = set;
            ComposterBlock.f_51914_.put((Object)((ItemLike)ADItems.FLOURISHING_BARK.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ADItems.BLAZING_BARK.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ADItems.VEXING_BARK.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ADItems.CASCADING_BARK.get()), 0.3f);
        });
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        boolean server = event.includeServer();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(server, (DataProvider)new ADConfigGen(gen));
        gen.addProvider(server, (DataProvider)new ADGLMProvider(output));
        gen.addProvider(server, (DataProvider)new ADApparatusRecipeGen(gen));
    }

    public static ResourceLocation loc(String id) {
        return new ResourceLocation(MODID, id);
    }
}

