/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.init.food;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import dev.xkmc.arsdelight.content.item.ADFoodItem;
import dev.xkmc.arsdelight.init.food.EffectEntry;
import dev.xkmc.arsdelight.init.registrate.ADItems;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public enum FoodType {
    FAST(true, false, false, null, ADFoodItem::new),
    NORMAL(false, false, false, null, ADFoodItem::new),
    FAST_MEAT(true, false, true, null, ADFoodItem::new),
    MEAT(false, false, true, null, ADFoodItem::new),
    DRINK(true, true, false, () -> Items.f_42590_, ADFoodItem::new),
    HORNED_DRINK(true, true, false, () -> ADItems.CHIMERA_HORN.get(), ADFoodItem::new),
    JELLY(false, true, false, () -> Items.f_42590_, ADFoodItem::new),
    BOTTLE(false, false, false, () -> Items.f_42590_, ADFoodItem::new),
    BOWL(false, false, false, () -> Items.f_42399_, ADFoodItem::new),
    MEAT_PLATE(false, false, true, () -> Items.f_42399_, ADFoodItem::new),
    MEAT_STICK(true, false, true, () -> Items.f_42398_, ADFoodItem::new),
    HORNED_MEAT(true, false, true, () -> ADItems.CHIMERA_HORN.get(), ADFoodItem::new);

    private final boolean fast;
    private final boolean always;
    private final boolean meat;
    @Nullable
    private final Supplier<Item> container;
    private final BiFunction<Item.Properties, FoodType, ADFoodItem> factory;

    private FoodType(boolean fast, @Nullable boolean always, boolean meat, Supplier<Item> container, BiFunction<Item.Properties, FoodType, ADFoodItem> factory) {
        this.fast = fast;
        this.always = always;
        this.meat = meat;
        this.container = container;
        this.factory = factory;
    }

    ADFoodItem build(Item.Properties prop, FoodProperties.Builder builder) {
        if (this.fast) {
            builder.m_38766_();
        }
        if (this.always) {
            builder.m_38765_();
        }
        if (this.meat) {
            builder.m_38757_();
        }
        prop.m_41489_(builder.m_38767_());
        if (this.container != null) {
            prop.m_41487_(16);
            prop.m_41495_(this.container.get());
        }
        return this.factory.apply(prop, this);
    }

    public ADFoodItem build(Item.Properties prop, int nut, float sat, EffectEntry ... effs) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(nut).m_38758_(sat);
        for (EffectEntry e : effs) {
            builder.effect(e::getEffect, e.chance());
        }
        return this.build(prop, builder);
    }

    public void model(RegistrateItemModelProvider pvd, DataGenContext<Item, ADFoodItem> ctx, ResourceLocation tex) {
        switch (this) {
            case MEAT_STICK: {
                pvd.handheld(ctx, tex);
                break;
            }
            case BOTTLE: 
            case DRINK: 
            case HORNED_DRINK: 
            case HORNED_MEAT: {
                ADItems.mug(pvd, ctx, tex);
                break;
            }
            default: {
                pvd.generated(ctx, new ResourceLocation[]{tex});
            }
        }
    }
}

