/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.render.book.component;

import bagu_chan.bagus_lib.client.render.book.BookAccess;
import bagu_chan.bagus_lib.client.render.book.component.BookComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class DisplayBookComponent
extends BookComponent {
    private final List<TextDisplay> textDisplays = new ArrayList<TextDisplay>();
    private final List<EntityDisplay> entityDisplays = new ArrayList<EntityDisplay>();
    private final Map<EntityDisplay, LivingEntity> entities = new HashMap<EntityDisplay, LivingEntity>();
    private final List<ItemDisplay> itemDisplays = new ArrayList<ItemDisplay>();
    private final List<ItemTagDisplay> itemTagDisplays = new ArrayList<ItemTagDisplay>();
    private final List<ImageDisplay> imageDisplays = new ArrayList<ImageDisplay>();
    private int tickCount;

    public DisplayBookComponent(int width, int height) {
        super(width, height);
    }

    @Override
    public int getPageCount(int pagesBefore, Font font) {
        return 1;
    }

    @Override
    public void render(BookAccess access, GuiGraphics graphics, Font font, int x, int y, int mouseX, int mouseY) {
        for (ImageDisplay imageDisplay : this.imageDisplays) {
            graphics.m_280163_(imageDisplay.location(), x + imageDisplay.x(), y + imageDisplay.y(), 0.0f, 0.0f, imageDisplay.width(), imageDisplay.height(), imageDisplay.width(), imageDisplay.height());
        }
        for (EntityDisplay entityDisplay : this.entityDisplays) {
            LivingEntity livingEntity;
            if (!this.entities.containsKey(entityDisplay) && Minecraft.m_91087_().f_91073_ != null && (livingEntity = (LivingEntity)entityDisplay.type().m_20615_((Level)Minecraft.m_91087_().f_91073_)) != null) {
                livingEntity.f_20883_ = entityDisplay.yRot();
                livingEntity.m_146926_(entityDisplay.xRot());
                livingEntity.m_146922_(entityDisplay.yRot());
                livingEntity.f_20885_ = livingEntity.m_146908_();
                livingEntity.f_20886_ = livingEntity.m_146908_();
                this.entities.put(entityDisplay, livingEntity);
            }
            if (!this.entities.containsKey(entityDisplay)) continue;
            InventoryScreen.m_280432_((GuiGraphics)graphics, (int)(x + entityDisplay.x()), (int)(y + entityDisplay.y()), (int)((int)entityDisplay.scale()), (Quaternionf)entityDisplay.rotation, null, (LivingEntity)this.entities.get(entityDisplay));
        }
        for (ItemDisplay itemDisplay : this.itemDisplays) {
            graphics.m_280480_(itemDisplay.stack(), x + itemDisplay.x(), y + itemDisplay.y());
        }
        for (ItemTagDisplay itemTagDisplay : this.itemTagDisplays) {
            List<Item> items = StreamSupport.stream(BuiltInRegistries.f_257033_.m_206058_(itemTagDisplay.tag()).spliterator(), false).map(Holder::m_203334_).toList();
            if (items.isEmpty()) continue;
            graphics.m_280480_(items.get(this.tickCount / 20 % items.size()).m_7968_(), x + itemTagDisplay.x(), y + itemTagDisplay.y());
        }
        for (TextDisplay textDisplay : this.textDisplays) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(x + textDisplay.x()), (float)(y + textDisplay.y()), 0.0f);
            graphics.m_280168_().m_85841_(textDisplay.scale(), textDisplay.scale(), textDisplay.scale());
            Component component = textDisplay.text();
            int n = -font.m_92852_((FormattedText)textDisplay.text()) / 2;
            Objects.requireNonNull(font);
            graphics.m_280614_(font, component, n, -9, -16777216, false);
            graphics.m_280168_().m_85849_();
        }
    }

    @Override
    public void tick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
        ++this.tickCount;
    }

    @Override
    public void onClick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
    }

    public DisplayBookComponent textDisplay(Component text, int x, int y, float scale) {
        this.textDisplays.add(new TextDisplay(text, x, y, scale));
        return this;
    }

    public DisplayBookComponent entityDisplay(EntityType<? extends LivingEntity> type, int x, int y, float xRot, float yRot, float scale, Quaternionf rotation) {
        this.entityDisplays.add(new EntityDisplay(type, x, y, xRot, yRot, scale, rotation));
        return this;
    }

    public DisplayBookComponent itemDisplay(ItemStack stack, int x, int y) {
        this.itemDisplays.add(new ItemDisplay(stack, x, y));
        return this;
    }

    public DisplayBookComponent itemTagDisplay(TagKey<Item> tag, int x, int y) {
        this.itemTagDisplays.add(new ItemTagDisplay(tag, x, y));
        return this;
    }

    public DisplayBookComponent imageDisplay(ResourceLocation location, int x, int y, int width, int height) {
        this.imageDisplays.add(new ImageDisplay(location, x, y, width, height));
        return this;
    }

    private record ImageDisplay(ResourceLocation location, int x, int y, int width, int height) {
    }

    private record EntityDisplay(EntityType<? extends LivingEntity> type, int x, int y, float xRot, float yRot, float scale, Quaternionf rotation) {
    }

    private record ItemDisplay(ItemStack stack, int x, int y) {
    }

    private record ItemTagDisplay(TagKey<Item> tag, int x, int y) {
    }

    private record TextDisplay(Component text, int x, int y, float scale) {
    }
}

