/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.starfish_studios.bbb.block.properties.BBBBlockStateProperties;
import com.starfish_studios.bbb.block.properties.ColumnType;
import com.starfish_studios.bbb.registry.BBBTags;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ColumnBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LAYER_1_AABB = BBBBlockStateProperties.LAYER_1;
    public static final BooleanProperty LAYER_2_AABB = BBBBlockStateProperties.LAYER_2;
    public static final BooleanProperty LAYER_3_AABB = BBBBlockStateProperties.LAYER_3;
    public static final BooleanProperty LAYER_4_AABB = BBBBlockStateProperties.LAYER_4;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<ColumnType> TYPE = BBBBlockStateProperties.COLUMN_TYPE;
    private static final Map<Direction.Axis, VoxelShape> CENTER_AABB = new EnumMap<Direction.Axis, VoxelShape>(Direction.Axis.class);
    private static final Map<Direction.Axis, VoxelShape[]> LAYER_AABB = new EnumMap<Direction.Axis, VoxelShape[]>(Direction.Axis.class);

    public ColumnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_(TYPE, (Comparable)((Object)ColumnType.NONE))).m_61124_((Property)LAYER_1_AABB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LAYER_2_AABB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LAYER_3_AABB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LAYER_4_AABB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_())).m_61124_(TYPE, (Comparable)((Object)ColumnType.NONE))).m_61124_((Property)LAYER_1_AABB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LAYER_2_AABB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LAYER_3_AABB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LAYER_4_AABB, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_192917_((Fluid)Fluids.f_76193_)));
        return ColumnBlock.removeWaterIfFull(state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        VoxelShape shape = CENTER_AABB.get(axis);
        VoxelShape[] layers = LAYER_AABB.get(axis);
        if (((Boolean)state.m_61143_((Property)LAYER_1_AABB)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)layers[0]);
        }
        if (((Boolean)state.m_61143_((Property)LAYER_2_AABB)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)layers[1]);
        }
        if (((Boolean)state.m_61143_((Property)LAYER_3_AABB)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)layers[2]);
        }
        if (((Boolean)state.m_61143_((Property)LAYER_4_AABB)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)layers[3]);
        }
        return shape;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, @NotNull BlockState neighbor, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (direction.m_122434_() == state.m_61143_(AXIS)) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            BlockState above = level.m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)));
            BlockState below = level.m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)));
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)ColumnBlock.determineColumnType(state, above, below)));
        }
        if (((Boolean)(state = ColumnBlock.removeWaterIfFull(state)).m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!player.m_21120_(hand).m_204117_(BBBTags.BBBItemTags.HAMMERS)) {
            return InteractionResult.PASS;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        double hitFraction = hit.m_82450_().m_82507_(axis) - (double)pos.m_123304_(axis);
        if (axis == Direction.Axis.Z) {
            hitFraction = 1.0 - hitFraction;
        }
        int layerIndex = Math.min(3, (int)(hitFraction * 4.0));
        BooleanProperty[] layers = new BooleanProperty[]{LAYER_1_AABB, LAYER_2_AABB, LAYER_3_AABB, LAYER_4_AABB};
        state = (BlockState)state.m_61122_((Property)layers[layerIndex]);
        state = ColumnBlock.removeWaterIfFull(state);
        level.m_7731_(pos, state, 3);
        level.m_5594_(player, pos, state.m_60827_().m_56777_(), player.m_5720_(), 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public boolean m_6044_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Fluid fluid) {
        return !ColumnBlock.isFull(state) && super.m_6044_(level, pos, state, fluid);
    }

    public boolean m_7361_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidState) {
        return !ColumnBlock.isFull(state) && super.m_7361_(level, pos, state, fluidState);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    private static boolean isFull(BlockState state) {
        return (Boolean)state.m_61143_((Property)LAYER_1_AABB) != false && (Boolean)state.m_61143_((Property)LAYER_2_AABB) != false && (Boolean)state.m_61143_((Property)LAYER_3_AABB) != false && (Boolean)state.m_61143_((Property)LAYER_4_AABB) != false;
    }

    private static BlockState removeWaterIfFull(BlockState state) {
        return ColumnBlock.isFull(state) ? (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) : state;
    }

    private static ColumnType determineColumnType(BlockState state, BlockState up, BlockState down) {
        boolean connectsAbove = ColumnBlock.canConnect(state, up);
        boolean connectsBelow = ColumnBlock.canConnect(state, down);
        if (connectsAbove && !connectsBelow) {
            return ColumnType.BOTTOM;
        }
        if (!connectsAbove && connectsBelow) {
            return ColumnType.TOP;
        }
        if (connectsAbove) {
            return ColumnType.MIDDLE;
        }
        return ColumnType.NONE;
    }

    private static boolean canConnect(BlockState state, BlockState other) {
        boolean otherFull;
        if (!(other.m_60734_() instanceof ColumnBlock)) {
            return false;
        }
        if (state.m_61143_(AXIS) != other.m_61143_(AXIS)) {
            return false;
        }
        boolean thisFull = ColumnBlock.isFull(state);
        return thisFull == (otherFull = ColumnBlock.isFull(other));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYER_1_AABB, LAYER_2_AABB, LAYER_3_AABB, LAYER_4_AABB, WATERLOGGED, AXIS, TYPE});
    }

    static {
        CENTER_AABB.put(Direction.Axis.Y, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        CENTER_AABB.put(Direction.Axis.X, Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        CENTER_AABB.put(Direction.Axis.Z, Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
        LAYER_AABB.put(Direction.Axis.Y, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        LAYER_AABB.put(Direction.Axis.X, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        LAYER_AABB.put(Direction.Axis.Z, new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)});
    }
}

