/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.starfish_studios.bbb.registry.BBBTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class IronFenceBlock
extends WallBlock {
    private static final VoxelShape POST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public IronFenceBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    private static boolean isCoveredLocal(VoxelShape shape, VoxelShape test) {
        return !Shapes.m_83157_((VoxelShape)test, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82685_);
    }

    protected boolean connectsToCustom(BlockState state, boolean sturdy, Direction direction) {
        Block block = state.m_60734_();
        boolean gate = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return state.m_204336_(BBBTags.BBBBlockTags.METAL_FENCES) || !IronFenceBlock.m_152463_((BlockState)state) && sturdy || gate;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluid = level.m_6425_(pos);
        BlockPos north = pos.m_122012_();
        BlockPos east = pos.m_122029_();
        BlockPos south = pos.m_122019_();
        BlockPos west = pos.m_122024_();
        BlockPos up = pos.m_7494_();
        BlockState northState = level.m_8055_(north);
        BlockState eastState = level.m_8055_(east);
        BlockState southState = level.m_8055_(south);
        BlockState westState = level.m_8055_(west);
        BlockState support = level.m_8055_(up);
        boolean north2 = this.connectsToCustom(northState, northState.m_60783_((BlockGetter)level, north, Direction.SOUTH), Direction.SOUTH);
        boolean east2 = this.connectsToCustom(eastState, eastState.m_60783_((BlockGetter)level, east, Direction.WEST), Direction.WEST);
        boolean south2 = this.connectsToCustom(southState, southState.m_60783_((BlockGetter)level, south, Direction.NORTH), Direction.NORTH);
        boolean west2 = this.connectsToCustom(westState, westState.m_60783_((BlockGetter)level, west, Direction.EAST), Direction.EAST);
        BlockState base = (BlockState)this.m_49966_().m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        return this.redoConnections((LevelReader)level, base, up, support, north2, east2, south2, west2);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighbor, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)f_57954_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction == Direction.DOWN) {
            return super.m_7417_(state, direction, neighbor, level, pos, neighborPos);
        }
        if (direction == Direction.UP) {
            return this.m_57974_((LevelReader)level, state, neighborPos, neighbor);
        }
        Direction opposite = direction.m_122424_();
        boolean north = direction == Direction.NORTH ? this.connectsToCustom(neighbor, neighbor.m_60783_((BlockGetter)level, neighborPos, opposite), opposite) : IronFenceBlock.m_58010_((BlockState)state, (Property)f_57951_);
        boolean east = direction == Direction.EAST ? this.connectsToCustom(neighbor, neighbor.m_60783_((BlockGetter)level, neighborPos, opposite), opposite) : IronFenceBlock.m_58010_((BlockState)state, (Property)f_57950_);
        boolean south = direction == Direction.SOUTH ? this.connectsToCustom(neighbor, neighbor.m_60783_((BlockGetter)level, neighborPos, opposite), opposite) : IronFenceBlock.m_58010_((BlockState)state, (Property)f_57952_);
        boolean west = direction == Direction.WEST ? this.connectsToCustom(neighbor, neighbor.m_60783_((BlockGetter)level, neighborPos, opposite), opposite) : IronFenceBlock.m_58010_((BlockState)state, (Property)f_57953_);
        BlockPos upPos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(upPos);
        return this.redoConnections((LevelReader)level, state, upPos, aboveState, north, east, south, west);
    }

    private BlockState redoConnections(LevelReader level, BlockState state, BlockPos pos, BlockState aboveState, boolean north, boolean east, boolean south, boolean west) {
        VoxelShape shape = aboveState.m_60812_((BlockGetter)level, pos).m_83263_(Direction.DOWN);
        state = this.updateSides(state, north, east, south, west, shape);
        return (BlockState)state.m_61124_((Property)f_57949_, (Comparable)Boolean.valueOf(this.shouldReplacePost(state, aboveState, shape)));
    }

    private boolean shouldReplacePost(BlockState state, BlockState aboveState, VoxelShape aboveShape) {
        boolean westEmpty;
        if (aboveState.m_60734_() instanceof WallBlock && ((Boolean)aboveState.m_61143_((Property)f_57949_)).booleanValue()) {
            return true;
        }
        WallSide north = (WallSide)state.m_61143_((Property)f_57951_);
        WallSide east = (WallSide)state.m_61143_((Property)f_57950_);
        WallSide south = (WallSide)state.m_61143_((Property)f_57952_);
        WallSide west = (WallSide)state.m_61143_((Property)f_57953_);
        boolean northEmpty = north == WallSide.NONE;
        boolean eastEmpty = east == WallSide.NONE;
        boolean southEmpty = south == WallSide.NONE;
        boolean bl = westEmpty = west == WallSide.NONE;
        if (northEmpty && southEmpty && eastEmpty && westEmpty || northEmpty != southEmpty || eastEmpty != westEmpty) {
            return true;
        }
        if (north == WallSide.TALL && south == WallSide.TALL || east == WallSide.TALL && west == WallSide.TALL) {
            return false;
        }
        return aboveState.m_204336_(BlockTags.f_13081_) || IronFenceBlock.isCoveredLocal(aboveShape, POST_TEST);
    }

    private BlockState updateSides(BlockState state, boolean north, boolean east, boolean south, boolean west, VoxelShape shape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_57951_, (Comparable)this.forceWallState(north, shape, NORTH_TEST))).m_61124_((Property)f_57950_, (Comparable)this.forceWallState(east, shape, EAST_TEST))).m_61124_((Property)f_57952_, (Comparable)this.forceWallState(south, shape, SOUTH_TEST))).m_61124_((Property)f_57953_, (Comparable)this.forceWallState(west, shape, WEST_TEST));
    }

    private WallSide forceWallState(boolean connect, VoxelShape shape, VoxelShape test) {
        if (!connect) {
            return WallSide.NONE;
        }
        return IronFenceBlock.isCoveredLocal(shape, test) ? WallSide.TALL : WallSide.LOW;
    }
}

