/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.starfish_studios.bbb.block.AbstractBlockBlock;
import com.starfish_studios.bbb.block.BlockBlock;
import com.starfish_studios.bbb.block.WallBlockBlock;
import com.starfish_studios.bbb.block.entity.BlockBlockEntity;
import com.starfish_studios.bbb.client.model.BBBModelLayers;
import com.starfish_studios.bbb.client.model.BlockModel;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BlockBlockRenderer
implements BlockEntityRenderer<BlockBlockEntity> {
    private final ImmutableMap<BlockBlock.Types, BlockModel> modelByType = BlockBlockRenderer.createBlockRenderers(Minecraft.m_91087_().m_167973_());
    private static final Map<BlockBlock.Type, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(BlockBlock.Types.STONE, new ResourceLocation("bbb:textures/block/block/stone.png"));
        hashMap.put(BlockBlock.Types.BLACKSTONE, new ResourceLocation("bbb:textures/block/block/blackstone.png"));
        hashMap.put(BlockBlock.Types.DEEPSLATE, new ResourceLocation("bbb:textures/block/block/deepslate.png"));
        hashMap.put(BlockBlock.Types.NETHER_BRICK, new ResourceLocation("bbb:textures/block/block/nether_brick.png"));
        hashMap.put(BlockBlock.Types.SANDSTONE, new ResourceLocation("bbb:textures/block/block/sandstone.png"));
        hashMap.put(BlockBlock.Types.RED_SANDSTONE, new ResourceLocation("bbb:textures/block/block/red_sandstone.png"));
        hashMap.put(BlockBlock.Types.QUARTZ, new ResourceLocation("bbb:textures/block/block/quartz.png"));
    });

    public static ImmutableMap<BlockBlock.Types, BlockModel> createBlockRenderers(EntityModelSet entityModelSet) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)BlockBlock.Types.STONE, (Object)new BlockModel(entityModelSet.m_171103_(BBBModelLayers.STONE_BLOCK)));
        builder.put((Object)BlockBlock.Types.BLACKSTONE, (Object)new BlockModel(entityModelSet.m_171103_(BBBModelLayers.BLACKSTONE_BLOCK)));
        builder.put((Object)BlockBlock.Types.DEEPSLATE, (Object)new BlockModel(entityModelSet.m_171103_(BBBModelLayers.DEEPSLATE_BLOCK)));
        builder.put((Object)BlockBlock.Types.NETHER_BRICK, (Object)new BlockModel(entityModelSet.m_171103_(BBBModelLayers.NETHER_BRICK_BLOCK)));
        builder.put((Object)BlockBlock.Types.SANDSTONE, (Object)new BlockModel(entityModelSet.m_171103_(BBBModelLayers.SANDSTONE_BLOCK)));
        builder.put((Object)BlockBlock.Types.RED_SANDSTONE, (Object)new BlockModel(entityModelSet.m_171103_(BBBModelLayers.RED_SANDSTONE_BLOCK)));
        builder.put((Object)BlockBlock.Types.QUARTZ, (Object)new BlockModel(entityModelSet.m_171103_(BBBModelLayers.QUARTZ_BLOCK)));
        return builder.build();
    }

    public void render(BlockBlockEntity blockBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        float g = blockBlockEntity.getAnimation(f);
        BlockState blockState = blockBlockEntity.m_58900_();
        boolean bl = blockState.m_60734_() instanceof WallBlockBlock;
        Direction direction = bl ? (Direction)blockState.m_61143_((Property)WallBlockBlock.FACING) : null;
        int k = bl ? RotationSegment.m_245225_((Direction)direction.m_122424_()) : (Integer)blockState.m_61143_((Property)BlockBlock.ROTATION);
        float h = RotationSegment.m_245107_((int)k);
        BlockBlock.Type type = ((AbstractBlockBlock)blockState.m_60734_()).getType();
        RenderType renderType = RenderType.m_110452_((ResourceLocation)this.getTextureLocation(blockBlockEntity));
        BlockBlockRenderer.renderBlock(direction, h, g, poseStack, multiBufferSource, i, (BlockModel)((Object)this.modelByType.get((Object)type)), renderType);
    }

    private ResourceLocation getTextureLocation(BlockBlockEntity blockBlockEntity) {
        return TEXTURE_BY_TYPE.get(((AbstractBlockBlock)blockBlockEntity.m_58900_().m_60734_()).getType());
    }

    public static void renderBlock(@Nullable Direction direction, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, BlockModel blockModel, RenderType renderType) {
        poseStack.m_85836_();
        if (direction == null) {
            poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        } else {
            poseStack.m_252880_(0.5f - (float)direction.m_122429_() * 0.25f, 0.25f, 0.5f - (float)direction.m_122431_() * 0.25f);
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252880_(0.0f, -1.5f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderType);
        blockModel.m_6251_(g, f, 0.0f);
        blockModel.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

