/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.ItemIcon;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemIconWithProperties
extends ItemIcon {
    private static final String NBT_GENERIC_KEY = "_generic";
    private static final String NBT_CURRENT_ITEM = "_item";
    public static final String PARAM_PROPERTIES = "properties";
    protected final Map<ResourceLocation, ItemPropertyFunction> genericPropertyOverrides = new HashMap<ResourceLocation, ItemPropertyFunction>();
    protected final Map<Item, Map<ResourceLocation, ItemPropertyFunction>> itemPropertyOverrides = new HashMap<Item, Map<ResourceLocation, ItemPropertyFunction>>();
    private Map<ResourceLocation, ItemPropertyFunction> currentItemOverrides = Collections.emptyMap();

    public ItemIconWithProperties() {
    }

    public ItemIconWithProperties(PaneParams paneParams) {
        super(paneParams);
        String data = paneParams.getString(PARAM_PROPERTIES);
        if (data != null && this.itemStack != null) {
            CompoundTag tag;
            try {
                tag = TagParser.m_129359_((String)data);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(data, null);
            }
            tag.m_128431_().forEach(itemKey -> {
                if (tag.m_128425_(itemKey, 10)) {
                    CompoundTag child = tag.m_128469_(itemKey);
                    Map itemOverrides = NBT_GENERIC_KEY.equals(itemKey) ? this.genericPropertyOverrides : this.itemPropertyOverrides.computeIfAbsent(NBT_CURRENT_ITEM.equals(itemKey) ? this.itemStack.m_41720_() : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemKey)), i -> new HashMap());
                    child.m_128431_().forEach(key -> {
                        if (child.m_128425_(key, 99)) {
                            float value = child.m_128457_(key);
                            itemOverrides.put(new ResourceLocation(key), (itemStack, level, entity, seee) -> value);
                        }
                    });
                }
            });
            this.onItemUpdate();
        }
    }

    public void addPropertyForCurrentItem(ResourceLocation propertyKey, ItemPropertyFunction property) {
        this.itemPropertyOverrides.computeIfAbsent(Objects.requireNonNull(this.itemStack, "Call #setItem before this method").m_41720_(), item -> new HashMap()).put(propertyKey, property);
    }

    public Map<Item, Map<ResourceLocation, ItemPropertyFunction>> getItemPropertyOverrides() {
        return this.itemPropertyOverrides;
    }

    public Map<ResourceLocation, ItemPropertyFunction> getGenericPropertyOverrides() {
        return this.genericPropertyOverrides;
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        if (this.isDataEmpty()) {
            return;
        }
        if (this.currentItemOverrides.isEmpty() && this.genericPropertyOverrides.isEmpty()) {
            super.drawSelf(target, mx, my);
            return;
        }
        Item item = this.itemStack.m_41720_();
        HashMap<ResourceLocation, ItemPropertyFunction> oldGenericVals = this.genericPropertyOverrides.isEmpty() ? Collections.emptyMap() : new HashMap<ResourceLocation, ItemPropertyFunction>();
        this.genericPropertyOverrides.forEach((key, val) -> {
            oldGenericVals.put((ResourceLocation)key, ItemProperties.m_117829_((Item)item, (ResourceLocation)key));
            ItemProperties.registerGeneric((ResourceLocation)key, (ItemPropertyFunction)val);
        });
        HashMap<ResourceLocation, ItemPropertyFunction> oldItemVals = this.currentItemOverrides.isEmpty() ? Collections.emptyMap() : new HashMap<ResourceLocation, ItemPropertyFunction>();
        this.currentItemOverrides.forEach((key, val) -> {
            oldItemVals.put((ResourceLocation)key, ItemProperties.m_117829_((Item)item, (ResourceLocation)key));
            ItemProperties.register((Item)item, (ResourceLocation)key, (ItemPropertyFunction)val);
        });
        super.drawSelf(target, mx, my);
        oldItemVals.forEach((key, val) -> ItemProperties.register((Item)item, (ResourceLocation)key, (ItemPropertyFunction)val));
        oldGenericVals.forEach((key, val) -> ItemProperties.registerGeneric((ResourceLocation)key, (ItemPropertyFunction)val));
    }

    @Override
    protected void onItemUpdate() {
        super.onItemUpdate();
        if (this.itemPropertyOverrides != null) {
            this.currentItemOverrides = this.itemPropertyOverrides.getOrDefault(this.itemStack.m_41720_(), Collections.emptyMap());
        }
    }
}

