/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear;

import com.eruannie_9.booklinggear.BooklingGear;
import com.eruannie_9.booklinggear.GuiExecutor;
import com.eruannie_9.booklinggear.ModConfiguration;
import com.eruannie_9.booklinggear.screen.config.warning.JsonWarningList;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionConfigBuilder;
import com.eruannie_9.booklinggear.update.UpdateAnnouncer;
import com.eruannie_9.booklinggear.update.WorkerUpdater;
import com.eruannie_9.booklinggear.util.MirroredImageButton;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="booklinggear", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BooklingGearClient {
    public static final String ID_BANNER = "booklinggear:banner_button";
    public static final String ID_BANNER_PAUSE = "booklinggear:banner_button_pause";
    public static final String ID_BOOK = "booklinggear:book_button";
    @OnlyIn(value=Dist.CLIENT)
    public static ShaderInstance BUTTON_GLOW_SHADER;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            String minecraft = SharedConstants.m_183709_().m_132493_();
            WorkerUpdater.fetchAll(minecraft).thenAccept(results -> {
                for (WorkerUpdater.Result value : results) {
                    String modId = value.projectId();
                    Optional opt = ModList.get().getModContainerById(modId);
                    if (opt.isEmpty()) continue;
                    String currentVersion = ((ModContainer)opt.get()).getModInfo().getVersion().toString();
                    String displayName = ((ModContainer)opt.get()).getModInfo().getDisplayName();
                    if (!WorkerUpdater.isSameVersion(value.latestVersion(), currentVersion)) {
                        UpdateAnnouncer.queue(modId, displayName, value.latestVersion(), currentVersion, value.url());
                        continue;
                    }
                    BooklingGear.LOGGER.debug("[{}] up\u2011to\u2011date ({})", (Object)displayName, (Object)currentVersion);
                }
            });
            JsonWarningList.load();
            ButtonPositionConfigBuilder.register(ButtonPositionConfigBuilder.forButton(ID_BANNER, ModConfiguration.BANNER_OFFSET_X, ModConfiguration.BANNER_OFFSET_Y).group("banner").label((Component)Component.m_237113_((String)"Banner Button")).screen(TitleScreen.class, () -> new TitleScreen(false)).getter(GuiExecutor::getBannerButton).preview(BooklingGearClient.bannerPreviewFactory()).activeWhen(() -> ((ForgeConfigSpec.BooleanValue)ModConfiguration.MAIN).get()).base((w, h) -> new ButtonPositionConfigBuilder.Point(w / 2 - 122, h / 4 + 100)).build());
            ButtonPositionConfigBuilder.register(ButtonPositionConfigBuilder.forButton(ID_BANNER_PAUSE, ModConfiguration.BANNER_PAUSE_OFFSET_X, ModConfiguration.BANNER_PAUSE_OFFSET_Y).group("banner").label((Component)Component.m_237113_((String)"Banner Button")).screen(PauseScreen.class, () -> new PauseScreen(true)).getter(GuiExecutor::getBannerButton).preview(BooklingGearClient.bannerPreviewFactory()).activeWhen(() -> ((ForgeConfigSpec.BooleanValue)ModConfiguration.MAIN).get()).base((w, h) -> new ButtonPositionConfigBuilder.Point(w / 2 - 124, h / 4 + 108)).build());
            ButtonPositionConfigBuilder.register(ButtonPositionConfigBuilder.forButton(ID_BOOK, ModConfiguration.BOOK_OFFSET_X, ModConfiguration.BOOK_OFFSET_Y).label((Component)Component.m_237113_((String)"Book Button")).screen(OptionsScreen.class, () -> new OptionsScreen((Screen)new TitleScreen(false), Minecraft.m_91087_().f_91066_)).getter(GuiExecutor::getBookButton).preview(BooklingGearClient.bookPreviewFactory()).activeWhen(() -> ((ForgeConfigSpec.BooleanValue)ModConfiguration.MAIN).get()).base((w, h) -> new ButtonPositionConfigBuilder.Point(w / 2 - 177, h / 6 + 114)).build());
        });
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) {
        try {
            ResourceLocation id = new ResourceLocation("booklinggear", "button_glow");
            event.registerShader(new ShaderInstance(event.getResourceProvider(), id, DefaultVertexFormat.f_85814_), shader -> {
                BUTTON_GLOW_SHADER = shader;
            });
        }
        catch (IOException exception) {
            BooklingGear.LOGGER.error("Failed to load button_glow shader", (Throwable)exception);
        }
    }

    private static ButtonPositionConfigBuilder.PreviewFactory bannerPreviewFactory() {
        return (x, y) -> {
            boolean mirror = (Boolean)ModConfiguration.MIRROR.get();
            return new MirroredImageButton(x, y, 22, 8, 0, 0, 8, GuiExecutor.BANNER_TEXTURE, 22, 16, b -> {}, (Component)Component.m_237119_(), mirror, GuiExecutor.TEXT_OVERLAY);
        };
    }

    private static ButtonPositionConfigBuilder.PreviewFactory bookPreviewFactory() {
        return (x, y) -> new ImageButton(x, y, 20, 20, 0, 0, 20, GuiExecutor.BOOK_TEXTURE, 20, 40, b -> {}, (Component)Component.m_237119_());
    }
}

