/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear;

import com.eruannie_9.booklinggear.ModConfiguration;
import com.eruannie_9.booklinggear.screen.GeneralConfigScreen;
import com.eruannie_9.booklinggear.util.MirroredImageButton;
import com.eruannie_9.booklinggear.util.screen.GuiType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GuiExecutor {
    public static final ResourceLocation BANNER_TEXTURE = new ResourceLocation("booklinggear", "textures/gui/config_banner.png");
    public static final ResourceLocation TEXT_OVERLAY = new ResourceLocation("booklinggear", "textures/gui/config_banner_text.png");
    public static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("booklinggear", "textures/gui/config_book.png");
    private static MirroredImageButton lastBannerButton;
    private static ImageButton lastBookButton;

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (!((Boolean)ModConfiguration.MAIN.get()).booleanValue()) {
            return;
        }
        GuiType guiType = (GuiType)((Object)ModConfiguration.GUI_TYPE.get());
        Screen currentScreen = event.getScreen();
        if (guiType == GuiType.BANNER) {
            if (currentScreen instanceof TitleScreen || currentScreen instanceof PauseScreen) {
                MirroredImageButton configButton;
                int y;
                int x;
                if (currentScreen instanceof TitleScreen) {
                    x = currentScreen.f_96543_ / 2 - 122;
                    y = currentScreen.f_96544_ / 4 + 100;
                    x += ((Integer)ModConfiguration.BANNER_OFFSET_X.get()).intValue();
                    y += ((Integer)ModConfiguration.BANNER_OFFSET_Y.get()).intValue();
                } else {
                    x = currentScreen.f_96543_ / 2 - 124;
                    y = currentScreen.f_96544_ / 4 + 108;
                    x += ((Integer)ModConfiguration.BANNER_PAUSE_OFFSET_X.get()).intValue();
                    y += ((Integer)ModConfiguration.BANNER_PAUSE_OFFSET_Y.get()).intValue();
                }
                boolean mirrorTexture = (Boolean)ModConfiguration.MIRROR.get();
                lastBannerButton = configButton = new MirroredImageButton(x, y, 22, 8, 0, 0, 8, BANNER_TEXTURE, 22, 16, button -> Minecraft.m_91087_().m_91152_((Screen)new GeneralConfigScreen(currentScreen)), (Component)Component.m_237119_(), mirrorTexture, TEXT_OVERLAY);
                event.addListener((GuiEventListener)configButton);
            }
        } else if (guiType == GuiType.BOOK && currentScreen instanceof OptionsScreen) {
            ImageButton bookButton;
            OptionsScreen options = (OptionsScreen)currentScreen;
            int x = options.f_96543_ / 2 - 177;
            int y = options.f_96544_ / 6 + 114;
            lastBookButton = bookButton = new ImageButton(x += ((Integer)ModConfiguration.BOOK_OFFSET_X.get()).intValue(), y += ((Integer)ModConfiguration.BOOK_OFFSET_Y.get()).intValue(), 20, 20, 0, 0, 20, BOOK_TEXTURE, 20, 40, button -> Minecraft.m_91087_().m_91152_((Screen)new GeneralConfigScreen((Screen)options)), (Component)Component.m_237119_());
            event.addListener((GuiEventListener)bookButton);
        }
    }

    public static AbstractWidget getBannerButton() {
        return lastBannerButton;
    }

    public static AbstractWidget getBookButton() {
        return lastBookButton;
    }
}

