/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear;

import com.eruannie_9.booklinggear.update.UpdateMode;
import com.eruannie_9.booklinggear.util.screen.GuiType;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfiguration {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue MAIN;
    public static final ForgeConfigSpec.BooleanValue MIRROR;
    public static final ForgeConfigSpec.EnumValue<GuiType> GUI_TYPE;
    public static final ForgeConfigSpec.BooleanValue ANIMATIONS_ENABLED;
    public static final ForgeConfigSpec.EnumValue<UpdateMode> MOD_UPDATES;
    public static final ForgeConfigSpec.IntValue BANNER_OFFSET_X;
    public static final ForgeConfigSpec.IntValue BANNER_OFFSET_Y;
    public static final ForgeConfigSpec.IntValue BANNER_PAUSE_OFFSET_X;
    public static final ForgeConfigSpec.IntValue BANNER_PAUSE_OFFSET_Y;
    public static final ForgeConfigSpec.IntValue BOOK_OFFSET_X;
    public static final ForgeConfigSpec.IntValue BOOK_OFFSET_Y;
    public static final ForgeConfigSpec.ConfigValue<String> EXAMPLE_COLOR;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> EXAMPLE_LIST;

    public static void registerConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("General Settings");
        builder.comment("Enable or disable configuration screen to edit in live different Eruannie's mod settings.");
        MAIN = builder.define("Config_Screen", true);
        builder.comment("Determines which side the banner configuration appears on. This is experimental. There\u2019s no need to modify this value.");
        MIRROR = builder.define("Mirrored_Banner", true);
        builder.comment("Select the type of configuration button to display.");
        GUI_TYPE = builder.defineEnum("Button_Type", (Enum)GuiType.BANNER);
        builder.comment("Turn on/off animations within the config screen.");
        ANIMATIONS_ENABLED = builder.define("Animations_Enabled", true);
        builder.comment("When to show in game update notices:\n\nNONE = Never.\nSESSION = Once after the client starts.\nWORLD_JOIN = Every time you join a world/server.\n");
        MOD_UPDATES = builder.defineEnum("Update_Notices", (Enum)UpdateMode.SESSION);
        builder.comment("Pixel offsets applied to the config buttons relative to their default locations.\nPositive X moves right, negative X moves left.\nPositive Y moves down, negative Y moves up.\n");
        BANNER_OFFSET_X = builder.defineInRange("Banner_Offset_X", 0, -400, 400);
        BANNER_OFFSET_Y = builder.defineInRange("Banner_Offset_Y", 0, -400, 400);
        BANNER_PAUSE_OFFSET_X = builder.defineInRange("Banner_Pause_Offset_X", 0, -400, 400);
        BANNER_PAUSE_OFFSET_Y = builder.defineInRange("Banner_Pause_Offset_Y", 0, -400, 400);
        BOOK_OFFSET_X = builder.defineInRange("Book_Offset_X", 0, -400, 400);
        BOOK_OFFSET_Y = builder.defineInRange("Book_Offset_Y", 0, -400, 400);
        builder.pop();
        builder.push("Example Config Settings");
        builder.comment("Example color picker screen.");
        EXAMPLE_COLOR = builder.define("Example_Color", (Object)"00FFFF");
        builder.comment("Example list configuration.");
        EXAMPLE_LIST = builder.defineList("Example_List", List.of("minecraft:grass_block", "minecraft:dirt", "minecraft:rooted_dirt"), item -> item instanceof String);
        builder.pop();
        SPEC = builder.build();
    }
}

