/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.api;

import com.eruannie_9.booklinggear.api.ModInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class ModInfoRegistry {
    private static final List<ModInfo> BUILT_INS = List.of(new ModInfo("booklinggear", "Bookling Gear", "https://www.curseforge.com/minecraft/mc-mods/bookling-gear"), new ModInfo("parrotcage", "Parrot's Cage", "https://www.curseforge.com/minecraft/mc-mods/parrots-cage"), new ModInfo("lititup", "Lit it Up", "https://www.curseforge.com/minecraft/mc-mods/lit-it-up"), new ModInfo("fancyoutline", "Fancy Outline", "https://www.curseforge.com/minecraft/mc-mods/fancy-outline"), new ModInfo("brewchew", "Brew'n Chew", "https://www.curseforge.com/minecraft/mc-mods/brew-chew"), new ModInfo("iteminteractiondisabler", "Item Interaction Disabler", "https://www.curseforge.com/minecraft/mc-mods/item-interaction-disabler"), new ModInfo("minervillager", "Miner Villager", "https://www.curseforge.com/minecraft/mc-mods/miner-villager"));
    private static final Map<String, ModInfo> EXTERNALS = new ConcurrentHashMap<String, ModInfo>();

    public static void register(ModInfo info) {
        if (info == null || info.modid() == null || info.modid().isBlank()) {
            return;
        }
        EXTERNALS.put(info.modid(), info);
    }

    public static List<ModInfo> getAll() {
        LinkedHashMap<String, ModInfo> byId = new LinkedHashMap<String, ModInfo>();
        for (ModInfo m : BUILT_INS) {
            byId.put(m.modid(), m);
        }
        byId.putAll(EXTERNALS);
        return List.copyOf(byId.values());
    }

    public static Optional<ModInfo> get(String modid) {
        ModInfo ext = EXTERNALS.get(modid);
        if (ext != null) {
            return Optional.of(ext);
        }
        return BUILT_INS.stream().filter(m -> m.modid().equals(modid)).findFirst();
    }
}

