/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.chat.command;

import com.eruannie_9.booklinggear.chat.util.ChatRegistry;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public final class GetIdCommand {
    static void register(LiteralArgumentBuilder<CommandSourceStack> root, CommandBuildContext buildContext) {
        LiteralArgumentBuilder getIdItem = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"item").executes(GetIdCommand::executeGetIdItemHelp)).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(GetIdCommand::executeItem));
        LiteralArgumentBuilder getId = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"getId").executes(GetIdCommand::executeGetIdHelp)).then(Commands.m_82127_((String)"hand").executes(GetIdCommand::executeHand))).then(Commands.m_82127_((String)"look").executes(GetIdCommand::executeLooking))).then((ArgumentBuilder)getIdItem);
        root.then((ArgumentBuilder)getId);
    }

    private static int executeGetIdHelp(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ChatRegistry.sendHeader(player, "/bg getId usage");
        ChatRegistry.sendCommandUsage(player, "/bg getId hand", "Use the item in your hand or offhand.");
        ChatRegistry.sendCommandUsage(player, "/bg getId look", "Use the block or entity you're pointing at.");
        ChatRegistry.sendCommandUsage(player, "/bg getId item <item>", "Use any item by ID or name.");
        return 1;
    }

    private static int executeGetIdItemHelp(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ChatRegistry.sendHeader(player, "/bg getId item usage");
        MutableComponent usageCmd = ChatRegistry.copy("cmd_getId_item_usage", "/bg getId item <item>", "command");
        player.m_5661_((Component)Component.m_237113_((String)"Usage: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)usageCmd).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.WHITE)), false);
        MutableComponent exampleCmd = ChatRegistry.copy("cmd_getId_item_example", "/bg getId item minecraft:diamond_sword", "command");
        player.m_5661_((Component)Component.m_237113_((String)"Example: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)exampleCmd).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.WHITE)), false);
        return 1;
    }

    private static ItemStack requireHeldItem(LocalPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            stack = player.m_21206_();
        }
        if (stack.m_41619_()) {
            ChatRegistry.sendError(player, "You are not holding any item.");
            return ItemStack.f_41583_;
        }
        return stack;
    }

    private static int executeHand(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ItemStack stack = GetIdCommand.requireHeldItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        GetIdCommand.printItemInfo(player, stack);
        return 1;
    }

    private static int executeItem(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ItemInput input = ItemArgument.m_120963_(ctx, (String)"item");
        ItemStack stack = input.m_120980_(1, false);
        if (stack.m_41619_() || stack.m_41720_() == Items.f_41852_) {
            ChatRegistry.sendError(player, "Unknown or empty item.");
            return 0;
        }
        GetIdCommand.printItemInfo(player, stack);
        return 1;
    }

    private static int executeLooking(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return 0;
        }
        HitResult hit = mc.f_91077_;
        if (hit == null || hit.m_6662_() == HitResult.Type.MISS) {
            ChatRegistry.sendError(player, "No target in front of you.");
            return 0;
        }
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult bhr = (BlockHitResult)hit;
            BlockPos pos = bhr.m_82425_();
            BlockState state = mc.f_91073_.m_8055_(pos);
            GetIdCommand.printBlockInfo(player, state);
        } else if (hit.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult ehr = (EntityHitResult)hit;
            Entity entity = ehr.m_82443_();
            GetIdCommand.printEntityInfo(player, entity);
        } else {
            ChatRegistry.sendError(player, "No valid target in front of you.");
        }
        return 1;
    }

    private static void printItemInfo(LocalPlayer player, ItemStack stack) {
        Item item = stack.m_41720_();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        String idText = id != null ? id.toString() : "<unregistered>";
        Component name = item.m_41466_();
        ChatRegistry.sendInfoHeader(player, "Item Info", name);
        MutableComponent idValue = ChatRegistry.copy("item_id", idText, "ID");
        List<String> tags = stack.m_204131_().map(TagKey::f_203868_).map(ResourceLocation::toString).sorted().toList();
        int count = tags.size();
        if (count == 0) {
            player.m_5661_((Component)ChatRegistry.idLine(idValue), false);
            return;
        }
        if (count == 1) {
            String tag = tags.get(0);
            MutableComponent tagValue = ChatRegistry.copy("item_tag", tag, "tag");
            player.m_5661_((Component)ChatRegistry.singleTagLine(idValue, tagValue), false);
            return;
        }
        player.m_5661_((Component)ChatRegistry.idLine(idValue), false);
        MutableComponent countComp = ChatRegistry.tagCountButton("item_tag_count", "item", idText, tags);
        player.m_5661_((Component)ChatRegistry.tagsSummaryLine(countComp), false);
    }

    private static void printBlockInfo(LocalPlayer player, BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        String idText = id != null ? id.toString() : "<unregistered>";
        Item asItem = block.m_5456_();
        Object name = asItem != Items.f_41852_ ? asItem.m_41466_() : block.m_49954_();
        ChatRegistry.sendInfoHeader(player, "Block Info", name);
        MutableComponent idValue = ChatRegistry.copy("block_id", idText, "ID");
        List<String> tags = block.m_204297_().m_203616_().map(TagKey::f_203868_).map(ResourceLocation::toString).sorted().toList();
        int count = tags.size();
        if (count == 0) {
            player.m_5661_((Component)ChatRegistry.idLine(idValue), false);
            return;
        }
        if (count == 1) {
            String tag = tags.get(0);
            MutableComponent tagValue = ChatRegistry.copy("block_tag", tag, "tag");
            player.m_5661_((Component)ChatRegistry.singleTagLine(idValue, tagValue), false);
            return;
        }
        player.m_5661_((Component)ChatRegistry.idLine(idValue), false);
        MutableComponent countComp = ChatRegistry.tagCountButton("block_tag_count", "block", idText, tags);
        player.m_5661_((Component)ChatRegistry.tagsSummaryLine(countComp), false);
    }

    private static void printEntityInfo(LocalPlayer player, Entity entity) {
        EntityType type = entity.m_6095_();
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
        String idText = id != null ? id.toString() : "<unregistered>";
        Component name = type.m_20676_();
        ChatRegistry.sendInfoHeader(player, "Entity Info", name);
        MutableComponent idValue = ChatRegistry.copy("entity_id", idText, "ID");
        List<String> tags = type.m_204041_().m_203616_().map(TagKey::f_203868_).map(ResourceLocation::toString).sorted().toList();
        int count = tags.size();
        if (count == 0) {
            player.m_5661_((Component)ChatRegistry.idLine(idValue), false);
            return;
        }
        if (count == 1) {
            String tag = tags.get(0);
            MutableComponent tagValue = ChatRegistry.copy("entity_tag", tag, "tag");
            player.m_5661_((Component)ChatRegistry.singleTagLine(idValue, tagValue), false);
            return;
        }
        player.m_5661_((Component)ChatRegistry.idLine(idValue), false);
        MutableComponent countComp = ChatRegistry.tagCountButton("entity_tag_count", "entity", idText, tags);
        player.m_5661_((Component)ChatRegistry.tagsSummaryLine(countComp), false);
    }
}

