/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.chat.command;

import com.eruannie_9.booklinggear.chat.util.ChatRegistry;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public final class GetNbtCommand {
    static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        LiteralArgumentBuilder getNbt = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"getNbt").executes(GetNbtCommand::executeGetNbtHelp)).then(Commands.m_82127_((String)"hand").executes(GetNbtCommand::executeNbtHand))).then(Commands.m_82127_((String)"look").executes(GetNbtCommand::executeNbtLooking));
        root.then((ArgumentBuilder)getNbt);
    }

    private static int executeGetNbtHelp(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ChatRegistry.sendHeader(player, "/bg getNbt usage");
        ChatRegistry.sendCommandUsage(player, "/bg getNbt hand", "Use the item in your hand or offhand.");
        ChatRegistry.sendCommandUsage(player, "/bg getNbt look", "Use the block or entity you're pointing at.");
        return 1;
    }

    private static ItemStack requireHeldItem(LocalPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            stack = player.m_21206_();
        }
        if (stack.m_41619_()) {
            ChatRegistry.sendError(player, "You are not holding any item.");
            return ItemStack.f_41583_;
        }
        return stack;
    }

    private static int executeNbtHand(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ItemStack stack = GetNbtCommand.requireHeldItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        GetNbtCommand.printItemNbtInfo(player, stack);
        return 1;
    }

    private static int executeNbtLooking(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return 0;
        }
        HitResult hit = mc.f_91077_;
        if (hit == null || hit.m_6662_() == HitResult.Type.MISS) {
            ChatRegistry.sendError(player, "No target in front of you.");
            return 0;
        }
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult bhr = (BlockHitResult)hit;
            BlockPos pos = bhr.m_82425_();
            BlockState state = mc.f_91073_.m_8055_(pos);
            BlockEntity be = mc.f_91073_.m_7702_(pos);
            CompoundTag beTag = be != null ? be.m_187480_() : null;
            GetNbtCommand.printBlockNbtInfo(player, state, beTag);
        } else if (hit.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult ehr = (EntityHitResult)hit;
            Entity entity = ehr.m_82443_();
            GetNbtCommand.printEntityNbtInfo(player, entity);
        } else {
            ChatRegistry.sendError(player, "No valid target in front of you.");
        }
        return 1;
    }

    private static List<String> flattenNbt(@Nullable CompoundTag tag) {
        ArrayList<String> lines = new ArrayList<String>();
        if (tag == null || tag.m_128456_()) {
            return lines;
        }
        ArrayList keys = new ArrayList(tag.m_128431_());
        Collections.sort(keys);
        for (String key : keys) {
            Tag value = tag.m_128423_(key);
            String valueStr = value != null ? value.toString() : "null";
            lines.add(key + " = " + valueStr);
        }
        return lines;
    }

    private static void printItemNbtInfo(LocalPlayer player, ItemStack stack) {
        Item item = stack.m_41720_();
        Component name = item.m_41466_();
        CompoundTag nbt = stack.m_41783_();
        List<String> lines = GetNbtCommand.flattenNbt(nbt);
        if (lines.isEmpty()) {
            ChatRegistry.sendError(player, name.getString() + " has no NBT.");
            return;
        }
        ChatRegistry.sendInfoHeader(player, "Item NBT", name);
        for (String text : lines) {
            MutableComponent valueComp = ChatRegistry.copy("nbt_entry", text, "NBT entry");
            MutableComponent line = Component.m_237113_((String)"  - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)valueComp);
            player.m_5661_((Component)line, false);
        }
    }

    private static void printBlockNbtInfo(LocalPlayer player, BlockState state, @Nullable CompoundTag blockTag) {
        Block block = state.m_60734_();
        Item asItem = block.m_5456_();
        Object name = asItem != Items.f_41852_ ? asItem.m_41466_() : block.m_49954_();
        List<String> lines = GetNbtCommand.flattenNbt(blockTag);
        if (lines.isEmpty()) {
            ChatRegistry.sendError(player, name.getString() + " has no NBT.");
            return;
        }
        ChatRegistry.sendInfoHeader(player, "Block NBT", name);
        for (String text : lines) {
            MutableComponent valueComp = ChatRegistry.copy("nbt_entry", text, "NBT entry");
            MutableComponent line = Component.m_237113_((String)"  - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)valueComp);
            player.m_5661_((Component)line, false);
        }
    }

    private static void printEntityNbtInfo(LocalPlayer player, Entity entity) {
        EntityType type = entity.m_6095_();
        Component name = type.m_20676_();
        CompoundTag nbt = new CompoundTag();
        entity.m_20240_(nbt);
        List<String> lines = GetNbtCommand.flattenNbt(nbt);
        if (lines.isEmpty()) {
            ChatRegistry.sendError(player, name.getString() + " has no NBT.");
            return;
        }
        ChatRegistry.sendInfoHeader(player, "Entity NBT", name);
        for (String text : lines) {
            MutableComponent valueComp = ChatRegistry.copy("nbt_entry", text, "NBT entry");
            MutableComponent line = Component.m_237113_((String)"  - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)valueComp);
            player.m_5661_((Component)line, false);
        }
    }
}

