/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.chat.command;

import com.eruannie_9.booklinggear.chat.util.ChatRegistry;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public final class GetTagsCommand {
    static void register(LiteralArgumentBuilder<CommandSourceStack> root, CommandBuildContext buildContext) {
        LiteralArgumentBuilder getTagsItem = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"item").executes(GetTagsCommand::executeGetTagsItemHelp)).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(GetTagsCommand::executeTagsItem));
        LiteralArgumentBuilder getTags = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"getTags").executes(GetTagsCommand::executeGetTagsHelp)).then(Commands.m_82127_((String)"hand").executes(GetTagsCommand::executeTagsHand))).then(Commands.m_82127_((String)"look").executes(GetTagsCommand::executeTagsLooking))).then((ArgumentBuilder)getTagsItem);
        root.then((ArgumentBuilder)getTags);
    }

    private static int executeGetTagsHelp(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ChatRegistry.sendHeader(player, "/bg getTags usage");
        ChatRegistry.sendCommandUsage(player, "/bg getTags hand", "Use the item in your hand or offhand.");
        ChatRegistry.sendCommandUsage(player, "/bg getTags look", "Use the block or entity you're pointing at.");
        ChatRegistry.sendCommandUsage(player, "/bg getTags item <item>", "Use any item by ID or name.");
        return 1;
    }

    private static int executeGetTagsItemHelp(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ChatRegistry.sendHeader(player, "/bg getTags item usage");
        MutableComponent usageCmd = ChatRegistry.copy("cmd_getTags_item_usage", "/bg getTags item <item>", "command");
        player.m_5661_((Component)Component.m_237113_((String)"Usage: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)usageCmd).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.WHITE)), false);
        MutableComponent exampleCmd = ChatRegistry.copy("cmd_getTags_item_example", "/bg getTags item minecraft:diamond_sword", "command");
        player.m_5661_((Component)Component.m_237113_((String)"Example: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)exampleCmd).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.WHITE)), false);
        return 1;
    }

    private static ItemStack requireHeldItem(LocalPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            stack = player.m_21206_();
        }
        if (stack.m_41619_()) {
            ChatRegistry.sendError(player, "You are not holding any item.");
            return ItemStack.f_41583_;
        }
        return stack;
    }

    private static int executeTagsHand(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ItemStack stack = GetTagsCommand.requireHeldItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        GetTagsCommand.printItemTags(player, stack);
        return 1;
    }

    private static int executeTagsItem(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 0;
        }
        ItemInput input = ItemArgument.m_120963_(ctx, (String)"item");
        ItemStack stack = input.m_120980_(1, false);
        if (stack.m_41619_() || stack.m_41720_() == Items.f_41852_) {
            ChatRegistry.sendError(player, "Unknown or empty item.");
            return 0;
        }
        GetTagsCommand.printItemTags(player, stack);
        return 1;
    }

    private static int executeTagsLooking(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return 0;
        }
        HitResult hit = mc.f_91077_;
        if (hit == null || hit.m_6662_() == HitResult.Type.MISS) {
            ChatRegistry.sendError(player, "No target in front of you.");
            return 0;
        }
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult bhr = (BlockHitResult)hit;
            BlockPos pos = bhr.m_82425_();
            BlockState state = mc.f_91073_.m_8055_(pos);
            GetTagsCommand.printBlockTags(player, state);
        } else if (hit.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult ehr = (EntityHitResult)hit;
            Entity entity = ehr.m_82443_();
            GetTagsCommand.printEntityTags(player, entity);
        } else {
            ChatRegistry.sendError(player, "No valid target in front of you.");
        }
        return 1;
    }

    public static void showTagsFromClick(LocalPlayer player, String kind, ResourceLocation id) {
        List<String> tags;
        Object displayName;
        String idText = id.toString();
        switch (kind) {
            case "item": {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null) {
                    ChatRegistry.sendError(player, "Unknown item: " + idText);
                    return;
                }
                displayName = item.m_41466_();
                tags = item.m_204114_().m_203616_().map(TagKey::f_203868_).map(ResourceLocation::toString).sorted().toList();
                break;
            }
            case "block": {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
                if (block == null) {
                    ChatRegistry.sendError(player, "Unknown block: " + idText);
                    return;
                }
                Item asItem = block.m_5456_();
                displayName = asItem != Items.f_41852_ ? asItem.m_41466_() : block.m_49954_();
                tags = block.m_204297_().m_203616_().map(TagKey::f_203868_).map(ResourceLocation::toString).sorted().toList();
                break;
            }
            case "entity": {
                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
                if (type == null) {
                    ChatRegistry.sendError(player, "Unknown entity: " + idText);
                    return;
                }
                displayName = type.m_20676_();
                tags = type.m_204041_().m_203616_().map(TagKey::f_203868_).map(ResourceLocation::toString).sorted().toList();
                break;
            }
            default: {
                ChatRegistry.sendError(player, "Unknown kind: " + kind);
                return;
            }
        }
        if (tags.isEmpty()) {
            ChatRegistry.sendError(player, displayName.getString() + " has no tags.");
            return;
        }
        ChatRegistry.sendInfoHeader(player, "Tags", displayName);
        for (String tag : tags) {
            MutableComponent tagValue = ChatRegistry.copy("tag", tag, "tag");
            MutableComponent line = Component.m_237113_((String)"  - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)tagValue);
            player.m_5661_((Component)line, false);
        }
    }

    private static void printItemTags(LocalPlayer player, ItemStack stack) {
        Item item = stack.m_41720_();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        if (id == null) {
            ChatRegistry.sendError(player, "Unknown or unregistered item.");
            return;
        }
        GetTagsCommand.showTagsFromClick(player, "item", id);
    }

    private static void printBlockTags(LocalPlayer player, BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id == null) {
            ChatRegistry.sendError(player, "Unknown or unregistered block.");
            return;
        }
        GetTagsCommand.showTagsFromClick(player, "block", id);
    }

    private static void printEntityTags(LocalPlayer player, Entity entity) {
        EntityType type = entity.m_6095_();
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
        if (id == null) {
            ChatRegistry.sendError(player, "Unknown or unregistered entity.");
            return;
        }
        GetTagsCommand.showTagsFromClick(player, "entity", id);
    }
}

