/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.chat.util;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ChatHoverTextBuilder {
    private final String type;
    private final String value;
    @Nullable
    private TextColor baseColor;
    @Nullable
    private TextColor hoverColor;
    private boolean underlined = true;
    @Nullable
    private ClickEvent clickEvent;
    @Nullable
    private HoverEvent hoverEvent;
    @Nullable
    private String soundKey;

    private ChatHoverTextBuilder(String type, String value) {
        this.type = type;
        this.value = value;
        this.baseColor = TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA);
        this.hoverColor = TextColor.m_131266_((int)0xFFFFFF);
    }

    public static ChatHoverTextBuilder create(String type, String value) {
        return new ChatHoverTextBuilder(type, value);
    }

    public ChatHoverTextBuilder baseColor(ChatFormatting fmt) {
        TextColor c = TextColor.m_131270_((ChatFormatting)fmt);
        if (c != null) {
            this.baseColor = c;
        }
        return this;
    }

    public ChatHoverTextBuilder baseColor(int rgb) {
        this.baseColor = TextColor.m_131266_((int)rgb);
        return this;
    }

    public ChatHoverTextBuilder hoverColor(ChatFormatting fmt) {
        TextColor c = TextColor.m_131270_((ChatFormatting)fmt);
        if (c != null) {
            this.hoverColor = c;
        }
        return this;
    }

    public ChatHoverTextBuilder hoverColor(int rgb) {
        this.hoverColor = TextColor.m_131266_((int)rgb);
        return this;
    }

    public ChatHoverTextBuilder underlined(boolean underlined) {
        this.underlined = underlined;
        return this;
    }

    public ChatHoverTextBuilder sound(String soundId) {
        this.soundKey = soundId;
        return this;
    }

    public ChatHoverTextBuilder sound(ResourceLocation soundId) {
        this.soundKey = soundId.toString();
        return this;
    }

    public ChatHoverTextBuilder copyToClipboard(String label) {
        this.clickEvent = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.value);
        this.hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to copy " + label)).m_130940_(ChatFormatting.WHITE));
        return this;
    }

    public ChatHoverTextBuilder clientAction(String actionId, String payload, Component hoverText) {
        String full = "bookling:client:" + actionId + "|" + payload;
        this.clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, full);
        this.hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText);
        return this;
    }

    public ChatHoverTextBuilder runCommandRaw(String runValue, Component hoverText) {
        this.clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, runValue);
        this.hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText);
        return this;
    }

    public ChatHoverTextBuilder openUrl(String url, Component hoverText) {
        this.clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
        this.hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText);
        return this;
    }

    public MutableComponent build() {
        MutableComponent valueComponent = Component.m_237113_((String)this.value);
        TextColor base = this.baseColor != null ? this.baseColor : TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE);
        TextColor hover = this.hoverColor != null ? this.hoverColor : TextColor.m_131266_((int)0xFFFFFF);
        String hex = String.format("%06X", hover.m_131265_());
        StringBuilder insertionMeta = new StringBuilder();
        insertionMeta.append("booklinggear:hover:").append(hex).append(":").append(this.type);
        if (this.soundKey != null && !this.soundKey.isEmpty()) {
            insertionMeta.append(":").append(this.soundKey);
        }
        Style style = Style.f_131099_.m_131148_(base).m_131162_(this.underlined ? Boolean.TRUE : null).m_131138_(insertionMeta.toString());
        if (this.clickEvent != null) {
            style = style.m_131142_(this.clickEvent);
        }
        if (this.hoverEvent != null) {
            style = style.m_131144_(this.hoverEvent);
        }
        valueComponent.m_6270_(style);
        return valueComponent;
    }
}

