/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.chat.util;

import com.eruannie_9.booklinggear.chat.command.GetTagsCommand;
import com.eruannie_9.booklinggear.chat.util.ChatHoverTextBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ChatRegistry {
    public static final String HOVER_META_PREFIX = "booklinggear:hover:";
    public static final String CLIENT_ACTION_PREFIX = "bookling:client:";
    public static final String ACTION_SHOW_TAGS = "bookling:tags";
    @Nullable
    private static Style hoveredStyle;
    private static final Map<String, ClientActionHandler> CLIENT_ACTIONS;
    private static final Component LOGO_BASE;

    public static void setHoveredStyle(@Nullable Style style) {
        hoveredStyle = style;
    }

    @Nullable
    private static String[] parseHoverMeta(Style style) {
        if (style == null) {
            return null;
        }
        String insertion = style.m_131189_();
        if (insertion == null || !insertion.startsWith(HOVER_META_PREFIX)) {
            return null;
        }
        String rest = insertion.substring(HOVER_META_PREFIX.length());
        if (rest.isEmpty()) {
            return null;
        }
        return rest.split(":", 3);
    }

    @Nullable
    public static TextColor getHoverOverrideColor(Style style) {
        if (style == null || style != hoveredStyle) {
            return null;
        }
        String[] parts = ChatRegistry.parseHoverMeta(style);
        if (parts == null || parts.length < 1) {
            return null;
        }
        String hex = parts[0];
        try {
            int rgb = Integer.parseInt(hex, 16);
            return TextColor.m_131266_((int)rgb);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static String getHoverType(Style style) {
        String[] parts = ChatRegistry.parseHoverMeta(style);
        if (parts == null || parts.length < 2) {
            return null;
        }
        return parts[1];
    }

    @Nullable
    public static String getHoverSoundKey(Style style) {
        String[] parts = ChatRegistry.parseHoverMeta(style);
        if (parts == null || parts.length < 3) {
            return null;
        }
        return parts[2];
    }

    public static void registerClientAction(String actionId, ClientActionHandler handler) {
        CLIENT_ACTIONS.put(actionId, handler);
    }

    public static boolean handleRunCommand(LocalPlayer player, @Nullable String value) {
        if (value == null || !value.startsWith(CLIENT_ACTION_PREFIX)) {
            return false;
        }
        String rest = value.substring(CLIENT_ACTION_PREFIX.length());
        String[] parts = rest.split("\\|", 2);
        if (parts.length != 2) {
            return false;
        }
        String actionId = parts[0];
        String payload = parts[1];
        ClientActionHandler handler = CLIENT_ACTIONS.get(actionId);
        if (handler == null) {
            return false;
        }
        handler.handle(player, payload);
        return true;
    }

    private static MutableComponent logo() {
        return LOGO_BASE.m_6881_();
    }

    public static void sendLogoLine(LocalPlayer player, Component body) {
        MutableComponent line = ChatRegistry.logo().m_7220_((Component)Component.m_237113_((String)" ").m_130940_(ChatFormatting.GRAY)).m_7220_(body);
        player.m_5661_((Component)line, false);
    }

    public static void sendError(LocalPlayer player, String message) {
        ChatRegistry.sendLogoLine(player, (Component)Component.m_237113_((String)message).m_130940_(ChatFormatting.RED));
    }

    public static void sendHeader(LocalPlayer player, String title) {
        ChatRegistry.sendLogoLine(player, (Component)Component.m_237113_((String)title).m_130940_(ChatFormatting.GOLD));
    }

    public static void sendInfoHeader(LocalPlayer player, String label, Component name) {
        MutableComponent body = Component.m_237113_((String)(label + ":")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)" ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)name.m_6881_().m_130938_(style -> style.m_131155_(Boolean.valueOf(true))));
        ChatRegistry.sendLogoLine(player, (Component)body);
    }

    public static void sendCommandUsage(LocalPlayer player, String syntax, String description) {
        MutableComponent commandComponent = ChatRegistry.copyCommand(syntax);
        MutableComponent line = Component.m_237113_((String)"  ").m_7220_((Component)commandComponent).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)description).m_130940_(ChatFormatting.GRAY));
        player.m_5661_((Component)line, false);
    }

    public static MutableComponent idLine(MutableComponent idValue) {
        return Component.m_237113_((String)"ID: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)idValue);
    }

    public static MutableComponent singleTagLine(MutableComponent idValue, MutableComponent tagValue) {
        return Component.m_237113_((String)"ID: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)idValue).m_7220_((Component)Component.m_237113_((String)"  Tag: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)tagValue);
    }

    public static MutableComponent tagsSummaryLine(MutableComponent countComp) {
        return Component.m_237113_((String)"Tags: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"(").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)countComp).m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.WHITE));
    }

    public static MutableComponent copy(String type, String value, String what) {
        return ChatHoverTextBuilder.create(type, value).underlined(false).baseColor(ChatFormatting.AQUA).hoverColor(ChatFormatting.WHITE).copyToClipboard(what).build();
    }

    public static MutableComponent copyCommand(String command) {
        return ChatRegistry.copy("command", command, "command");
    }

    public static MutableComponent tagCountButton(String type, String kind, String idText, List<String> tags) {
        int count = tags.size();
        String text = Integer.toString(count);
        String payload = kind + "|" + idText;
        MutableComponent hover = Component.m_237113_((String)("Tags (" + count + "):")).m_130940_(ChatFormatting.WHITE);
        for (String tag : tags) {
            hover.m_7220_((Component)Component.m_237113_((String)("\n- " + tag)).m_130940_(ChatFormatting.AQUA));
        }
        return ChatHoverTextBuilder.create(type, text).underlined(false).baseColor(ChatFormatting.AQUA).hoverColor(ChatFormatting.WHITE).clientAction(ACTION_SHOW_TAGS, payload, (Component)hover).build();
    }

    static {
        CLIENT_ACTIONS = new HashMap<String, ClientActionHandler>();
        ChatRegistry.registerClientAction(ACTION_SHOW_TAGS, (player, payload) -> {
            String[] parts = payload.split("\\|", 2);
            if (parts.length != 2) {
                return;
            }
            String kind = parts[0];
            ResourceLocation id = new ResourceLocation(parts[1]);
            GetTagsCommand.showTagsFromClick(player, kind, id);
        });
        LOGO_BASE = Component.m_237113_((String)"[").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"Bookling Gear").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.WHITE));
    }

    @FunctionalInterface
    public static interface ClientActionHandler {
        public void handle(LocalPlayer var1, String var2);
    }
}

