/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.packethandler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class PacketRegister {
    private static final Map<String, Channel> CHANNELS = new ConcurrentHashMap<String, Channel>();

    public static SimpleChannel channel(String modid) {
        return PacketRegister.of(modid).channel();
    }

    public static <MSG> void register(String modid, Class<MSG> packetClass) {
        PacketRegister.of(modid).register(packetClass, Flow.BOTH, ThreadPolicy.MAIN);
    }

    public static <MSG> void register(String modid, Class<MSG> packetClass, Flow flow) {
        PacketRegister.of(modid).register(packetClass, flow, ThreadPolicy.MAIN);
    }

    public static <MSG> void register(String modid, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
        PacketRegister.of(modid).register(packetClass, flow, thread);
    }

    public static <MSG> void register(String modid, int id, Class<MSG> packetClass) {
        PacketRegister.of(modid).register(id, packetClass, Flow.BOTH, ThreadPolicy.MAIN);
    }

    public static <MSG> void register(String modid, int id, Class<MSG> packetClass, Flow flow) {
        PacketRegister.of(modid).register(id, packetClass, flow, ThreadPolicy.MAIN);
    }

    public static <MSG> void register(String modid, int id, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
        PacketRegister.of(modid).register(id, packetClass, flow, thread);
    }

    public static <MSG> void registerLogin(String modid, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
        PacketRegister.of(modid).registerLogin(packetClass, flow, thread);
    }

    private static Channel of(String modid) {
        return CHANNELS.computeIfAbsent(modid, Channel::new);
    }

    public static final class Channel {
        private static final String DEFAULT_NAME = "main";
        private static final String DEFAULT_PROTOCOL = "1";
        private final String modid;
        private final SimpleChannel channel;
        private final Set<Integer> usedIds = new ConcurrentSkipListSet<Integer>();

        private Channel(String modid) {
            this.modid = modid;
            this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modid, DEFAULT_NAME), () -> DEFAULT_PROTOCOL, DEFAULT_PROTOCOL::equals, DEFAULT_PROTOCOL::equals);
        }

        public SimpleChannel channel() {
            return this.channel;
        }

        public <MSG> void register(Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
            int id = Channel.deriveId(this.modid, packetClass);
            this.register(id, packetClass, flow, thread);
        }

        public <MSG> void register(int id, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
            if (!this.usedIds.add(id)) {
                throw new IllegalStateException("Duplicate packet id " + id + " for " + this.modid);
            }
            BiConsumer<MSG, FriendlyByteBuf> encode = Channel.findEncoder(packetClass);
            Function<FriendlyByteBuf, MSG> decode = Channel.findDecoder(packetClass);
            BiConsumer<MSG, Supplier<NetworkEvent.Context>> userHandler = Channel.findHandler(packetClass);
            BiConsumer<MSG, Supplier<NetworkEvent.Context>> guarded = Channel.guardByFlow(userHandler, flow);
            SimpleChannel.MessageBuilder builder = flow.playDirection().isPresent() ? this.channel.messageBuilder(packetClass, id, flow.playDirection().get()) : this.channel.messageBuilder(packetClass, id);
            builder.encoder(encode).decoder(decode);
            if (thread == ThreadPolicy.MAIN) {
                builder.consumerMainThread(guarded);
            } else {
                builder.consumerNetworkThread(guarded);
            }
            builder.add();
        }

        public <MSG> void registerLogin(Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
            int id = Channel.deriveId(this.modid, packetClass);
            if (!this.usedIds.add(id)) {
                throw new IllegalStateException("Duplicate packet id " + id + " for " + this.modid);
            }
            BiConsumer<MSG, FriendlyByteBuf> encode = Channel.findEncoder(packetClass);
            Function<FriendlyByteBuf, MSG> decode = Channel.findDecoder(packetClass);
            BiConsumer<MSG, Supplier<NetworkEvent.Context>> userHandler = Channel.findHandler(packetClass);
            BiConsumer<MSG, Supplier<NetworkEvent.Context>> guarded = Channel.guardByFlow(userHandler, flow);
            SimpleChannel.MessageBuilder builder = flow.loginDirection().isPresent() ? this.channel.messageBuilder(packetClass, id, flow.loginDirection().get()) : this.channel.messageBuilder(packetClass, id);
            builder.encoder(encode).decoder(decode).markAsLoginPacket();
            if (thread == ThreadPolicy.MAIN) {
                builder.consumerMainThread(guarded);
            } else {
                builder.consumerNetworkThread(guarded);
            }
            builder.add();
        }

        private static <MSG> BiConsumer<MSG, Supplier<NetworkEvent.Context>> guardByFlow(BiConsumer<MSG, Supplier<NetworkEvent.Context>> userHandler, Flow flow) {
            if (flow == Flow.TO_SERVER) {
                return (msg, contextSupplier) -> {
                    NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                    NetworkDirection direction = context.getDirection();
                    if (direction == NetworkDirection.PLAY_TO_SERVER ? context.getSender() == null : direction != NetworkDirection.LOGIN_TO_SERVER) {
                        return;
                    }
                    userHandler.accept((Object)msg, (Supplier<NetworkEvent.Context>)contextSupplier);
                };
            }
            if (flow == Flow.TO_CLIENT) {
                return (msg, contextSupplier) -> {
                    NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                    NetworkDirection direction = context.getDirection();
                    if (direction != NetworkDirection.PLAY_TO_CLIENT && direction != NetworkDirection.LOGIN_TO_CLIENT) {
                        return;
                    }
                    userHandler.accept((Object)msg, (Supplier<NetworkEvent.Context>)contextSupplier);
                };
            }
            return userHandler;
        }

        private static <MSG> BiConsumer<MSG, FriendlyByteBuf> findEncoder(Class<MSG> cls) {
            try {
                MethodHandle exact = MethodHandles.publicLookup().findStatic(cls, "encode", MethodType.methodType(Void.TYPE, cls, FriendlyByteBuf.class));
                MethodHandle adapted = exact.asType(MethodType.methodType(Void.TYPE, Object.class, FriendlyByteBuf.class));
                return (msg, byteBuf) -> {
                    try {
                        adapted.invokeExact(msg, (FriendlyByteBuf)byteBuf);
                    }
                    catch (Throwable throwable) {
                        throw Channel.sneaky(throwable);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException(Channel.sigErr(cls, "public static void encode(%s, FriendlyByteBuf)", cls.getSimpleName()), e);
            }
        }

        private static <MSG> Function<FriendlyByteBuf, MSG> findDecoder(Class<MSG> cls) {
            try {
                MethodHandle exact = MethodHandles.publicLookup().findStatic(cls, "decode", MethodType.methodType(cls, FriendlyByteBuf.class));
                MethodHandle adapted = exact.asType(MethodType.methodType(Object.class, FriendlyByteBuf.class));
                return buf -> {
                    try {
                        Object o = adapted.invokeExact((FriendlyByteBuf)buf);
                        return cls.cast(o);
                    }
                    catch (Throwable t) {
                        throw Channel.sneaky(t);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException(Channel.sigErr(cls, "public static %s decode(FriendlyByteBuf)", cls.getSimpleName()), e);
            }
        }

        private static <MSG> BiConsumer<MSG, Supplier<NetworkEvent.Context>> findHandler(Class<MSG> cls) {
            try {
                MethodHandle exact = MethodHandles.publicLookup().findStatic(cls, "handle", MethodType.methodType(Void.TYPE, cls, Supplier.class));
                MethodHandle adapted = exact.asType(MethodType.methodType(Void.TYPE, Object.class, Supplier.class));
                return (msg, context) -> {
                    try {
                        adapted.invokeExact(msg, (Supplier)context);
                    }
                    catch (Throwable throwable) {
                        throw Channel.sneaky(throwable);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException(Channel.sigErr(cls, "public static void handle(%s, Supplier<NetworkEvent.Context>)", cls.getSimpleName()), e);
            }
        }

        private static String sigErr(Class<?> cls, String fmt, Object ... args) {
            return "Packet class " + cls.getName() + " must declare: " + String.format(fmt, args);
        }

        private static int deriveId(String modid, Class<?> cls) {
            byte[] key = (modid + ":" + cls.getName()).getBytes(StandardCharsets.UTF_8);
            CRC32 crc = new CRC32();
            crc.update(key, 0, key.length);
            return (int)(crc.getValue() & 0xFFFFFFL);
        }

        private static RuntimeException sneaky(Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                return runtimeException;
            }
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                throw error;
            }
            return new RuntimeException(throwable);
        }
    }

    public static enum Flow {
        TO_SERVER(NetworkDirection.PLAY_TO_SERVER, NetworkDirection.LOGIN_TO_SERVER),
        TO_CLIENT(NetworkDirection.PLAY_TO_CLIENT, NetworkDirection.LOGIN_TO_CLIENT),
        BOTH(null, null);

        private final NetworkDirection playDir;
        private final NetworkDirection loginDir;

        private Flow(NetworkDirection playDir, NetworkDirection loginDir) {
            this.playDir = playDir;
            this.loginDir = loginDir;
        }

        Optional<NetworkDirection> playDirection() {
            return Optional.ofNullable(this.playDir);
        }

        Optional<NetworkDirection> loginDirection() {
            return Optional.ofNullable(this.loginDir);
        }
    }

    public static enum ThreadPolicy {
        MAIN,
        NETWORK;

    }
}

