/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.register;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;

public class DeferredRegisters {
    private final String modId;
    private final Map<IForgeRegistry<?>, DeferredRegister<?>> registries = new HashMap();
    private final Map<IForgeRegistry<?>, Boolean> hasEntries = new HashMap();
    private final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> vanillaRegistries = new HashMap();
    private final Map<ResourceKey<? extends Registry<?>>, Boolean> vanillaHasEntries = new HashMap();

    public DeferredRegisters(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public <T> DeferredRegister<T> getOrCreateRegistry(IForgeRegistry<T> registry) {
        return this.registries.computeIfAbsent(registry, r -> {
            this.hasEntries.put((IForgeRegistry<?>)r, false);
            return DeferredRegister.create((IForgeRegistry)registry, (String)this.modId);
        });
    }

    public <T> DeferredRegister<T> getOrCreateRegistry(ResourceKey<? extends Registry<T>> key) {
        ResourceKey k = key;
        return this.vanillaRegistries.computeIfAbsent(k, r -> {
            this.vanillaHasEntries.put((ResourceKey<Registry<?>>)r, false);
            return DeferredRegister.create((ResourceKey)key, (String)this.modId);
        });
    }

    public <T> void markHasEntries(IForgeRegistry<T> registry) {
        this.hasEntries.put(registry, true);
    }

    public <T> void markHasEntries(ResourceKey<? extends Registry<T>> key) {
        this.vanillaHasEntries.put(key, true);
    }

    public void register(IEventBus eventBus) {
        this.registries.forEach((registry, deferredRegister) -> {
            if (this.hasEntries.getOrDefault(registry, false).booleanValue()) {
                deferredRegister.register(eventBus);
            }
        });
        this.vanillaRegistries.forEach((key, deferredRegister) -> {
            if (this.vanillaHasEntries.getOrDefault(key, false).booleanValue()) {
                deferredRegister.register(eventBus);
            }
        });
    }
}

