/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen;

import com.eruannie_9.booklinggear.api.ModInfo;
import com.eruannie_9.booklinggear.api.ModInfoRegistry;
import com.eruannie_9.booklinggear.screen.MissingModsScreen;
import com.eruannie_9.booklinggear.screen.ModConfigSelectionScreen;
import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.visibility.animation.ButtonList;
import com.eruannie_9.booklinggear.screen.config.warning.JsonWarningList;
import com.eruannie_9.booklinggear.screen.config.warning.WarningMessageScreen;
import com.eruannie_9.booklinggear.util.scroll.ScrollSlider;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GeneralConfigScreen
extends Screen {
    private final Screen parentScreen;
    private ButtonList buttonList;
    private AnimatedScreenTitle animatedTitle;
    private static final int LIST_SPACING = 24;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 200;
    private static final int GAP_Y = 5;

    public GeneralConfigScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)"Bookling Gear Configuration"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        ArrayList<Button> mainButtons = new ArrayList<Button>();
        ArrayList<ModInfo> missingMods = new ArrayList<ModInfo>();
        for (ModInfo info : ModInfoRegistry.getAll()) {
            Button button;
            String modId = info.modid();
            Optional container = ModList.get().getModContainerById(modId);
            if (container.isEmpty()) {
                missingMods.add(info);
                continue;
            }
            String displayName = ((ModContainer)container.get()).getModInfo().getDisplayName();
            List<ModConfig> configs = this.getConfigsForMod(modId);
            if (configs.isEmpty()) {
                missingMods.add(info);
                continue;
            }
            if (configs.size() == 1) {
                ModConfig single = configs.get(0);
                if (single.getConfigData() == null) {
                    button = Button.m_253074_((Component)Component.m_237113_((String)displayName), b -> this.f_96541_.m_91152_((Screen)new WarningMessageScreen(this, "The configuration file for '" + displayName + "' is not loaded."))).m_252987_(0, 0, 200, 20).m_253136_();
                } else {
                    ForgeConfigSpec spec = (ForgeConfigSpec)single.getSpec();
                    button = Button.m_253074_((Component)Component.m_237113_((String)displayName), b -> this.f_96541_.m_91152_((Screen)new ConfigScreen(this, "Configuration for " + displayName, spec))).m_252987_(0, 0, 200, 20).m_253136_();
                }
            } else {
                button = Button.m_253074_((Component)Component.m_237113_((String)displayName), b -> this.f_96541_.m_91152_((Screen)new ModConfigSelectionScreen(this, displayName, configs))).m_252987_(0, 0, 200, 20).m_253136_();
            }
            mainButtons.add(button);
        }
        int listTop = 32;
        boolean narrow = this.f_96543_ < 460;
        int bannerH = narrow ? 80 : 60;
        int listBottom = this.f_96544_ - bannerH;
        this.buttonList = new ButtonList(this.f_96541_, this.f_96543_, this.f_96544_, listTop, listBottom, 24);
        this.m_7787_((GuiEventListener)this.buttonList);
        for (Button btn : mainButtons) {
            this.buttonList.addInstant(btn);
        }
        this.m_142416_((GuiEventListener)ScrollSlider.attach(this.buttonList).widget());
        int doneX = this.f_96543_ / 2 - 100;
        int doneY = this.f_96544_ - 27;
        Button doneButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.f_96541_.m_91152_(this.parentScreen)).m_252987_(doneX, doneY, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        Button resetButton = this.createResetWarningsButton();
        this.m_142416_((GuiEventListener)resetButton);
        if (!missingMods.isEmpty()) {
            Button missingButton = Button.m_253074_((Component)Component.m_237113_((String)("Missing Mods (" + missingMods.size() + ")")), b -> this.f_96541_.m_91152_((Screen)new MissingModsScreen(this, missingMods))).m_252987_(0, 0, 120, 20).m_253136_();
            this.m_142416_((GuiEventListener)missingButton);
            if (narrow) {
                int missingY = doneY - 20 - 5;
                int resetY = missingY - 20 - 5;
                missingButton.m_252865_(this.f_96543_ / 2 - missingButton.m_5711_() / 2);
                missingButton.m_253211_(missingY);
                resetButton.m_252865_(this.f_96543_ / 2 - resetButton.m_5711_() / 2);
                resetButton.m_253211_(resetY);
            } else {
                missingButton.m_252865_(this.f_96543_ - missingButton.m_5711_() - 10);
                missingButton.m_253211_(doneY);
                resetButton.m_252865_(this.f_96543_ / 2 - resetButton.m_5711_() / 2);
                resetButton.m_253211_(doneY - 20 - 5);
            }
        } else {
            resetButton.m_252865_(this.f_96543_ / 2 - resetButton.m_5711_() / 2);
            resetButton.m_253211_(doneY - 20 - 5);
        }
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.f_96539_.getString());
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.buttonList.tickAnimations();
        this.buttonList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.animatedTitle.render(guiGraphics, this.f_96547_, this.f_96543_);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_6574_(@NotNull Minecraft mc, int newWidth, int newHeight) {
        double scrollRatio = 0.0;
        if (this.buttonList != null && this.buttonList.m_93518_() > 0) {
            scrollRatio = this.buttonList.m_93517_() / (double)this.buttonList.m_93518_();
        }
        super.m_6574_(mc, newWidth, newHeight);
        if (this.buttonList != null && this.buttonList.m_93518_() > 0) {
            this.buttonList.m_93410_(scrollRatio * (double)this.buttonList.m_93518_());
        }
    }

    private Button createResetWarningsButton() {
        Button btn = Button.m_253074_((Component)Component.m_237113_((String)"Reset Warnings"), b -> {
            if (!b.f_93623_) {
                return;
            }
            JsonWarningList.reset();
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Warnings Restored"), (Component)Component.m_237113_((String)"All warning messages are back")));
            b.f_93623_ = false;
            b.m_93666_((Component)Component.m_237113_((String)"Warnings Reset"));
        }).m_252987_(0, 0, 110, 20).m_253136_();
        btn.f_93623_ = JsonWarningList.hasWarnings();
        return btn;
    }

    private List<ModConfig> getConfigsForMod(String modId) {
        ArrayList<ModConfig> collected = new ArrayList<ModConfig>();
        for (Set set : ConfigTracker.INSTANCE.configSets().values()) {
            for (ModConfig cfg : set) {
                if (!cfg.getModId().equals(modId) || !(cfg.getSpec() instanceof ForgeConfigSpec)) continue;
                collected.add(cfg);
            }
        }
        return collected;
    }
}

