/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.eruannie_9.booklinggear.screen.config.ConfigOptionList;
import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.GroupEntry;
import com.eruannie_9.booklinggear.screen.config.ValueEntry;
import com.eruannie_9.booklinggear.screen.config.WidgetFactory;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionConfigBuilder;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionEntry;
import com.eruannie_9.booklinggear.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public final class ConfigEntryCollector {
    public static List<ConfigOptionList.ConfigEntry> collect(ForgeConfigSpec specification, ConfigScreen parentScreen) {
        ArrayList<ConfigOptionList.ConfigEntry> entries = new ArrayList<ConfigOptionList.ConfigEntry>();
        HashSet<String> handledPositionKeys = new HashSet<String>();
        ConfigEntryCollector.recurse(new ArrayList<String>(), specification.getValues(), entries, specification, 0, parentScreen, handledPositionKeys);
        return entries;
    }

    private static void recurse(List<String> path, UnmodifiableConfig config, List<ConfigOptionList.ConfigEntry> entryList, ForgeConfigSpec specification, int depth, ConfigScreen screen, Set<String> handledPositionKeys) {
        for (Map.Entry entry : config.valueMap().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ArrayList<String> newPath = new ArrayList<String>(path);
            newPath.add(key);
            if (value instanceof ForgeConfigSpec.ConfigValue) {
                String display;
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                ButtonPositionConfigBuilder posButton = ButtonPositionConfigBuilder.findByConfig(configValue);
                if (posButton != null) {
                    String dedupKey = posButton.groupKey() != null ? posButton.groupKey() : posButton.id();
                    if (!handledPositionKeys.add(dedupKey)) continue;
                    display = posButton.label().getString();
                    entryList.add(new ButtonPositionEntry(display, posButton, depth, screen));
                    continue;
                }
                AbstractWidget widget = WidgetFactory.create(configValue);
                display = StringUtil.formatDisplayName(key);
                String comment = ConfigEntryCollector.commentOf(specification, newPath);
                entryList.add(new ValueEntry(display, configValue, widget, depth, comment, screen));
                continue;
            }
            if (!(value instanceof UnmodifiableConfig)) continue;
            UnmodifiableConfig subConfig = (UnmodifiableConfig)value;
            entryList.add(new GroupEntry(StringUtil.formatDisplayName(key), depth));
            ConfigEntryCollector.recurse(newPath, subConfig, entryList, specification, depth + 1, screen, handledPositionKeys);
        }
    }

    private static String commentOf(ForgeConfigSpec specification, List<String> path) {
        ForgeConfigSpec.ValueSpec valueSpec;
        Object raw = specification.getSpec().get(path);
        if (raw instanceof ForgeConfigSpec.ValueSpec && (valueSpec = (ForgeConfigSpec.ValueSpec)raw).getComment() != null) {
            return valueSpec.getComment();
        }
        return "";
    }
}

