/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.color;

import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.color.ColorUtil;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ColorPickerScreen
extends Screen {
    private static final int SQUARE = 100;
    private static final int BAR_W = 20;
    private static final int BAR_GAP = 3;
    private static final int PREVIEW_SZ = 40;
    private static final int HEX_W = 100;
    private static final int CTRL_W = 200;
    private static final int PADDING = 10;
    private static final int GAP = 10;
    private static final int HEADER_H = 60;
    private static final int FOOTER_H = 40;
    private static final int EXPAND_MS = 150;
    private static final int FADE_MS = 300;
    private static final int BASE_REACH = 1;
    private static final int MAX_REACH = 2;
    private static final float GRID_DENOM_F = Math.max(1.0f, 99.0f);
    private static final int GRID_DENOM_I = Math.max(1, 99);
    private static final float STICKY_EPS = 0.003921569f;
    private static final int OUTLINE_COLOR = -16777216;
    private static final int HEX_LABEL_GAP = 4;
    private static final float HASH_SCALE = 1.15f;
    private static final int RECENT_COLUMNS = 5;
    private static final int RECENT_ROWS = 2;
    private static final int RECENT_COUNT = 10;
    private static final int RECENT_SWATCH_SIZE = 10;
    private static final int RECENT_SWATCH_GAP = 4;
    private static final List<String> RECENT_COLORS = new ArrayList<String>();
    private int recentStartX;
    private int recentY;
    private final ConfigScreen parent;
    private final String fullPath;
    private final String initialHex;
    private long pressStartMs = 0L;
    private long releaseStartMs = 0L;
    private boolean draggingSquare = false;
    private boolean draggingHue = false;
    private float hue;
    private float saturation;
    private float brightness;
    private EditBox hexBox;
    private ColorSlider hueSlider;
    private ColorSlider saturationSlider;
    private ColorSlider brightnessSlider;
    private int squareX;
    private int squareY;
    private int barX;
    private int barY;
    private int panelX;
    private int panelY;
    private int panelW;
    private int panelH;
    private int headerY;
    private int footerY;
    private int headerStartX;
    private AnimatedScreenTitle animatedTitle;
    private boolean suppressHexResponder = false;
    private boolean firstInit = true;

    public ColorPickerScreen(ConfigScreen parent, String title, String fullPath, String currentHex) {
        super((Component)Component.m_237113_((String)("Pick " + title)));
        this.parent = parent;
        this.fullPath = fullPath;
        this.initialHex = currentHex == null || currentHex.isEmpty() ? "FFFFFF" : currentHex;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.firstInit) {
            this.parseHex(this.initialHex);
            ColorPickerScreen.rememberColor(ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness));
            this.firstInit = false;
        }
        this.computeLayout();
        this.m_169413_();
        int hashWidth = Math.round((float)this.f_96547_.m_92895_("#") * 1.15f);
        int headerContentW = 50 + hashWidth + 4 + 100;
        this.headerStartX = this.panelX + (this.panelW - headerContentW) / 2;
        int hexBoxHeight = 20;
        int hexY = this.headerY + (60 - hexBoxHeight) / 2;
        int hashX = this.headerStartX + 40 + 10;
        int hexX = hashX + hashWidth + 4;
        this.hexBox = new EditBox(this.f_96547_, hexX, hexY, 100, hexBoxHeight, (Component)Component.m_237119_());
        this.hexBox.m_94199_(6);
        this.hexBox.m_94144_(ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness));
        this.hexBox.m_94151_(this::onHexChanged);
        this.m_142416_((GuiEventListener)this.hexBox);
        int sliderH = 20;
        int sGap = 4;
        int innerY = this.headerY + 60 + 10;
        this.hueSlider = new ColorSlider(this.panelX + 10, innerY, 200, sliderH, "Hue", this.hue, this::onHue, this::commitCurrentColor);
        this.saturationSlider = new ColorSlider(this.panelX + 10, innerY + sliderH + sGap, 200, sliderH, "Saturation", this.saturation, this::onSaturation, this::commitCurrentColor);
        this.brightnessSlider = new ColorSlider(this.panelX + 10, innerY + 2 * (sliderH + sGap), 200, sliderH, "Brightness", this.brightness, this::onBrightness, this::commitCurrentColor);
        this.m_142416_((GuiEventListener)this.hueSlider);
        this.m_142416_((GuiEventListener)this.saturationSlider);
        this.m_142416_((GuiEventListener)this.brightnessSlider);
        int btnW = 60;
        int btnH = 20;
        int btnY = this.footerY + (40 - btnH) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252794_(this.panelX + (this.panelW - btnW * 2 - 10) / 2, btnY).m_253046_(btnW, btnH).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.m_7379_()).m_252794_(this.panelX + (this.panelW + 10) / 2, btnY).m_253046_(btnW, btnH).m_253136_());
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.f_96539_.getString());
        }
        this.animatedTitle.avoidRightEdge(() -> this.panelX + this.panelW);
    }

    private void computeLayout() {
        this.panelW = 220;
        this.panelH = 202;
        int groupW = 133 + this.panelW;
        int groupH = this.panelH;
        int originX = (this.f_96543_ - groupW) / 2;
        int originY = (this.f_96544_ - groupH) / 2;
        int recentBlockHeight = 24;
        this.squareX = originX;
        this.squareY = originY + (groupH - (110 + recentBlockHeight)) / 2;
        this.barX = this.squareX + 100 + 3;
        this.barY = this.squareY;
        this.panelX = this.barX + 20 + 10;
        this.headerY = this.panelY = originY;
        this.footerY = this.panelY + this.panelH - 40;
        int totalRowWidth = 66;
        this.recentStartX = this.squareX + (100 - totalRowWidth) / 2;
        this.recentY = this.squareY + 100 + 10;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280039_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.animatedTitle.render(guiGraphics, this.f_96547_, this.f_96543_);
        this.drawHueBar(guiGraphics);
        this.drawSquare(guiGraphics);
        this.drawRecentColors(guiGraphics, mouseX, mouseY);
        int previewX0 = this.headerStartX;
        int previewY0 = this.headerY + 10;
        int previewX1 = previewX0 + 40;
        int previewY1 = previewY0 + 40;
        int argb = ColorUtil.hexToARGB(ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness));
        guiGraphics.m_280509_(previewX0, previewY0, previewX1, previewY1, argb);
        this.drawColorOutlines(guiGraphics);
        this.drawHueCursor(guiGraphics);
        this.drawSquareCursor(guiGraphics);
        this.drawHexPrefix(guiGraphics);
    }

    public boolean m_6375_(double mx, double my, int btn) {
        if (btn == 0) {
            if (this.hexBox != null && !this.hexBox.m_5953_(mx, my)) {
                this.hexBox.m_93692_(false);
                this.m_7522_(null);
            }
            if (this.handleRecentClick(mx, my)) {
                return true;
            }
            if (ColorPickerScreen.in(mx, my, this.squareX, this.squareY, 100)) {
                this.draggingSquare = true;
                this.pressStartMs = Util.m_137550_();
                this.releaseStartMs = 0L;
                this.setSaturationBrightnessFromMouse(mx, my);
                return true;
            }
            if (ColorPickerScreen.in(mx, my, this.barX, this.barY, 20)) {
                this.draggingHue = true;
                this.setHueFromMouse(my);
                return true;
            }
        }
        return super.m_6375_(mx, my, btn);
    }

    public boolean m_7979_(double mx, double my, int btn, double dx, double dy) {
        if (btn == 0) {
            if (this.draggingSquare) {
                this.setSaturationBrightnessFromMouse(mx, my);
                return true;
            }
            if (this.draggingHue) {
                this.setHueFromMouse(my);
                return true;
            }
        }
        return super.m_7979_(mx, my, btn, dx, dy);
    }

    public boolean m_6348_(double mx, double my, int btn) {
        if (btn == 0) {
            if (this.draggingSquare) {
                this.draggingSquare = false;
                this.releaseStartMs = Util.m_137550_();
                this.commitCurrentColor();
                return true;
            }
            if (this.draggingHue) {
                this.draggingHue = false;
                this.commitCurrentColor();
                return true;
            }
        }
        return super.m_6348_(mx, my, btn);
    }

    private boolean handleRecentClick(double mx, double my) {
        int idx = this.getRecentIndexAt(mx, my);
        if (idx < 0 || idx >= RECENT_COLORS.size()) {
            return false;
        }
        String hex = RECENT_COLORS.get(idx);
        this.applyHexColor(hex);
        this.commitCurrentColor();
        return true;
    }

    private int getRecentIndexAt(double mx, double my) {
        for (int i = 0; i < 10; ++i) {
            int row = i / 5;
            int col = i % 5;
            int x0 = this.recentStartX + col * 14;
            int y0 = this.recentY + row * 14;
            int x1 = x0 + 10;
            int y1 = y0 + 10;
            if (!(mx >= (double)x0) || !(mx < (double)x1) || !(my >= (double)y0) || !(my < (double)y1)) continue;
            return i;
        }
        return -1;
    }

    private static void rememberColor(String hex) {
        if (hex == null) {
            return;
        }
        String normalized = hex.trim().toUpperCase(Locale.ROOT);
        if (!ColorUtil.isHexColor(normalized)) {
            return;
        }
        RECENT_COLORS.remove(normalized);
        RECENT_COLORS.add(0, normalized);
        if (RECENT_COLORS.size() > 10) {
            RECENT_COLORS.remove(RECENT_COLORS.size() - 1);
        }
    }

    private void commitCurrentColor() {
        ColorPickerScreen.rememberColor(ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness));
    }

    private void applyHexColor(String hex) {
        this.parseHex(hex);
        if (this.hueSlider != null) {
            this.hueSlider.setSilently(this.hue);
        }
        if (this.saturationSlider != null) {
            this.saturationSlider.setSilently(this.saturation);
        }
        if (this.brightnessSlider != null) {
            this.brightnessSlider.setSilently(this.brightness);
        }
        this.syncHex();
    }

    private void setHueFromMouse(double my) {
        this.hue = Mth.m_14036_((float)((float)((my - (double)this.barY) / (double)GRID_DENOM_F)), (float)0.0f, (float)1.0f);
        if (this.hueSlider != null) {
            this.hueSlider.setSilently(this.hue);
        }
        this.syncHex();
    }

    private void setSaturationBrightnessFromMouse(double mx, double my) {
        this.saturation = Mth.m_14036_((float)((float)((mx - (double)this.squareX) / (double)GRID_DENOM_F)), (float)0.0f, (float)1.0f);
        this.brightness = 1.0f - Mth.m_14036_((float)((float)((my - (double)this.squareY) / (double)GRID_DENOM_F)), (float)0.0f, (float)1.0f);
        if (this.saturationSlider != null) {
            this.saturationSlider.setSilently(this.saturation);
        }
        if (this.brightnessSlider != null) {
            this.brightnessSlider.setSilently(this.brightness);
        }
        this.syncHex();
    }

    private static boolean in(double px, double py, int x, int y, int w) {
        return px >= (double)x && px < (double)(x + w) && py >= (double)y && py < (double)(y + 100);
    }

    private static void drawRectOutline(GuiGraphics guiGraphics, int x0, int y0, int x1, int y1, int color) {
        guiGraphics.m_280509_(x0, y0, x1, y0 + 1, color);
        guiGraphics.m_280509_(x0, y1 - 1, x1, y1, color);
        guiGraphics.m_280509_(x0, y0, x0 + 1, y1, color);
        guiGraphics.m_280509_(x1 - 1, y0, x1, y1, color);
    }

    private void drawHexPrefix(GuiGraphics guiGraphics) {
        if (this.hexBox == null) {
            return;
        }
        int hexX = this.hexBox.m_252754_();
        int hexY = this.hexBox.m_252907_();
        int hexH = this.hexBox.m_93694_();
        int scaledW = Math.round((float)this.f_96547_.m_92895_("#") * 1.15f);
        int hashX = hexX - scaledW - 4;
        int hashY = hexY + Math.round(((float)hexH - 9.2f) / 2.0f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)hashX, (float)hashY, 0.0f);
        guiGraphics.m_280168_().m_85841_(1.15f, 1.15f, 1.0f);
        guiGraphics.m_280056_(this.f_96547_, "#", 0, 0, -1, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private void drawColorOutlines(GuiGraphics guiGraphics) {
        int sx0 = this.squareX - 1;
        int sy0 = this.squareY - 1;
        int sx1 = this.squareX + 100 + 1;
        int sy1 = this.squareY + 100 + 1;
        ColorPickerScreen.drawRectOutline(guiGraphics, sx0, sy0, sx1, sy1, -16777216);
        int bx0 = this.barX - 1;
        int by0 = this.barY - 1;
        int bx1 = this.barX + 20 + 1;
        int by1 = this.barY + 100 + 1;
        ColorPickerScreen.drawRectOutline(guiGraphics, bx0, by0, bx1, by1, -16777216);
        int px0 = this.headerStartX;
        int py0 = this.headerY + 10;
        int px1 = px0 + 40;
        int py1 = py0 + 40;
        ColorPickerScreen.drawRectOutline(guiGraphics, px0 - 1, py0 - 1, px1 + 1, py1 + 1, -16777216);
    }

    private void drawHueBar(GuiGraphics guiGraphics) {
        for (int i = 0; i < 100; ++i) {
            float t = (float)i / GRID_DENOM_F;
            guiGraphics.m_280509_(this.barX, this.barY + i, this.barX + 20, this.barY + i + 1, ColorPickerScreen.hsvToARGB(t, 1.0f, 1.0f));
        }
    }

    private void drawSquare(GuiGraphics guiGraphics) {
        for (int r = 0; r < 100; ++r) {
            float v = 1.0f - (float)r / GRID_DENOM_F;
            for (int c = 0; c < 100; ++c) {
                float s = (float)c / GRID_DENOM_F;
                guiGraphics.m_280509_(this.squareX + c, this.squareY + r, this.squareX + c + 1, this.squareY + r + 1, ColorPickerScreen.hsvToARGB(this.hue, s, v));
            }
        }
    }

    private void drawHueCursor(GuiGraphics guiGraphics) {
        int y = this.barY + Mth.m_14045_((int)Math.round(this.hue * (float)GRID_DENOM_I), (int)0, (int)99);
        guiGraphics.m_280509_(this.barX, y - 1, this.barX + 20, y + 1, -1);
    }

    private void drawSquareCursor(GuiGraphics guiGraphics) {
        int cx = this.squareX + Mth.m_14045_((int)Math.round(this.saturation * (float)GRID_DENOM_I), (int)0, (int)99);
        int cy = this.squareY + Mth.m_14045_((int)Math.round((1.0f - this.brightness) * (float)GRID_DENOM_I), (int)0, (int)99);
        guiGraphics.m_280509_(cx - 2, cy, cx + 3, cy + 1, -1);
        guiGraphics.m_280509_(cx, cy - 2, cx + 1, cy + 3, -1);
        long now = Util.m_137550_();
        if (this.draggingSquare) {
            float t = Mth.m_14036_((float)((float)(now - this.pressStartMs) / 150.0f), (float)0.0f, (float)1.0f);
            int reach = 1 + Math.round(1.0f * t);
            ColorPickerScreen.drawBurst(guiGraphics, cx, cy, reach, -1);
        } else if (this.releaseStartMs != 0L) {
            float t = (float)(now - this.releaseStartMs) / 300.0f;
            if (t >= 1.0f) {
                this.releaseStartMs = 0L;
                return;
            }
            int reach = Math.round(2.0f * (1.0f - t));
            int col = (int)((1.0f - t) * 255.0f) << 24 | 0xFFFFFF;
            ColorPickerScreen.drawBurst(guiGraphics, cx, cy, reach, col);
        }
    }

    private static void drawBurst(GuiGraphics guiGraphics, int cx, int cy, int reach, int col) {
        guiGraphics.m_280509_(cx - reach - 2, cy, cx + reach + 3, cy + 1, col);
        guiGraphics.m_280509_(cx, cy - reach - 2, cx + 1, cy + reach + 3, col);
    }

    private void drawRecentColors(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int hoveredIndex = this.getRecentIndexAt(mouseX, mouseY);
        String currentHex = ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness);
        int size = RECENT_COLORS.size();
        for (int i = 0; i < 10; ++i) {
            int row = i / 5;
            int col = i % 5;
            int baseX0 = this.recentStartX + col * 14;
            int baseY0 = this.recentY + row * 14;
            int baseX1 = baseX0 + 10;
            int baseY1 = baseY0 + 10;
            int extra = i == hoveredIndex ? 2 : 0;
            int x0 = baseX0 - extra;
            int y0 = baseY0 - extra;
            int x1 = baseX1 + extra;
            int y1 = baseY1 + extra;
            boolean hasColor = i < size;
            String hex = hasColor ? RECENT_COLORS.get(i) : null;
            int fill = hasColor ? ColorUtil.hexToARGB(hex) : -14671840;
            guiGraphics.m_280509_(x0, y0, x1, y1, fill);
            boolean isCurrent = hasColor && hex.equalsIgnoreCase(currentHex);
            int border = isCurrent ? -1 : -16777216;
            guiGraphics.m_280509_(x0 - 1, y0 - 1, x1 + 1, y0, border);
            guiGraphics.m_280509_(x0 - 1, y1, x1 + 1, y1 + 1, border);
            guiGraphics.m_280509_(x0 - 1, y0, x0, y1, border);
            guiGraphics.m_280509_(x1, y0, x1 + 1, y1, border);
        }
    }

    private void save() {
        String typed = this.hexBox.m_94155_().trim();
        if (!ColorUtil.isHexColor(typed)) {
            typed = ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness);
        }
        this.parent.onColorEdits(this.fullPath, typed);
        Minecraft.m_91087_().m_91152_((Screen)this.parent);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_((Screen)this.parent);
    }

    private void onHue(float v) {
        this.hue = v;
        this.syncHex();
    }

    private void onSaturation(float v) {
        this.saturation = v;
        this.syncHex();
    }

    private void onBrightness(float v) {
        this.brightness = v;
        this.syncHex();
    }

    private void setHexSilently(String hex) {
        if (this.hexBox == null) {
            return;
        }
        this.suppressHexResponder = true;
        this.hexBox.m_94144_(hex);
        this.suppressHexResponder = false;
    }

    private void syncHex() {
        this.setHexSilently(ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness));
    }

    private void parseHex(String hex) {
        float[] hsv = ColorPickerScreen.argbToHSV(ColorUtil.hexToARGB(hex));
        this.hue = hsv[0];
        this.saturation = hsv[1];
        this.brightness = hsv[2];
    }

    private static String hsvToHex(float h, float s, float v) {
        int rgb = Color.HSBtoRGB(h, s, v) & 0xFFFFFF;
        return String.format("%06X", rgb);
    }

    private static int hsvToARGB(float h, float s, float v) {
        return 0xFF000000 | Color.HSBtoRGB(h, s, v) & 0xFFFFFF;
    }

    private static float[] argbToHSV(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return Color.RGBtoHSB(r, g, b, null);
    }

    private void onHexChanged(String raw) {
        if (this.suppressHexResponder) {
            return;
        }
        String typed = raw.trim().toUpperCase(Locale.ROOT);
        if (!typed.equals(raw)) {
            int cursor = this.hexBox.m_94207_();
            this.suppressHexResponder = true;
            this.hexBox.m_94144_(typed);
            this.hexBox.m_94196_(cursor);
            this.hexBox.m_94208_(cursor);
            this.suppressHexResponder = false;
        }
        if (ColorUtil.isHexColor(typed)) {
            int argb = ColorUtil.hexToARGB(typed);
            float[] hsv = ColorPickerScreen.argbToHSV(argb);
            float newH = hsv[0];
            float newS = hsv[1];
            float newV = hsv[2];
            this.saturation = newS;
            this.brightness = newV;
            if (newV > 0.003921569f && newS > 0.003921569f) {
                this.hue = newH;
            }
            this.hueSlider.setSilently(this.hue);
            this.saturationSlider.setSilently(this.saturation);
            this.brightnessSlider.setSilently(this.brightness);
            this.commitCurrentColor();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ColorSlider
    extends AbstractSliderButton {
        private final String label;
        private final Consumer<Float> onChange;
        private final Runnable onRelease;

        ColorSlider(int x, int y, int w, int h, String label, float start, Consumer<Float> cb, Runnable releaseCallback) {
            super(x, y, w, h, (Component)Component.m_237113_((String)label), (double)start);
            this.label = label;
            this.onChange = cb;
            this.onRelease = releaseCallback;
            this.m_5695_();
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237113_((String)(this.label + ": " + Math.round(this.f_93577_ * 100.0) + "%")));
        }

        protected void m_5697_() {
            this.onChange.accept(Float.valueOf((float)this.f_93577_));
            this.m_5695_();
        }

        void setSilently(float v) {
            this.f_93577_ = v;
            this.m_5695_();
        }

        public void m_7691_(double mouseX, double mouseY) {
            super.m_7691_(mouseX, mouseY);
            if (this.onRelease != null) {
                this.onRelease.run();
            }
        }

        public boolean m_7933_(int key, int scan, int mods) {
            if (this.m_93696_()) {
                if (key == 265) {
                    this.f_93577_ = Mth.m_14008_((double)(this.f_93577_ + (double)0.01f), (double)0.0, (double)1.0);
                    this.m_5697_();
                    return true;
                }
                if (key == 264) {
                    this.f_93577_ = Mth.m_14008_((double)(this.f_93577_ - (double)0.01f), (double)0.0, (double)1.0);
                    this.m_5697_();
                    return true;
                }
            }
            return super.m_7933_(key, scan, mods);
        }
    }
}

