/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.drag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class ButtonPositionConfigBuilder {
    private static final Map<String, ButtonPositionConfigBuilder> OPTIONS_BY_ID = new HashMap<String, ButtonPositionConfigBuilder>();
    private static final Map<String, Screen> HOSTS = new HashMap<String, Screen>();
    private static final Map<String, Placement> PLACEMENTS = new HashMap<String, Placement>();
    private final String id;
    private final ForgeConfigSpec.IntValue offsetX;
    private final ForgeConfigSpec.IntValue offsetY;
    private final ScreenPredicate screenPredicate;
    private final ButtonGetter buttonGetter;
    private final PreviewFactory previewFactory;
    private final ActivePredicate activePredicate;
    private final Component label;
    private final HostScreenFactory hostScreenFactory;
    private final BasePosition basePosition;
    @Nullable
    private final String groupKey;

    public static void register(ButtonPositionConfigBuilder option) {
        OPTIONS_BY_ID.put(option.id(), option);
    }

    @Nullable
    public static ButtonPositionConfigBuilder get(String id) {
        return OPTIONS_BY_ID.get(id);
    }

    public static Collection<ButtonPositionConfigBuilder> all() {
        return Collections.unmodifiableCollection(OPTIONS_BY_ID.values());
    }

    @Nullable
    public static ButtonPositionConfigBuilder findByConfig(ForgeConfigSpec.ConfigValue<?> cfg) {
        for (ButtonPositionConfigBuilder opt : OPTIONS_BY_ID.values()) {
            if (opt.offsetX() != cfg && opt.offsetY() != cfg) continue;
            return opt;
        }
        return null;
    }

    public static void registerHost(String id, Screen screen) {
        HOSTS.put(id, screen);
    }

    @Nullable
    public static Screen getHost(String id) {
        return HOSTS.get(id);
    }

    public static void registerPlacement(String id, Screen hostScreen, int x, int y) {
        PLACEMENTS.put(id, new Placement(hostScreen, x, y));
    }

    @Nullable
    public static Placement getPlacement(String id) {
        return PLACEMENTS.get(id);
    }

    private ButtonPositionConfigBuilder(String id, ForgeConfigSpec.IntValue offsetX, ForgeConfigSpec.IntValue offsetY, ScreenPredicate screenPredicate, ButtonGetter buttonGetter, PreviewFactory previewFactory, ActivePredicate activePredicate, Component label, HostScreenFactory hostScreenFactory, BasePosition basePosition, @Nullable String groupKey) {
        this.id = id;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.screenPredicate = screenPredicate;
        this.buttonGetter = buttonGetter;
        this.previewFactory = previewFactory;
        this.activePredicate = activePredicate;
        this.label = label;
        this.hostScreenFactory = hostScreenFactory;
        this.basePosition = basePosition;
        this.groupKey = groupKey;
    }

    public String id() {
        return this.id;
    }

    public ForgeConfigSpec.IntValue offsetX() {
        return this.offsetX;
    }

    public ForgeConfigSpec.IntValue offsetY() {
        return this.offsetY;
    }

    public ScreenPredicate screenPredicate() {
        return this.screenPredicate;
    }

    public boolean matches(Screen screen) {
        return this.screenPredicate.test(screen);
    }

    public ButtonGetter buttonGetter() {
        return this.buttonGetter;
    }

    public PreviewFactory previewFactory() {
        return this.previewFactory;
    }

    public ActivePredicate activePredicate() {
        return this.activePredicate;
    }

    public Component label() {
        return this.label;
    }

    public HostScreenFactory hostScreenFactory() {
        return this.hostScreenFactory;
    }

    public BasePosition basePosition() {
        return this.basePosition;
    }

    @Nullable
    public String groupKey() {
        return this.groupKey;
    }

    public static Builder forButton(String id) {
        return new Builder(id);
    }

    public static Builder forButton(String id, ForgeConfigSpec.IntValue offsetX, ForgeConfigSpec.IntValue offsetY) {
        return new Builder(id).offsets(offsetX, offsetY);
    }

    public record Placement(Screen hostScreen, int x, int y) {
    }

    @FunctionalInterface
    public static interface ScreenPredicate {
        public boolean test(Screen var1);
    }

    @FunctionalInterface
    public static interface ButtonGetter {
        @Nullable
        public AbstractWidget get();
    }

    @FunctionalInterface
    public static interface PreviewFactory {
        public AbstractWidget create(int var1, int var2);
    }

    @FunctionalInterface
    public static interface ActivePredicate {
        public boolean isActive();
    }

    @FunctionalInterface
    public static interface HostScreenFactory {
        @Nullable
        public Screen create();
    }

    @FunctionalInterface
    public static interface BasePosition {
        public Point compute(int var1, int var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Builder {
        private final String id;
        private ForgeConfigSpec.IntValue offsetX;
        private ForgeConfigSpec.IntValue offsetY;
        private ScreenPredicate screenPredicate = s -> true;
        private ButtonGetter buttonGetter = () -> null;
        private PreviewFactory previewFactory = (x, y) -> Button.m_253074_((Component)Component.m_237113_((String)"Preview"), b -> {}).m_252987_(x, y, 80, 20).m_253136_();
        private ActivePredicate activePredicate = () -> true;
        private Component label;
        private HostScreenFactory hostScreenFactory = () -> null;
        private BasePosition basePosition = (w, h) -> new Point(w / 2, h / 2);
        private String groupKey;

        private Builder(String id) {
            this.id = id;
        }

        public Builder offsets(ForgeConfigSpec.IntValue offsetX, ForgeConfigSpec.IntValue offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            return this;
        }

        public Builder screen(ScreenPredicate predicate) {
            this.screenPredicate = predicate;
            return this;
        }

        public Builder screen(Class<? extends Screen> screenClass, HostScreenFactory hostFactory) {
            Objects.requireNonNull(screenClass, "screenClass");
            Objects.requireNonNull(hostFactory, "hostFactory");
            this.screenPredicate = screenClass::isInstance;
            this.hostScreenFactory = hostFactory;
            return this;
        }

        public Builder getter(ButtonGetter getter) {
            this.buttonGetter = getter;
            return this;
        }

        public Builder preview(PreviewFactory factory) {
            this.previewFactory = factory;
            return this;
        }

        public Builder activeWhen(ActivePredicate predicate) {
            this.activePredicate = predicate;
            return this;
        }

        public Builder label(Component label) {
            this.label = label;
            return this;
        }

        public Builder host(HostScreenFactory factory) {
            this.hostScreenFactory = factory;
            return this;
        }

        public Builder base(BasePosition basePosition) {
            this.basePosition = basePosition;
            return this;
        }

        public Builder group(String groupKey) {
            this.groupKey = groupKey;
            return this;
        }

        public ButtonPositionConfigBuilder build() {
            Objects.requireNonNull(this.offsetX, "offsetX");
            Objects.requireNonNull(this.offsetY, "offsetY");
            Objects.requireNonNull(this.screenPredicate, "screenPredicate");
            Objects.requireNonNull(this.buttonGetter, "buttonGetter");
            Objects.requireNonNull(this.previewFactory, "previewFactory");
            Objects.requireNonNull(this.activePredicate, "activePredicate");
            Objects.requireNonNull(this.hostScreenFactory, "hostScreenFactory");
            Objects.requireNonNull(this.basePosition, "basePosition");
            if (this.label == null) {
                this.label = Component.m_237113_((String)this.id);
            }
            return new ButtonPositionConfigBuilder(this.id, this.offsetX, this.offsetY, this.screenPredicate, this.buttonGetter, this.previewFactory, this.activePredicate, this.label, this.hostScreenFactory, this.basePosition, this.groupKey);
        }
    }

    public record Point(int x, int y) {
    }
}

