/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.drag;

import com.eruannie_9.booklinggear.screen.config.ConfigOptionList;
import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionConfigBuilder;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionScreen;
import com.eruannie_9.booklinggear.util.CommentText;
import com.eruannie_9.booklinggear.util.screen.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class ButtonPositionEntry
extends ConfigOptionList.ConfigEntry {
    private static final int INDENT = 10;
    private static final int RIGHT_RESERVED = 105;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 20;
    private static final int LABEL_LEFT_PADDING = 5;
    private static final String POSITION_COMMENT = "Adjust where this button appears on its screen.\nOpens a preview editor where you can move it.";
    private final String label;
    private final List<ButtonPositionConfigBuilder> options;
    private final Button editButton;

    public ButtonPositionEntry(String label, ButtonPositionConfigBuilder option, int depth, ConfigScreen parentScreen) {
        super(depth);
        this.label = Objects.requireNonNull(label, "label");
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(parentScreen, "parentScreen");
        this.options = ButtonPositionEntry.resolveGroup(option);
        this.editButton = Button.m_253074_((Component)Component.m_237113_((String)"Edit Position"), b -> {
            ButtonPositionConfigBuilder first = this.options.get(0);
            if (!first.activePredicate().isActive()) {
                return;
            }
            parentScreen.refreshCurrentValuesSnapshot();
            Minecraft.m_91087_().m_91152_((Screen)new ButtonPositionScreen(parentScreen, this.options, 0, (Component)Component.m_237113_((String)this.label)));
        }).m_252794_(0, 0).m_253046_(100, 20).m_253136_();
    }

    private static List<ButtonPositionConfigBuilder> resolveGroup(ButtonPositionConfigBuilder option) {
        String groupKey = option.groupKey();
        if (groupKey == null) {
            return Collections.singletonList(option);
        }
        ArrayList<ButtonPositionConfigBuilder> group = new ArrayList<ButtonPositionConfigBuilder>();
        for (ButtonPositionConfigBuilder opt : ButtonPositionConfigBuilder.all()) {
            if (!groupKey.equals(opt.groupKey())) continue;
            group.add(opt);
        }
        if (group.isEmpty()) {
            group.add(option);
        }
        group.sort(Comparator.comparing(ButtonPositionConfigBuilder::id));
        return Collections.unmodifiableList(group);
    }

    public void m_6311_(@NotNull GuiGraphics guiGraphics, int rowIndex, int yPos, int xPos, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        ConfigScreen screen;
        float progress = this.easedProgress();
        int slideOffset = this.slideX(rowWidth);
        int adjustedY = this.easedY(yPos);
        Font font = Minecraft.m_91087_().f_91062_;
        int maxLabelWidth = rowWidth - this.depth * 10 - 5 - 105;
        if (maxLabelWidth < 0) {
            maxLabelWidth = 0;
        }
        String display = TextUtil.abbreviate(font, this.label, maxLabelWidth);
        int labelX = xPos + this.depth * 10 + 5 + slideOffset;
        Objects.requireNonNull(font);
        int labelY = adjustedY + (rowHeight - 9) / 2;
        Screen screen2 = Minecraft.m_91087_().f_91080_;
        boolean tipsOn = screen2 instanceof ConfigScreen && (screen = (ConfigScreen)screen2).isTooltipEnabled();
        double d = mouseX;
        double d2 = mouseY;
        int n = font.m_92895_(display);
        Objects.requireNonNull(font);
        boolean overLabel = ButtonPositionEntry.in(d, d2, labelX, labelY, n, 9);
        int baseRGB = tipsOn && overLabel ? 0xFFFFA0 : 0xFFFFFF;
        int alpha = Math.round(progress * 255.0f) & 0xFF;
        int argb = alpha << 24 | baseRGB;
        guiGraphics.m_280056_(font, display, labelX, labelY, argb, false);
        if (tipsOn && overLabel) {
            this.queueTooltip(mouseX, mouseY);
        }
        this.editButton.m_93650_(progress);
        this.editButton.m_252865_(xPos + rowWidth - 105 + slideOffset);
        this.editButton.m_253211_(adjustedY + (rowHeight - this.editButton.m_93694_()) / 2);
        this.editButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void queueTooltip(int mouseX, int mouseY) {
        List<Component> lines = CommentText.toTooltipComponents(POSITION_COMMENT);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            configScreen.tooltipLines = lines;
            configScreen.tooltipX = mouseX;
            configScreen.tooltipY = mouseY;
        }
    }

    private static boolean in(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.editButton.m_5953_(mouseX, mouseY)) {
            return this.editButton.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

