/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.drag;

import com.eruannie_9.booklinggear.BooklingGearClient;
import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionConfigBuilder;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionToolbar;
import com.eruannie_9.booklinggear.screen.drag.ButtonPreviewContext;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonPositionPreview {
    private static final int NO_HOVER_MOUSE_X = -1073741824;
    private static final int NO_HOVER_MOUSE_Y = -1073741824;
    private static final ResourceLocation DIRT_BACKGROUND = new ResourceLocation("textures/gui/options_background.png");
    private static final int GRID_COLOR = 0x22FFFFFF;
    private static final int FRAME_COLOR = -1996488705;
    private final ConfigScreen parentScreen;
    private final List<ButtonPositionConfigBuilder> options;
    private final Map<ButtonPositionConfigBuilder, ButtonPositionConfigBuilder.Point> workingOffsets = new HashMap<ButtonPositionConfigBuilder, ButtonPositionConfigBuilder.Point>();
    private int currentIndex;
    private Minecraft minecraft;
    private int screenWidth;
    private int screenHeight;
    private Screen hostScreen;
    private AbstractWidget previewButton;
    private int baseX;
    private int baseY;
    private int previewLeft;
    private int previewTop;
    private int previewWidth;
    private int previewHeight;
    private float previewScale = 1.0f;
    private boolean dragging;
    private int dragOffsetX;
    private int dragOffsetY;
    private boolean hasDragAnchor;
    private int anchorRawX;
    private int anchorRawY;
    private int anchorButtonX;
    private int anchorButtonY;
    private int lastStep = 1;
    private float dragVisual = 0.0f;
    private GridMode gridMode = GridMode.OFF;
    private boolean shaderGlowEnabled = true;
    private boolean overlayGuidesEnabled = false;
    private ButtonPositionToolbar toolbar;

    public ButtonPositionPreview(ConfigScreen parentScreen, List<ButtonPositionConfigBuilder> options, int initialIndex) {
        this.parentScreen = Objects.requireNonNull(parentScreen, "parentScreen");
        Objects.requireNonNull(options, "options");
        if (options.isEmpty()) {
            throw new IllegalArgumentException("ButtonPositionPreview requires at least one PositionConfigOption");
        }
        this.options = List.copyOf(options);
        this.currentIndex = Mth.m_14045_((int)initialIndex, (int)0, (int)(this.options.size() - 1));
    }

    public void init(Minecraft minecraft, int screenWidth, int screenHeight) {
        this.minecraft = Objects.requireNonNull(minecraft, "minecraft");
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.computePreviewArea();
        this.setupContextPreview();
    }

    public void setToolbar(ButtonPositionToolbar toolbar) {
        this.toolbar = toolbar;
    }

    public int getPreviewLeft() {
        return this.previewLeft;
    }

    public int getPreviewTop() {
        return this.previewTop;
    }

    public int getPreviewWidth() {
        return this.previewWidth;
    }

    public int getPreviewRight() {
        return this.previewLeft + this.previewWidth;
    }

    public int getPreviewBottom() {
        return this.previewTop + this.previewHeight;
    }

    public GridMode getGridMode() {
        return this.gridMode;
    }

    public void setGridMode(GridMode mode) {
        this.gridMode = Objects.requireNonNull(mode, "mode");
    }

    public boolean isShaderGlowEnabled() {
        return this.shaderGlowEnabled;
    }

    public void setShaderGlowEnabled(boolean enabled) {
        this.shaderGlowEnabled = enabled;
    }

    public boolean isOverlayGuidesEnabled() {
        return this.overlayGuidesEnabled;
    }

    public void setOverlayGuidesEnabled(boolean enabled) {
        this.overlayGuidesEnabled = enabled;
    }

    public ButtonPositionConfigBuilder currentOption() {
        return this.options.get(this.currentIndex);
    }

    public List<ButtonPositionConfigBuilder> getOptions() {
        return this.options;
    }

    public Component currentHostTitle() {
        if (this.hostScreen != null) {
            return this.hostScreen.m_96636_();
        }
        return Component.m_237119_();
    }

    public boolean hasActivePreviewButton() {
        return this.previewButton != null;
    }

    public int getCurrentAbsX() {
        return this.previewButton != null ? this.previewButton.m_252754_() : 0;
    }

    public int getCurrentAbsY() {
        return this.previewButton != null ? this.previewButton.m_252907_() : 0;
    }

    public int getCurrentOffsetX() {
        return this.getCurrentAbsX() - this.baseX;
    }

    public int getCurrentOffsetY() {
        return this.getCurrentAbsY() - this.baseY;
    }

    private void computePreviewArea() {
        int availableWidth = this.screenWidth - 80;
        int availableHeight = this.screenHeight - 20 - 20 - 30;
        if (availableWidth <= 0 || availableHeight <= 0) {
            this.previewLeft = 0;
            this.previewTop = 0;
            this.previewWidth = this.screenWidth;
            this.previewHeight = this.screenHeight;
            this.previewScale = 1.0f;
            return;
        }
        float scaleX = (float)availableWidth / (float)this.screenWidth;
        float scaleY = (float)availableHeight / (float)this.screenHeight;
        this.previewScale = Math.min(Math.min(scaleX, scaleY), 1.0f);
        this.previewWidth = Mth.m_14143_((float)((float)this.screenWidth * this.previewScale));
        this.previewHeight = Mth.m_14143_((float)((float)this.screenHeight * this.previewScale));
        int extraX = availableWidth - this.previewWidth;
        int extraY = availableHeight - this.previewHeight;
        this.previewLeft = 40 + extraX / 2;
        this.previewTop = 20 + extraY / 2;
    }

    public boolean isInPreview(double mouseX, double mouseY) {
        return mouseX >= (double)this.previewLeft && mouseX < (double)this.getPreviewRight() && mouseY >= (double)this.previewTop && mouseY < (double)this.getPreviewBottom();
    }

    public int toLogicalX(double mouseX) {
        return Mth.m_14107_((double)((mouseX - (double)this.previewLeft) / (double)this.previewScale));
    }

    public int toLogicalY(double mouseY) {
        return Mth.m_14107_((double)((mouseY - (double)this.previewTop) / (double)this.previewScale));
    }

    private Minecraft minecraftOrClient() {
        return this.minecraft != null ? this.minecraft : Minecraft.m_91087_();
    }

    private void setupContextPreview() {
        this.previewButton = null;
        ButtonPositionConfigBuilder opt = this.currentOption();
        this.hostScreen = opt.hostScreenFactory().create();
        if (this.hostScreen != null) {
            this.hostScreen.m_6575_(this.minecraftOrClient(), this.screenWidth, this.screenHeight);
            AbstractWidget realButton = opt.buttonGetter().get();
            if (realButton != null && this.hostScreen.m_6702_().contains(realButton)) {
                realButton.f_93624_ = false;
                realButton.f_93623_ = false;
                realButton.m_93650_(0.0f);
            }
        }
        ButtonPositionConfigBuilder.Point base = opt.basePosition().compute(this.screenWidth, this.screenHeight);
        this.baseX = base.x();
        this.baseY = base.y();
        ButtonPositionConfigBuilder.Point offsets = this.workingOffsets.get(opt);
        if (offsets == null) {
            int offX = this.parentScreen.getIntValue(opt.offsetX());
            int offY = this.parentScreen.getIntValue(opt.offsetY());
            offsets = new ButtonPositionConfigBuilder.Point(offX, offY);
            this.workingOffsets.put(opt, offsets);
        }
        int logicalX = this.baseX + offsets.x();
        int logicalY = this.baseY + offsets.y();
        this.previewButton = opt.previewFactory().create(logicalX, logicalY);
        this.notifyPositionChanged();
    }

    private void applyOffsetsToCurrentOption() {
        if (this.previewButton == null) {
            return;
        }
        ButtonPositionConfigBuilder opt = this.currentOption();
        int newX = this.previewButton.m_252754_();
        int newY = this.previewButton.m_252907_();
        int newOffsetX = newX - this.baseX;
        int newOffsetY = newY - this.baseY;
        this.workingOffsets.put(opt, new ButtonPositionConfigBuilder.Point(newOffsetX, newOffsetY));
    }

    public void resetOffsetsForCurrent() {
        if (this.previewButton == null) {
            return;
        }
        this.previewButton.m_252865_(this.baseX);
        this.previewButton.m_253211_(this.baseY);
        ButtonPositionConfigBuilder opt = this.currentOption();
        this.workingOffsets.put(opt, new ButtonPositionConfigBuilder.Point(0, 0));
        this.notifyPositionChanged();
    }

    public void applyOffsetsFromFields(int offX, int offY) {
        if (this.previewButton == null) {
            return;
        }
        int targetX = this.clampLogicalX(this.baseX + offX);
        int targetY = this.clampLogicalY(this.baseY + offY);
        this.previewButton.m_252865_(targetX);
        this.previewButton.m_253211_(targetY);
        this.notifyPositionChanged();
    }

    public void switchToOption(ButtonPositionConfigBuilder opt) {
        int idx = this.options.indexOf(opt);
        if (idx < 0) {
            idx = 0;
        }
        this.currentIndex = idx;
        this.setupContextPreview();
    }

    public void applyAllOffsetsToParent(ConfigScreen parent) {
        for (Map.Entry<ButtonPositionConfigBuilder, ButtonPositionConfigBuilder.Point> entry : this.workingOffsets.entrySet()) {
            ButtonPositionConfigBuilder option = entry.getKey();
            ButtonPositionConfigBuilder.Point pt = entry.getValue();
            parent.onPositionEdits(option, pt.x(), pt.y());
        }
    }

    private void notifyPositionChanged() {
        this.applyOffsetsToCurrentOption();
        if (this.toolbar != null) {
            this.toolbar.updateOffsetsFromPreview();
        }
    }

    private void fillPreviewBackground(GuiGraphics guiGraphics) {
        int left = this.previewLeft;
        int top = this.previewTop;
        int right = this.getPreviewRight();
        int bottom = this.getPreviewBottom();
        guiGraphics.m_280588_(left, top, right, bottom);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)left, (float)top, 0.0f);
        pose.m_85841_(this.previewScale, this.previewScale, 1.0f);
        guiGraphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        int tile = 32;
        guiGraphics.m_280398_(DIRT_BACKGROUND, 0, 0, 0, 0.0f, 0.0f, this.screenWidth, this.screenHeight, tile, tile);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
        guiGraphics.m_280618_();
    }

    private void drawPreviewBorder(GuiGraphics guiGraphics) {
        int left = this.previewLeft;
        int top = this.previewTop;
        int right = this.getPreviewRight();
        int bottom = this.getPreviewBottom();
        int outerLeft = left - 1;
        int outerTop = top - 1;
        int outerRight = right + 1;
        int outerBottom = bottom + 1;
        int frameColor = -1996488705;
        guiGraphics.m_280509_(outerLeft, outerTop, outerRight, outerTop + 1, frameColor);
        guiGraphics.m_280509_(outerLeft, outerBottom - 1, outerRight, outerBottom, frameColor);
        guiGraphics.m_280509_(outerLeft, outerTop, outerLeft + 1, outerBottom, frameColor);
        guiGraphics.m_280509_(outerRight - 1, outerTop, outerRight, outerBottom, frameColor);
    }

    private void drawGrid(GuiGraphics guiGraphics) {
        GridMode mode = this.gridMode;
        if (!mode.hasGrid()) {
            return;
        }
        int logicalSpacing = mode.spacing();
        if (logicalSpacing <= 0) {
            return;
        }
        int color = 0x22FFFFFF;
        int left = this.previewLeft;
        int right = this.getPreviewRight();
        int top = this.previewTop;
        int bottom = this.getPreviewBottom();
        float rawStep = (float)logicalSpacing * this.previewScale;
        int step = Math.round(rawStep);
        if (step < 1) {
            step = 1;
        }
        if (logicalSpacing == 1) {
            if (step < 2) {
                step = 2;
            }
            for (int x = left; x < right; x += step) {
                guiGraphics.m_280509_(x, top, x + 1, bottom, color);
            }
            return;
        }
        if (step <= 0) {
            return;
        }
        for (int x = left; x < right; x += step) {
            guiGraphics.m_280509_(x, top, x + 1, bottom, color);
        }
        for (int y = top; y < bottom; y += step) {
            guiGraphics.m_280509_(left, y, right, y + 1, color);
        }
    }

    private void drawPreviewGuides(GuiGraphics guiGraphics) {
        if (!this.overlayGuidesEnabled) {
            return;
        }
        if (this.previewWidth <= 0 || this.previewHeight <= 0) {
            return;
        }
        int left = this.previewLeft;
        int right = this.getPreviewRight();
        int top = this.previewTop;
        int bottom = this.getPreviewBottom();
        int cx = left + this.previewWidth / 2;
        int cy = top + this.previewHeight / 2;
        int centerLineColor = 0x40FFFFFF;
        int marginColor = 1090494464;
        guiGraphics.m_280509_(cx, top, cx + 1, bottom, centerLineColor);
        guiGraphics.m_280509_(left, cy, right, cy + 1, centerLineColor);
        int marginX = Math.round((float)this.previewWidth * 0.1f);
        int marginY = Math.round((float)this.previewHeight * 0.1f);
        int ml = left + marginX;
        int mr = right - marginX;
        int mt = top + marginY;
        int mb = bottom - marginY;
        if (ml < mr && mt < mb) {
            guiGraphics.m_280509_(ml, mt, mr, mt + 1, marginColor);
            guiGraphics.m_280509_(ml, mb - 1, mr, mb, marginColor);
            guiGraphics.m_280509_(ml, mt, ml + 1, mb, marginColor);
            guiGraphics.m_280509_(mr - 1, mt, mr, mb, marginColor);
        }
    }

    private void drawPreviewGlowWithShader() {
        Uniform colorU;
        Uniform dragU;
        Uniform halfSizeU;
        Uniform timeU;
        Uniform radiusU;
        if (this.previewButton == null) {
            return;
        }
        if (!this.shaderGlowEnabled) {
            return;
        }
        ShaderInstance shader = BooklingGearClient.BUTTON_GLOW_SHADER;
        if (shader == null) {
            return;
        }
        int lx = this.previewButton.m_252754_();
        int ly = this.previewButton.m_252907_();
        int lw = this.previewButton.m_5711_();
        int lh = this.previewButton.m_93694_();
        float xScreen = (float)this.previewLeft + (float)lx * this.previewScale;
        float yScreen = (float)this.previewTop + (float)ly * this.previewScale;
        float wScreen = (float)lw * this.previewScale;
        float hScreen = (float)lh * this.previewScale;
        float cxGui = xScreen + wScreen / 2.0f;
        float cyGui = yScreen + hScreen / 2.0f;
        Minecraft mc = this.minecraftOrClient();
        Window window = mc.m_91268_();
        float guiScale = (float)window.m_85449_();
        float cx = cxGui * guiScale;
        float cy = ((float)this.screenHeight - cyGui) * guiScale;
        float halfW = wScreen * guiScale / 2.0f;
        float halfH = hScreen * guiScale / 2.0f;
        float radiusGui = Math.max(wScreen, hScreen) * 0.4f;
        float radius = radiusGui * guiScale;
        float timeSeconds = (float)(System.currentTimeMillis() % 100000L) / 1000.0f;
        Uniform centerU = shader.m_173348_("Center");
        if (centerU != null) {
            centerU.m_7971_(cx, cy);
        }
        if ((radiusU = shader.m_173348_("Radius")) != null) {
            radiusU.m_5985_(radius);
        }
        if ((timeU = shader.m_173348_("Time")) != null) {
            timeU.m_5985_(timeSeconds);
        }
        if ((halfSizeU = shader.m_173348_("ButtonHalfSize")) != null) {
            halfSizeU.m_7971_(halfW, halfH);
        }
        if ((dragU = shader.m_173348_("Drag")) != null) {
            dragU.m_5985_(this.dragVisual);
        }
        if ((colorU = shader.m_173348_("Color")) != null) {
            float r = 1.0f;
            float g = 0.82f;
            float b = 0.36f;
            float a = 0.8f;
            colorU.m_5805_(r, g, b, a);
        }
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(() -> shader);
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        float z = 0.0f;
        buf.m_5483_((double)this.previewLeft, (double)this.getPreviewBottom(), (double)z).m_5752_();
        buf.m_5483_((double)this.getPreviewRight(), (double)this.getPreviewBottom(), (double)z).m_5752_();
        buf.m_5483_((double)this.getPreviewRight(), (double)this.previewTop, (double)z).m_5752_();
        buf.m_5483_((double)this.previewLeft, (double)this.previewTop, (double)z).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderBehindWidgets(GuiGraphics guiGraphics, float partialTicks) {
        this.fillPreviewBackground(guiGraphics);
        if (this.hostScreen != null) {
            int left = this.previewLeft;
            int top = this.previewTop;
            int right = this.getPreviewRight();
            int bottom = this.getPreviewBottom();
            guiGraphics.m_280588_(left, top, right, bottom);
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)left, (float)top, 0.0f);
            pose.m_85841_(this.previewScale, this.previewScale, 1.0f);
            ButtonPreviewContext.beginPreview();
            try {
                this.hostScreen.m_88315_(guiGraphics, -1073741824, -1073741824, partialTicks);
            }
            finally {
                ButtonPreviewContext.endPreview();
            }
            pose.m_85849_();
            guiGraphics.m_280618_();
        }
        this.drawGrid(guiGraphics);
        this.drawPreviewGuides(guiGraphics);
        float targetDrag = this.dragging ? 1.0f : 0.0f;
        this.dragVisual = Mth.m_14179_((float)0.02f, (float)this.dragVisual, (float)targetDrag);
        this.drawPreviewGlowWithShader();
    }

    public void renderAboveWidgets(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.previewButton == null) {
            return;
        }
        int left = this.previewLeft;
        int top = this.previewTop;
        int right = this.getPreviewRight();
        int bottom = this.getPreviewBottom();
        guiGraphics.m_280588_(left, top, right, bottom);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)left, (float)top, 0.0f);
        pose.m_85841_(this.previewScale, this.previewScale, 1.0f);
        int logicalMouseX = this.toLogicalX(mouseX);
        int logicalMouseY = this.toLogicalY(mouseY);
        this.previewButton.m_88315_(guiGraphics, logicalMouseX, logicalMouseY, partialTicks);
        pose.m_85849_();
        guiGraphics.m_280618_();
        this.drawPreviewBorder(guiGraphics);
    }

    public void snapPreviewToGrid() {
        if (this.previewButton == null) {
            return;
        }
        if (!this.gridMode.hasGrid()) {
            return;
        }
        int spacing = this.gridMode.spacing();
        if (spacing <= 1) {
            return;
        }
        int x = this.previewButton.m_252754_();
        int y = this.previewButton.m_252907_();
        int snappedX = Math.round((float)x / (float)spacing) * spacing;
        int snappedY = Math.round((float)y / (float)spacing) * spacing;
        snappedX = this.clampLogicalX(snappedX);
        snappedY = this.clampLogicalY(snappedY);
        this.previewButton.m_252865_(snappedX);
        this.previewButton.m_253211_(snappedY);
        this.notifyPositionChanged();
    }

    private int movementStep() {
        boolean ctrl = Screen.m_96637_();
        boolean shift = Screen.m_96638_();
        if (ctrl && shift) {
            return 20;
        }
        if (shift) {
            return 10;
        }
        if (ctrl) {
            return 5;
        }
        return 1;
    }

    private int clampLogicalX(int x) {
        if (this.previewButton == null) {
            return x;
        }
        int minX = 0;
        int maxX = this.screenWidth - this.previewButton.m_5711_();
        return Mth.m_14045_((int)x, (int)minX, (int)maxX);
    }

    private int clampLogicalY(int y) {
        if (this.previewButton == null) {
            return y;
        }
        int minY = 0;
        int maxY = this.screenHeight - this.previewButton.m_93694_();
        return Mth.m_14045_((int)y, (int)minY, (int)maxY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.previewButton != null && this.isInPreview(mouseX, mouseY)) {
            int logicalMouseX = this.toLogicalX(mouseX);
            int logicalMouseY = this.toLogicalY(mouseY);
            if (logicalMouseX >= this.previewButton.m_252754_() && logicalMouseX < this.previewButton.m_252754_() + this.previewButton.m_5711_() && logicalMouseY >= this.previewButton.m_252907_() && logicalMouseY < this.previewButton.m_252907_() + this.previewButton.m_93694_()) {
                this.dragging = true;
                this.dragOffsetX = logicalMouseX - this.previewButton.m_252754_();
                this.dragOffsetY = logicalMouseY - this.previewButton.m_252907_();
                this.hasDragAnchor = false;
                this.lastStep = this.movementStep();
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            this.hasDragAnchor = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button) {
        if (this.dragging && button == 0 && this.previewButton != null) {
            int spacing;
            int logicalMouseX = this.toLogicalX(mouseX);
            int logicalMouseY = this.toLogicalY(mouseY);
            int rawX = logicalMouseX - this.dragOffsetX;
            int rawY = logicalMouseY - this.dragOffsetY;
            int step = this.movementStep();
            if (!this.hasDragAnchor || step != this.lastStep) {
                this.hasDragAnchor = true;
                this.lastStep = step;
                this.anchorRawX = rawX;
                this.anchorRawY = rawY;
                this.anchorButtonX = this.previewButton.m_252754_();
                this.anchorButtonY = this.previewButton.m_252907_();
            }
            int dx = rawX - this.anchorRawX;
            int dy = rawY - this.anchorRawY;
            int snappedDx = step <= 1 ? dx : Math.round((float)dx / (float)step) * step;
            int snappedDy = step <= 1 ? dy : Math.round((float)dy / (float)step) * step;
            int newX = this.anchorButtonX + snappedDx;
            int newY = this.anchorButtonY + snappedDy;
            if (this.gridMode.hasGrid() && !Screen.m_96637_() && !Screen.m_96638_() && (spacing = this.gridMode.spacing()) > 1) {
                newX = Math.round((float)newX / (float)spacing) * spacing;
                newY = Math.round((float)newY / (float)spacing) * spacing;
            }
            newX = this.clampLogicalX(newX);
            newY = this.clampLogicalY(newY);
            this.previewButton.m_252865_(newX);
            this.previewButton.m_253211_(newY);
            this.notifyPositionChanged();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode) {
        if (this.previewButton == null) {
            return false;
        }
        int step = this.movementStep();
        int dx = 0;
        int dy = 0;
        if (keyCode == 263) {
            dx = -step;
        } else if (keyCode == 262) {
            dx = step;
        } else if (keyCode == 265) {
            dy = -step;
        } else if (keyCode == 264) {
            dy = step;
        }
        if (dx != 0 || dy != 0) {
            int newX = this.clampLogicalX(this.previewButton.m_252754_() + dx);
            int newY = this.clampLogicalY(this.previewButton.m_252907_() + dy);
            this.previewButton.m_252865_(newX);
            this.previewButton.m_253211_(newY);
            this.notifyPositionChanged();
            return true;
        }
        return false;
    }

    public static enum GridMode {
        OFF(0, (Component)Component.m_237113_((String)"Off")),
        ONE(1, (Component)Component.m_237113_((String)"1 px")),
        FIVE(5, (Component)Component.m_237113_((String)"5 px")),
        TEN(10, (Component)Component.m_237113_((String)"10 px")),
        TWENTY(20, (Component)Component.m_237113_((String)"20 px"));

        private final int spacing;
        private final Component label;

        private GridMode(int spacing, Component label) {
            this.spacing = spacing;
            this.label = label;
        }

        public int spacing() {
            return this.spacing;
        }

        public Component label() {
            return this.label;
        }

        public boolean hasGrid() {
            return this.spacing > 0;
        }
    }
}

