/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.drag;

import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionConfigBuilder;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionPreview;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionToolbar;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButtonPositionScreen
extends Screen {
    static final int FOOTER_BUTTON_WIDTH = 80;
    static final int FOOTER_BUTTON_HEIGHT = 20;
    static final int FOOTER_BUTTON_GAP = 5;
    static final int FOOTER_BOTTOM_MARGIN = 20;
    static final int SIDE_BAR_WIDTH = 40;
    static final int TOP_MARGIN = 20;
    static final int BOTTOM_BAR_HEIGHT = 30;
    static final int CONTROL_HEIGHT = 20;
    private static final CubeMap CUBE_MAP = new CubeMap(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private final PanoramaRenderer panorama = new PanoramaRenderer(CUBE_MAP);
    private final ConfigScreen parentScreen;
    private final ButtonPositionPreview preview;
    private ButtonPositionToolbar toolbar;
    private Button infoButton;
    private List<Component> infoTooltipLines;

    public ButtonPositionScreen(ConfigScreen parentScreen, List<ButtonPositionConfigBuilder> options, int initialIndex, Component title) {
        super(title);
        this.parentScreen = Objects.requireNonNull(parentScreen, "parentScreen");
        Objects.requireNonNull(options, "options");
        if (options.isEmpty()) {
            throw new IllegalArgumentException("GuiButtonPositionScreen requires at least one PositionConfigOption");
        }
        this.preview = new ButtonPositionPreview(parentScreen, options, initialIndex);
    }

    Font getFont() {
        return this.f_96547_;
    }

    int getWidth() {
        return this.f_96543_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.preview.init(this.f_96541_, this.f_96543_, this.f_96544_);
        this.toolbar = new ButtonPositionToolbar(this, this.preview);
        this.preview.setToolbar(this.toolbar);
        this.toolbar.init();
        this.addFooterButtons();
        this.toolbar.updateOffsetsFromPreview();
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        AbstractWidget widget;
        this.renderPanoramaBackground(guiGraphics, partialTicks);
        this.preview.renderBehindWidgets(guiGraphics, partialTicks);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 1000.0f);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        GuiEventListener focused = this.m_7222_();
        if (focused instanceof AbstractWidget && !((widget = (AbstractWidget)focused) instanceof EditBox) && !widget.m_5953_((double)mouseX, (double)mouseY)) {
            widget.m_93692_(false);
            this.m_7522_(null);
        }
        Font font = this.f_96547_;
        int topRegionHeight = this.preview.getPreviewTop();
        int n = topRegionHeight / 2;
        Objects.requireNonNull(font);
        int titleY = Math.max(4, n - 9 / 2);
        Component screenTitle = this.preview.currentHostTitle();
        Component combinedTitle = this.f_96539_;
        if (screenTitle != null && !screenTitle.getString().isEmpty()) {
            combinedTitle = this.f_96539_.m_6881_().m_7220_((Component)Component.m_237113_((String)" (")).m_7220_(screenTitle).m_7220_((Component)Component.m_237113_((String)")"));
        }
        guiGraphics.m_280653_(font, combinedTitle, this.f_96543_ / 2, titleY, 0xFFFFFF);
        if (this.toolbar != null) {
            this.toolbar.renderLabels(guiGraphics);
        }
        this.preview.renderAboveWidgets(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.infoButton != null && this.infoButton.m_5953_((double)mouseX, (double)mouseY) && this.infoTooltipLines != null && !this.infoTooltipLines.isEmpty() && (this.parentScreen == null || this.parentScreen.isTooltipEnabled())) {
            guiGraphics.m_280666_(font, this.infoTooltipLines, mouseX, mouseY);
        }
        pose.m_85849_();
    }

    private void renderPanoramaBackground(GuiGraphics guiGraphics, float partialTicks) {
        this.panorama.m_110003_(partialTicks, 1.0f);
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280411_(PANORAMA_OVERLAY, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 128, 16, 128);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int darkColor = -2013265920;
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, darkColor);
        RenderSystem.disableBlend();
    }

    private FooterButtonPos footerButtonPos(int index, int buttonWidth, int rowWidth) {
        int topLimit = this.preview.getPreviewBottom();
        int bottomLimit = this.f_96544_ - 20;
        int marginX = 8;
        int rowMaxWidth = Math.max(0, this.preview.getPreviewWidth() - marginX * 2);
        int y = bottomLimit - 20 + 5;
        int minY = topLimit + 4;
        if (y < minY) {
            y = minY;
        }
        int startX = rowMaxWidth > 0 ? this.preview.getPreviewLeft() + marginX + (rowMaxWidth - rowWidth) / 2 : (this.f_96543_ - rowWidth) / 2;
        int x = startX + index * (buttonWidth + 5);
        return new FooterButtonPos(x, y);
    }

    private void addFooterButtons() {
        int maxButtonWidthAllowed;
        int buttonCount = 2;
        int marginX = 8;
        int rowMaxWidth = Math.max(0, this.preview.getPreviewWidth() - marginX * 2);
        int buttonWidth = 80;
        if (rowMaxWidth > 0 && (maxButtonWidthAllowed = (rowMaxWidth - 5 * (buttonCount - 1)) / buttonCount) > 0) {
            buttonWidth = Math.min(80, maxButtonWidthAllowed);
        }
        int rowWidth = buttonCount * buttonWidth + 5 * (buttonCount - 1);
        FooterButtonPos savePos = this.footerButtonPos(0, buttonWidth, rowWidth);
        FooterButtonPos cancelPos = this.footerButtonPos(1, buttonWidth, rowWidth);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> {
            if (this.toolbar != null) {
                this.toolbar.applyOffsetsFromFields();
            }
            this.preview.applyAllOffsetsToParent(this.parentScreen);
            Minecraft.m_91087_().m_91152_((Screen)this.parentScreen);
        }).m_252794_(savePos.x(), savePos.y()).m_253046_(buttonWidth, 20).m_253136_());
        Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> Minecraft.m_91087_().m_91152_((Screen)this.parentScreen)).m_252794_(cancelPos.x(), cancelPos.y()).m_253046_(buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
        this.infoTooltipLines = List.of(Component.m_237113_((String)"Optional: Use the arrow keys to move the button. Hold Ctrl for 5 px, Shift for 10 px, or Ctrl+Shift for 20 px movement."));
        int infoSize = 20;
        int infoGap = 4;
        int infoX = cancelPos.x() + buttonWidth + infoGap;
        int infoY = cancelPos.y() + (20 - infoSize) / 2;
        this.infoButton = Button.m_253074_((Component)Component.m_237113_((String)"?"), b -> {}).m_252794_(infoX, infoY).m_253046_(infoSize, infoSize).build(SilentInfoButton::new);
        this.m_142416_((GuiEventListener)this.infoButton);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.toolbar != null && this.toolbar.handleMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.preview.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.preview.mouseReleased(button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.preview.mouseDragged(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.toolbar != null && this.toolbar.handleKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.preview.keyPressed(keyCode)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public <T extends GuiEventListener & Renderable> void addToolbarWidget(T widget) {
        super.m_142416_(widget);
    }

    private record FooterButtonPos(int x, int y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class SilentInfoButton
    extends Button {
        protected SilentInfoButton(Button.Builder builder) {
            super(builder);
        }

        public void m_7435_(@NotNull SoundManager soundManager) {
        }
    }
}

