/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.drag;

import com.eruannie_9.booklinggear.screen.drag.ButtonPositionConfigBuilder;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionPreview;
import com.eruannie_9.booklinggear.screen.drag.ButtonPositionScreen;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonPositionToolbar {
    private static final int LABEL_COLOR = -2039584;
    private static final int LABEL_TOP_GAP = 3;
    private static final int LABEL_BOTTOM_GAP = 2;
    private static final int RIGHT_LABEL_TOP_GAP = 4;
    private static final int RIGHT_LABEL_BOTTOM_GAP = 3;
    private final ButtonPositionScreen parent;
    private final ButtonPositionPreview preview;
    private EditBox offsetXField;
    private EditBox offsetYField;
    private EditBox absoluteXField;
    private EditBox absoluteYField;
    private boolean updatingOffsetFields;
    private CycleButton<ButtonPositionConfigBuilder> screenSelector;
    private CycleButton<ButtonPositionPreview.GridMode> gridSelector;
    private CycleButton<Boolean> shaderToggleButton;
    private CycleButton<Boolean> guidesToggleButton;

    public ButtonPositionToolbar(ButtonPositionScreen parent, ButtonPositionPreview preview) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.preview = Objects.requireNonNull(preview, "preview");
    }

    public void init() {
        this.addRightColumnTools();
        this.addSideToolbar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOffsetsFromPreview() {
        if (this.updatingOffsetFields) {
            return;
        }
        if (!this.preview.hasActivePreviewButton()) {
            return;
        }
        this.updatingOffsetFields = true;
        try {
            int absX = this.preview.getCurrentAbsX();
            int absY = this.preview.getCurrentAbsY();
            int offsetX = this.preview.getCurrentOffsetX();
            int offsetY = this.preview.getCurrentOffsetY();
            if (this.offsetXField != null) {
                this.offsetXField.m_94144_(Integer.toString(offsetX));
            }
            if (this.offsetYField != null) {
                this.offsetYField.m_94144_(Integer.toString(offsetY));
            }
            if (this.absoluteXField != null) {
                this.absoluteXField.m_94144_(Integer.toString(absX));
            }
            if (this.absoluteYField != null) {
                this.absoluteYField.m_94144_(Integer.toString(absY));
            }
        }
        finally {
            this.updatingOffsetFields = false;
        }
    }

    public void applyOffsetsFromFields() {
        if (this.updatingOffsetFields) {
            return;
        }
        if (!this.preview.hasActivePreviewButton()) {
            return;
        }
        int currentOffsetX = this.preview.getCurrentOffsetX();
        int currentOffsetY = this.preview.getCurrentOffsetY();
        int offX = this.parseOffsetField(this.offsetXField, currentOffsetX);
        int offY = this.parseOffsetField(this.offsetYField, currentOffsetY);
        this.preview.applyOffsetsFromFields(offX, offY);
    }

    private int parseOffsetField(EditBox box, int fallback) {
        if (box == null) {
            return fallback;
        }
        String text = box.m_94155_().trim();
        if (text.isEmpty()) {
            return fallback;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    private void addRightColumnTools() {
        Font font = this.parent.getFont();
        if (font == null) {
            return;
        }
        int marginX = 8;
        int zoneLeft = this.preview.getPreviewRight();
        int zoneRight = this.parent.getWidth();
        int availableWidth = Math.max(0, zoneRight - zoneLeft - marginX * 2);
        if (availableWidth <= 0) {
            return;
        }
        int colWidth = Math.min(80, availableWidth);
        int x = zoneLeft + marginX + (availableWidth - colWidth) / 2;
        Objects.requireNonNull(font);
        int labelHeight = 9;
        int fieldHeight = 20;
        int baseTop = this.preview.getPreviewTop() + 4;
        int labelY = baseTop + 4;
        int widgetY = labelY + labelHeight + 3;
        this.offsetXField = new EditBox(font, x, widgetY, colWidth, fieldHeight, (Component)Component.m_237113_((String)"Offset X"));
        this.offsetXField.m_94199_(7);
        this.parent.addToolbarWidget(this.offsetXField);
        labelY = widgetY + fieldHeight + 4;
        widgetY = labelY + labelHeight + 3;
        this.offsetYField = new EditBox(font, x, widgetY, colWidth, fieldHeight, (Component)Component.m_237113_((String)"Offset Y"));
        this.offsetYField.m_94199_(7);
        this.parent.addToolbarWidget(this.offsetYField);
        labelY = widgetY + fieldHeight + 4;
        widgetY = labelY + labelHeight + 3;
        this.absoluteXField = new EditBox(font, x, widgetY, colWidth, fieldHeight, (Component)Component.m_237113_((String)"Absolute X"));
        this.absoluteXField.m_94199_(7);
        this.absoluteXField.m_94186_(false);
        this.absoluteXField.m_94205_(-1);
        this.parent.addToolbarWidget(this.absoluteXField);
        labelY = widgetY + fieldHeight + 4;
        widgetY = labelY + labelHeight + 3;
        this.absoluteYField = new EditBox(font, x, widgetY, colWidth, fieldHeight, (Component)Component.m_237113_((String)"Absolute Y"));
        this.absoluteYField.m_94199_(7);
        this.absoluteYField.m_94186_(false);
        this.absoluteYField.m_94205_(-1);
        this.parent.addToolbarWidget(this.absoluteYField);
        int resetGap = 8;
        int resetY = widgetY + fieldHeight + resetGap;
        Button resetButton = Button.m_253074_((Component)Component.m_237113_((String)"Reset"), b -> {
            this.preview.resetOffsetsForCurrent();
            this.updateOffsetsFromPreview();
        }).m_252794_(x, resetY).m_253046_(colWidth, 20).m_253136_();
        this.parent.addToolbarWidget(resetButton);
    }

    private void addSideToolbar() {
        Font font = this.parent.getFont();
        if (font == null) {
            return;
        }
        int btnHeight = 20;
        this.screenSelector = null;
        this.gridSelector = null;
        this.shaderToggleButton = null;
        this.guidesToggleButton = null;
        int marginX = 8;
        int leftZoneWidth = this.preview.getPreviewLeft();
        int availableWidth = Math.max(0, leftZoneWidth - marginX * 2);
        if (availableWidth <= 0) {
            return;
        }
        int btnWidth = Math.min(80, availableWidth);
        int xLeft = marginX + (availableWidth - btnWidth) / 2;
        boolean hasContextSelector = this.preview.getOptions().size() > 1;
        Objects.requireNonNull(font);
        int labelHeight = 9;
        int baseTop = this.preview.getPreviewTop() + 4;
        int labelY = baseTop + 3;
        if (hasContextSelector) {
            int widgetY = labelY + labelHeight + 2;
            this.screenSelector = CycleButton.m_168894_(opt -> {
                int idx = this.preview.getOptions().indexOf(opt);
                int index = idx >= 0 ? idx + 1 : 1;
                int total = this.preview.getOptions().size();
                return Component.m_237113_((String)(index + "/" + total));
            }).m_232502_(this.preview.getOptions()).m_168929_().m_168948_((Object)this.preview.currentOption()).m_168936_(xLeft, widgetY, btnWidth, btnHeight, (Component)Component.m_237113_((String)"Screen"), (button, value) -> {
                this.applyOffsetsFromFields();
                this.preview.switchToOption((ButtonPositionConfigBuilder)value);
            });
            this.parent.addToolbarWidget(this.screenSelector);
            labelY = widgetY + btnHeight + 3;
        }
        int gridWidgetY = labelY + labelHeight + 2;
        this.gridSelector = CycleButton.m_168894_(ButtonPositionPreview.GridMode::label).m_168961_((Object[])ButtonPositionPreview.GridMode.values()).m_168929_().m_168948_((Object)this.preview.getGridMode()).m_168936_(xLeft, gridWidgetY, btnWidth, btnHeight, (Component)Component.m_237113_((String)"Grid"), (button, value) -> {
            this.preview.setGridMode((ButtonPositionPreview.GridMode)((Object)value));
            this.preview.snapPreviewToGrid();
        });
        this.parent.addToolbarWidget(this.gridSelector);
        labelY = gridWidgetY + btnHeight + 3;
        int glowWidgetY = labelY + labelHeight + 2;
        this.shaderToggleButton = CycleButton.m_168894_(val -> val != false ? Component.m_237113_((String)"On") : Component.m_237113_((String)"Off")).m_168961_((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).m_168948_((Object)this.preview.isShaderGlowEnabled()).m_168929_().m_168936_(xLeft, glowWidgetY, btnWidth, btnHeight, (Component)Component.m_237113_((String)"Glow"), (button, value) -> this.preview.setShaderGlowEnabled((boolean)value));
        this.parent.addToolbarWidget(this.shaderToggleButton);
        labelY = glowWidgetY + btnHeight + 3;
        int guideWidgetY = labelY + labelHeight + 2;
        this.guidesToggleButton = CycleButton.m_168894_(val -> val != false ? Component.m_237113_((String)"On") : Component.m_237113_((String)"Off")).m_168961_((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).m_168948_((Object)this.preview.isOverlayGuidesEnabled()).m_168929_().m_168936_(xLeft, guideWidgetY, btnWidth, btnHeight, (Component)Component.m_237113_((String)"Guide"), (button, value) -> this.preview.setOverlayGuidesEnabled((boolean)value));
        this.parent.addToolbarWidget(this.guidesToggleButton);
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int button) {
        if (this.offsetXField != null && this.offsetXField.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.offsetYField != null && this.offsetYField.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.absoluteXField != null && this.absoluteXField.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return this.absoluteYField != null && this.absoluteYField.m_6375_(mouseX, mouseY, button);
    }

    public boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        boolean fieldFocused;
        boolean handled;
        boolean bl = handled = this.offsetXField != null && this.offsetXField.m_7933_(keyCode, scanCode, modifiers);
        if (this.offsetYField != null && this.offsetYField.m_7933_(keyCode, scanCode, modifiers)) {
            handled = true;
        }
        boolean bl2 = fieldFocused = this.offsetXField != null && this.offsetXField.m_93696_() || this.offsetYField != null && this.offsetYField.m_93696_();
        if (fieldFocused) {
            if (keyCode == 257 || keyCode == 335) {
                this.applyOffsetsFromFields();
                return true;
            }
            return true;
        }
        return handled;
    }

    public void renderLabels(GuiGraphics guiGraphics) {
        Font font = this.parent.getFont();
        if (font == null) {
            return;
        }
        if (this.offsetXField != null) {
            this.drawLabelAbove(guiGraphics, font, "Offset X", this.offsetXField.m_252754_(), this.offsetXField.m_252907_(), 3);
        }
        if (this.offsetYField != null) {
            this.drawLabelAbove(guiGraphics, font, "Offset Y", this.offsetYField.m_252754_(), this.offsetYField.m_252907_(), 3);
        }
        if (this.absoluteXField != null) {
            this.drawLabelAbove(guiGraphics, font, "Absolute X", this.absoluteXField.m_252754_(), this.absoluteXField.m_252907_(), 3);
        }
        if (this.absoluteYField != null) {
            this.drawLabelAbove(guiGraphics, font, "Absolute Y", this.absoluteYField.m_252754_(), this.absoluteYField.m_252907_(), 3);
        }
        if (this.screenSelector != null) {
            this.drawLabelAbove(guiGraphics, font, "Screen", this.screenSelector.m_252754_(), this.screenSelector.m_252907_(), 2);
        }
        if (this.gridSelector != null) {
            this.drawLabelAbove(guiGraphics, font, "Grid", this.gridSelector.m_252754_(), this.gridSelector.m_252907_(), 2);
        }
        if (this.shaderToggleButton != null) {
            this.drawLabelAbove(guiGraphics, font, "Glow", this.shaderToggleButton.m_252754_(), this.shaderToggleButton.m_252907_(), 2);
        }
        if (this.guidesToggleButton != null) {
            this.drawLabelAbove(guiGraphics, font, "Guide", this.guidesToggleButton.m_252754_(), this.guidesToggleButton.m_252907_(), 2);
        }
    }

    private void drawLabelAbove(GuiGraphics guiGraphics, Font font, String text, int widgetX, int widgetY, int bottomGap) {
        if (text == null || text.isEmpty()) {
            return;
        }
        int lx = widgetX;
        Objects.requireNonNull(font);
        int ly = widgetY - 9 - bottomGap;
        guiGraphics.m_280488_(font, text, lx, ly, -2039584);
    }
}

