/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MirroredImageButton
extends Button {
    private final ResourceLocation originalTexture;
    private final ResourceLocation mirroredTexture;
    private final ResourceLocation overlayTexture;
    private final int u;
    private final int v;
    private final int hoveredVOffset;
    private final int textureWidth;
    private final int textureHeight;
    private final boolean mirrorTexture;

    public MirroredImageButton(int x, int y, int width, int height, int u, int v, int hoveredVOffset, ResourceLocation texture, int textureWidth, int textureHeight, Button.OnPress onPress, Component message, boolean mirrorTexture, ResourceLocation overlayTexture) {
        super(x, y, width, height, message, onPress, Button.f_252438_);
        this.u = u;
        this.v = v;
        this.hoveredVOffset = hoveredVOffset;
        this.originalTexture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.mirrorTexture = mirrorTexture;
        this.overlayTexture = overlayTexture;
        this.mirroredTexture = mirrorTexture ? this.createMirroredTexture(texture) : texture;
        this.m_257544_(Tooltip.m_257550_((Component)message));
    }

    private ResourceLocation createMirroredTexture(ResourceLocation texture) {
        Minecraft mc = Minecraft.m_91087_();
        try {
            ResourceLocation mirroredTextureLocation = new ResourceLocation(texture.m_135827_(), texture.m_135815_() + "_mirrored");
            Optional resourceOpt = mc.m_91098_().m_213713_(texture);
            if (resourceOpt.isEmpty()) {
                throw new IOException("Resource not found: " + texture);
            }
            Resource resource = (Resource)resourceOpt.get();
            NativeImage originalImage = NativeImage.m_85058_((InputStream)resource.m_215507_());
            NativeImage mirroredImage = new NativeImage(originalImage.m_84982_(), originalImage.m_85084_(), true);
            for (int y = 0; y < originalImage.m_85084_(); ++y) {
                for (int x = 0; x < originalImage.m_84982_(); ++x) {
                    mirroredImage.m_84988_(originalImage.m_84982_() - x - 1, y, originalImage.m_84985_(x, y));
                }
            }
            mc.m_91097_().m_118495_(mirroredTextureLocation, (AbstractTexture)new DynamicTexture(mirroredImage));
            originalImage.close();
            return mirroredTextureLocation;
        }
        catch (IOException e) {
            e.printStackTrace();
            return texture;
        }
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation textureToUse = this.mirrorTexture ? this.mirroredTexture : this.originalTexture;
        int yOffset = this.v;
        if (!this.f_93623_) {
            yOffset += this.hoveredVOffset * 2;
        } else if (this.m_198029_()) {
            yOffset += this.hoveredVOffset;
        }
        guiGraphics.m_280163_(textureToUse, this.m_252754_(), this.m_252907_(), (float)this.u, (float)yOffset, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
        if (this.overlayTexture != null) {
            int overlayX = this.m_252754_() + (this.mirrorTexture ? 3 : 0);
            int overlayY = this.m_252907_();
            int overlayVOffset = 0;
            if (!this.f_93623_) {
                overlayVOffset += this.hoveredVOffset * 2;
            } else if (this.m_198029_()) {
                overlayVOffset += this.hoveredVOffset;
            }
            guiGraphics.m_280163_(this.overlayTexture, overlayX, overlayY, 0.0f, (float)overlayVOffset, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
        }
    }
}

