/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util.title;

import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class GlintTitleRenderer {
    private static final int BASE_RGB = 0xFFFFFF;
    private static final int[] PASTEL_RGB = new int[]{16747946, 7208888, 7189759, 13594111, 16759149, 16775021};
    private static final float CYCLE_DURATION_SEC = 6.0f;
    private static final int SPREAD_CHARACTERS = 4;

    public static void render(GuiGraphics guiGraphics, Font font, String text, int screenWidth, int yPos, long startEpochMs) {
        int textWidth = font.m_92895_(text);
        int startX = (screenWidth - textWidth) / 2;
        float elapsedSec = (float)(Util.m_137550_() - startEpochMs) / 1000.0f;
        float progress = elapsedSec % 6.0f / 6.0f;
        int cycleIndex = (int)Math.floor(elapsedSec / 6.0f);
        float cycleLength = text.length() + 8;
        float headPos = progress * cycleLength - 4.0f;
        long seed = startEpochMs >>> 4 ^ (long)cycleIndex * 2654435769L;
        int pastelRgb = PASTEL_RGB[(int)(Math.abs(seed) % (long)PASTEL_RGB.length)];
        int x = startX;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            int charWidth = font.m_92895_(String.valueOf(ch));
            float distance = Math.abs((float)i - headPos);
            float t = 1.0f - Mth.m_14036_((float)(distance / 4.0f), (float)0.0f, (float)1.0f);
            int blended = GlintTitleRenderer.blend(0xFFFFFF, pastelRgb, (float)Math.pow(t, 1.5));
            guiGraphics.m_280056_(font, String.valueOf(ch), x, yPos, blended, false);
            x += charWidth;
        }
    }

    private static int blend(int rgbA, int rgbB, float alpha) {
        int ar = rgbA >> 16 & 0xFF;
        int ag = rgbA >> 8 & 0xFF;
        int ab = rgbA & 0xFF;
        int br = rgbB >> 16 & 0xFF;
        int bg = rgbB >> 8 & 0xFF;
        int bb = rgbB & 0xFF;
        int r = Mth.m_14045_((int)Math.round(Mth.m_14179_((float)alpha, (float)ar, (float)br)), (int)0, (int)255);
        int g = Mth.m_14045_((int)Math.round(Mth.m_14179_((float)alpha, (float)ag, (float)bg)), (int)0, (int)255);
        int b = Mth.m_14045_((int)Math.round(Mth.m_14179_((float)alpha, (float)ab, (float)bb)), (int)0, (int)255);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

