#version 150

out vec4 fragColor;

uniform vec2 Center;
uniform float Radius;
uniform float Time;
uniform vec4 Color;
uniform vec2 ButtonHalfSize;
uniform float Drag;

float sdRoundedBox(vec2 p, vec2 b, float r) {
    vec2 q = abs(p) - (b - vec2(r));
    return length(max(q, 0.0)) - r;
}

void main() {
    vec2 p = gl_FragCoord.xy;
    vec2 rel = p - Center;
    vec2 halfSize = ButtonHalfSize;

    float cornerRadius = min(halfSize.x, halfSize.y) * 0.5;
    float d = sdRoundedBox(rel, halfSize, cornerRadius);
    float haloReach = max(Radius, 1.0);
    float fadeInset = min(halfSize.x, halfSize.y) * 0.15;
    float dSoft = d + fadeInset;

    float distOutside = max(dSoft, 0.0);
    float tOuter = clamp(distOutside / haloReach, 0.0, 1.0);
    float edgeFactor = 1.0 - tOuter;

    float maxHalf = max(halfSize.x, halfSize.y);
    float centerR = length(rel / maxHalf);
    float tInner = clamp(centerR, 0.0, 1.0);
    float centerFactor = 1.0 + 0.40 * pow(1.0 - tInner, 1.7);

    float baseIntensity = centerFactor * edgeFactor;

    float rimWidth = haloReach * 0.7;
    float rimParam = clamp(abs(dSoft) / max(rimWidth, 0.0001), 0.0, 1.0);
    float rimMask = exp(-rimParam * rimParam * 4.0);

    float t = Time;
    vec2 wobbleOffset = vec2(sin(t * 1.1 + rel.y * 0.05), cos(t * 0.9 + rel.x * 0.04)) * 4.0;
    vec2 q = rel + wobbleOffset;

    float n1 = sin(q.x * 0.16 + t * 2.4);
    float n2 = sin(q.y * 0.20 - t * 2.7);
    float n3 = sin((q.x + q.y) * 0.10 + t * 3.5);
    float n4 = sin((q.x - q.y) * 0.07 - t * 1.9);
    float noise = (n1 + n2 + n3 + n4) * 0.25;
    float noisePos = max(noise, 0.0);

    float dragVal = clamp(Drag, 0.0, 1.0);
    float flameAmp = mix(0.45, 0.06, dragVal);
    float flameExtra = noisePos * rimMask * flameAmp;

    float intensity = baseIntensity * (1.0 + flameExtra);

    float baseGlow = mix(1.0, 0.25, dragVal);
    intensity *= baseGlow;

    float pulse = 0.99 + 0.015 * sin(t * 6.2831853);
    intensity *= 0.95 * pulse;

    float sparkleSeed = clamp(noisePos, 0.0, 1.0);

    float sparkleMask = pow(sparkleSeed, 6.0) * rimMask;

    intensity += sparkleMask * 0.7;

    intensity = clamp(intensity, 0.0, 1.8);

    float alpha = intensity * Color.a;
    if (alpha <= 0.002) discard;

    vec3 baseColor = Color.rgb;
    vec3 sparkleColor = vec3(1.0);
    vec3 finalColor = mix(baseColor, sparkleColor, sparkleMask * 0.9);

    fragColor = vec4(finalColor * intensity, alpha);
}