/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew;

import com.eruannie_9.booklinggear.register.DeferredRegisters;
import com.eruannie_9.booklinggear.register.RegistrationHelper;
import com.eruannie_9.brewchew.ModConfiguration;
import com.eruannie_9.brewchew.block.ModBlockEntities;
import com.eruannie_9.brewchew.block.ModBlocks;
import com.eruannie_9.brewchew.capability.GuideObfuscationProvider;
import com.eruannie_9.brewchew.capability.IGuideObfuscation;
import com.eruannie_9.brewchew.capability.ModCapabilities;
import com.eruannie_9.brewchew.command.ModArgumentTypes;
import com.eruannie_9.brewchew.gui.ModMenuTypes;
import com.eruannie_9.brewchew.mobeffect.ModEffects;
import com.eruannie_9.brewchew.packethandler.PacketHandler;
import com.eruannie_9.brewchew.recipe.ModRecipes;
import com.eruannie_9.brewchew.sound.ModSounds;
import com.eruannie_9.brewchew.util.flower.GuidePageData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="brewchew")
public class BrewChew {
    public static final String MOD_ID = "brewchew";
    public static final DeferredRegisters REGISTERS = new DeferredRegisters("brewchew");
    public static final RegistrationHelper REGISTRATION_HELPER = new RegistrationHelper(REGISTERS);

    public BrewChew() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        ModConfiguration.registerConfig();
        ModEffects.register();
        ModArgumentTypes.register();
        ModBlocks.register();
        ModBlockEntities.register();
        ModMenuTypes.register();
        ModRecipes.register();
        ModSounds.register();
        REGISTERS.register(eventBus);
        eventBus.addListener(this::onRegisterCapabilities);
        eventBus.addListener(this::addCreative);
    }

    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IGuideObfuscation.class);
    }

    @SubscribeEvent
    public void onAttachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation(MOD_ID, "guide_obfuscation"), (ICapabilityProvider)new GuideObfuscationProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().getCapability(ModCapabilities.GUIDE_OBFUSCATION).ifPresent(oldCap -> event.getEntity().getCapability(ModCapabilities.GUIDE_OBFUSCATION).ifPresent(newCap -> {
            for (int p = 0; p < GuidePageData.PAGES.length; ++p) {
                newCap.setPageObfuscated(p, oldCap.isPageObfuscated(p));
            }
        }));
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.initialize();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256839_) {
            event.accept(ModBlocks.BREWING_CAULDRON);
        }
    }
}

