/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew;

import com.eruannie_9.brewchew.ModConfiguration;
import com.eruannie_9.brewchew.block.BrewingCauldronBlockEntity;
import com.eruannie_9.brewchew.block.ModBlockEntities;
import com.eruannie_9.brewchew.block.ModBlocks;
import com.eruannie_9.brewchew.gui.BrewingCauldronInfusionScreen;
import com.eruannie_9.brewchew.gui.BrewingCauldronMainScreen;
import com.eruannie_9.brewchew.gui.ModMenuTypes;
import com.eruannie_9.brewchew.renderer.BrewingCauldronRendererHandler;
import com.eruannie_9.brewchew.sound.BoilingSoundInstance;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="brewchew", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class BrewChewClient {
    private static final Map<BlockPos, BoilingSoundInstance> SOUND_INSTANCES = new HashMap<BlockPos, BoilingSoundInstance>();

    private BrewChewClient() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BREWING_CAULDRON_MAIN_MENU.get()), BrewingCauldronMainScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BREWING_CAULDRON_INFUSION_MENU.get()), BrewingCauldronInfusionScreen::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.BREWING_CAULDRON_BLOCK_ENTITY.get()), context -> new BrewingCauldronRendererHandler());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BREWING_CAULDRON.get()), (RenderType)RenderType.m_110463_());
        });
    }

    public static void handleCauldronSound(BrewingCauldronBlockEntity be) {
        Level level = be.m_58904_();
        if (level == null || !level.f_46443_) {
            return;
        }
        BlockPos pos = be.m_58899_();
        boolean cauldronSoundsEnabled = (Boolean)ModConfiguration.CAULDRON_SOUNDS.get();
        if (!cauldronSoundsEnabled) {
            BrewChewClient.stopCauldronSound(be);
            return;
        }
        if (be.hasAnyPotion()) {
            BoilingSoundInstance instance = SOUND_INSTANCES.get(pos);
            if (instance == null || instance.m_7801_()) {
                instance = new BoilingSoundInstance(pos);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)instance);
                SOUND_INSTANCES.put(pos, instance);
            }
        } else {
            BrewChewClient.stopCauldronSound(be);
        }
    }

    public static void stopCauldronSound(BrewingCauldronBlockEntity be) {
        Level level = be.m_58904_();
        if (level == null || !level.f_46443_) {
            return;
        }
        BlockPos pos = be.m_58899_();
        BoilingSoundInstance instance = SOUND_INSTANCES.get(pos);
        if (instance != null && !instance.m_7801_()) {
            instance.manualStop();
        }
        SOUND_INSTANCES.remove(pos);
    }
}

