/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.block;

import com.eruannie_9.brewchew.block.BrewingCauldronBlockEntity;
import com.eruannie_9.brewchew.block.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class BrewingCauldronBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape LOWER_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.999, (double)16.0, (double)16.0);
    private static final VoxelShape UPPER_SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape UPPER_SHAPE_EAST = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape UPPER_SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape UPPER_SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);

    public BrewingCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return LOWER_SHAPE;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.EAST -> UPPER_SHAPE_EAST;
            case Direction.SOUTH -> UPPER_SHAPE_SOUTH;
            case Direction.WEST -> UPPER_SHAPE_WEST;
            default -> UPPER_SHAPE_NORTH;
        };
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos abovePos;
        BlockState aboveState;
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Direction facing = context.m_8125_();
        if (pos.m_123342_() < level.m_151558_() - 1 && (aboveState = level.m_8055_(abovePos = pos.m_7494_())).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        if (!level.f_46443_) {
            BlockEntity be;
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                BlockPos abovePos = pos.m_7494_();
                BlockState upperState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER);
                level.m_7731_(abovePos, upperState, 3);
            }
            if ((be = level.m_7702_(pos)) instanceof BrewingCauldronBlockEntity) {
                int biomeWaterColor;
                BrewingCauldronBlockEntity brewingCauldronBE = (BrewingCauldronBlockEntity)be;
                brewingCauldronBE.colorTransition.oldColor = biomeWaterColor = BrewingCauldronBlockEntity.computeMixedPotionColor(brewingCauldronBE);
                brewingCauldronBE.colorTransition.currentColor = biomeWaterColor;
                brewingCauldronBE.colorTransition.targetColor = biomeWaterColor;
            }
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public void m_6810_(@NotNull BlockState oldState, Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!level.f_46443_ && !oldState.m_60713_(newState.m_60734_()) && oldState.m_61143_(HALF) == DoubleBlockHalf.LOWER && (be = level.m_7702_(pos)) instanceof BrewingCauldronBlockEntity) {
            BrewingCauldronBlockEntity brewingCauldronBE = (BrewingCauldronBlockEntity)be;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)brewingCauldronBE.getContainer());
        }
        super.m_6810_(oldState, level, pos, newState, isMoving);
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.f_46443_) {
            BlockPos otherHalfPos;
            BlockState otherHalfState;
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
            boolean correctTool = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
            if (correctTool) {
                BrewingCauldronBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
            }
            if ((otherHalfState = level.m_8055_(otherHalfPos = half == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_())).m_60734_() == this && otherHalfState.m_61143_(HALF) != half) {
                BlockEntity be;
                level.m_7731_(otherHalfPos, Blocks.f_50016_.m_49966_(), 35);
                if (half == DoubleBlockHalf.UPPER && (be = level.m_7702_(otherHalfPos)) instanceof BrewingCauldronBlockEntity) {
                    BrewingCauldronBlockEntity cauldronBE = (BrewingCauldronBlockEntity)be;
                    Containers.m_19002_((Level)level, (BlockPos)otherHalfPos, (Container)cauldronBE.getContainer());
                }
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction == (half == DoubleBlockHalf.UPPER ? Direction.DOWN : Direction.UP) && (neighborState.m_60734_() != this || neighborState.m_61143_(HALF) == half)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return null;
        }
        return new BrewingCauldronBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (level.f_46443_) {
            return BrewingCauldronBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.BREWING_CAULDRON_BLOCK_ENTITY.get()), (level1, pos, state1, be) -> BrewingCauldronBlockEntity.clientTick(level1, be));
        }
        return BrewingCauldronBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.BREWING_CAULDRON_BLOCK_ENTITY.get()), (level1, pos, state1, be) -> BrewingCauldronBlockEntity.serverTick(level1, be));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity blockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
        }
        if ((blockEntity = level.m_7702_(pos)) instanceof BrewingCauldronBlockEntity) {
            BrewingCauldronBlockEntity cauldronBE = (BrewingCauldronBlockEntity)blockEntity;
            BlockPos finalPos = pos;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)cauldronBE, buf -> buf.m_130064_(finalPos));
        }
        return InteractionResult.CONSUME;
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.m_214162_(state, level, pos, rand);
        if (state.m_61143_(HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof BrewingCauldronBlockEntity)) {
            return;
        }
        BrewingCauldronBlockEntity cauldronBE = (BrewingCauldronBlockEntity)be;
        if (!cauldronBE.hasAnyPotion()) {
            return;
        }
        float WATER_PLANE_Y = 0.777775f;
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)((float)pos.m_123342_() + 0.777775f) - 0.06;
        double centerZ = (double)pos.m_123343_() + 0.5;
        int particleCount = 3 + rand.m_188503_(4);
        int colorInt = cauldronBE.colorTransition.getCurrentColor();
        float baseR = (float)(colorInt >> 16 & 0xFF) / 255.0f;
        float baseG = (float)(colorInt >> 8 & 0xFF) / 255.0f;
        float baseB = (float)(colorInt & 0xFF) / 255.0f;
        for (int i = 0; i < particleCount; ++i) {
            boolean fling;
            float variation = 0.05f;
            float r = BrewingCauldronBlock.clampColor(baseR + (rand.m_188501_() - 0.5f) * variation);
            float g = BrewingCauldronBlock.clampColor(baseG + (rand.m_188501_() - 0.5f) * variation);
            float b = BrewingCauldronBlock.clampColor(baseB + (rand.m_188501_() - 0.5f) * variation);
            double offsetX = (rand.m_188500_() - 0.5) * 0.6;
            double offsetZ = (rand.m_188500_() - 0.5) * 0.6;
            double x = centerX + offsetX;
            double y = centerY;
            double z = centerZ + offsetZ;
            double dx = 0.0;
            double dy = 0.02 + rand.m_188500_() * 0.02;
            double dz = 0.0;
            boolean bl = fling = rand.m_188501_() < 0.25f;
            if (fling) {
                dx = (rand.m_188500_() - 0.5) * 0.3;
                dy = 0.1 + rand.m_188500_() * 0.1;
                dz = (rand.m_188500_() - 0.5) * 0.3;
            }
            DustParticleOptions dust = new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
            level.m_7106_((ParticleOptions)dust, x, y, z, dx, dy, dz);
        }
    }

    private static float clampColor(float c) {
        return Math.min(1.0f, Math.max(0.0f, c));
    }

    public MenuProvider m_7246_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity be;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
        }
        if ((be = level.m_7702_(pos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)be;
            return provider;
        }
        return null;
    }
}

