/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.block;

import com.eruannie_9.brewchew.BrewChewClient;
import com.eruannie_9.brewchew.block.ModBlockEntities;
import com.eruannie_9.brewchew.gui.BrewingCauldronMainMenu;
import com.eruannie_9.brewchew.util.LoreUtil;
import com.eruannie_9.brewchew.util.flower.FlowerEffectUtil;
import com.eruannie_9.brewchew.util.flower.FlowerTooltipStyler;
import com.eruannie_9.brewchew.util.render.block.BounceState;
import com.eruannie_9.brewchew.util.render.block.ColorTransition;
import com.eruannie_9.brewchew.util.render.block.MotionState;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BrewingCauldronBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int INVENTORY_SIZE = 6;
    private static final int SETTINGS_SIZE = 2;
    private static final int POTION_SLOTS = 4;
    private final SimpleContainer container = new SimpleContainer(6);
    private final SimpleContainer settingsContainer = new SimpleContainer(2);
    @Nullable
    private Item storedFlower;
    @Nullable
    private Item storedMushroom;
    public final MotionState motionState = new MotionState();
    public final BounceState[] bounceStates = new BounceState[5];
    public final ColorTransition colorTransition = new ColorTransition();
    private boolean consumptionPending = false;
    private int consumptionCountdown = 0;
    private ConsumptionType pendingConsumptionType = null;
    public static final int CONSUMPTION_DELAY = 50;

    public BrewingCauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BREWING_CAULDRON_BLOCK_ENTITY.get(), pos, state);
        for (int i = 0; i < this.bounceStates.length; ++i) {
            this.bounceStates[i] = new BounceState();
            this.bounceStates[i].yOffset = (float)(Math.random() * (double)0.1f) - 0.05f;
        }
        this.container.m_19164_(c -> {
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        });
        this.settingsContainer.m_19164_(c -> {
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        });
        ItemStack slot1 = this.settingsContainer.m_8020_(1);
        if (slot1.m_41619_()) {
            ItemStack beef = new ItemStack((ItemLike)Items.f_42580_);
            this.settingsContainer.m_6836_(1, beef);
        }
        this.setStoredMushroom(Items.f_41952_);
    }

    public SimpleContainer getContainer() {
        return this.container;
    }

    public SimpleContainer getSettingsContainer() {
        return this.settingsContainer;
    }

    @Nullable
    public Item getStoredFlower() {
        return this.storedFlower;
    }

    public void setStoredFlower(@Nullable Item newFlower) {
        this.storedFlower = newFlower;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nullable
    public Item getStoredMushroom() {
        return this.storedMushroom;
    }

    public void setStoredMushroom(@Nullable Item newMushroom) {
        this.storedMushroom = newMushroom;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void startConsumption(ConsumptionType type) {
        if (this.consumptionPending) {
            return;
        }
        this.consumptionPending = true;
        this.consumptionCountdown = 50;
        this.pendingConsumptionType = type;
        this.m_6596_();
    }

    public void cancelConsumption() {
        this.consumptionPending = false;
        this.consumptionCountdown = 0;
        this.pendingConsumptionType = null;
        this.m_6596_();
    }

    public boolean isConsumptionPending() {
        return this.consumptionPending;
    }

    public int getConsumptionCountdown() {
        return this.consumptionCountdown;
    }

    public int getConsumptionDelay() {
        return 50;
    }

    private void finalizeConsumption() {
        if (!this.consumptionPending) {
            return;
        }
        ItemStack stack = this.settingsContainer.m_8020_(0);
        if (stack.m_41619_()) {
            this.consumptionPending = false;
            this.m_6596_();
            return;
        }
        switch (this.pendingConsumptionType) {
            case FLOWER: {
                this.setStoredFlower(stack.m_41720_());
                if (stack.m_41720_() != Items.f_41951_) break;
                this.setStoredMushroom(Items.f_41952_);
                break;
            }
            case MUSHROOM_BROWN: 
            case MUSHROOM_RED: {
                this.setStoredMushroom(stack.m_41720_());
            }
        }
        stack.m_41774_(1);
        this.settingsContainer.m_6836_(0, ItemStack.f_41583_);
        this.consumptionPending = false;
        this.consumptionCountdown = 0;
        this.pendingConsumptionType = null;
        this.m_6596_();
    }

    public static void serverTick(Level level, BrewingCauldronBlockEntity be) {
        if (!level.f_46443_ && be.consumptionPending) {
            --be.consumptionCountdown;
            if (be.consumptionCountdown <= 0) {
                be.finalizeConsumption();
            }
            be.m_6596_();
            level.m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
        }
    }

    public static void clientTick(Level level, BrewingCauldronBlockEntity be) {
        if (!level.f_46443_) {
            return;
        }
        be.motionState.tick();
        int newColor = BrewingCauldronBlockEntity.computeMixedPotionColor(be);
        if (newColor != be.colorTransition.getTargetColor()) {
            be.colorTransition.beginTransition(level, newColor);
        }
        be.colorTransition.tick(level);
        BrewChewClient.handleCauldronSound(be);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            int c;
            this.colorTransition.oldColor = c = BrewingCauldronBlockEntity.computeMixedPotionColor(this);
            this.colorTransition.currentColor = c;
            this.colorTransition.targetColor = c;
            BrewChewClient.handleCauldronSound(this);
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        NonNullList items = NonNullList.m_122780_((int)this.container.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)items);
        for (int i = 0; i < items.size(); ++i) {
            this.container.m_6836_(i, (ItemStack)items.get(i));
        }
        if (nbt.m_128425_("SettingsItems", 10)) {
            CompoundTag settingsTag = nbt.m_128469_("SettingsItems");
            NonNullList settingsItems = NonNullList.m_122780_((int)this.settingsContainer.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)settingsTag, (NonNullList)settingsItems);
            for (int i = 0; i < settingsItems.size(); ++i) {
                this.settingsContainer.m_6836_(i, (ItemStack)settingsItems.get(i));
            }
        }
        if (nbt.m_128425_("StoredFlower", 8)) {
            String flowerId = nbt.m_128461_("StoredFlower");
            this.storedFlower = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(flowerId));
        } else {
            this.storedFlower = null;
        }
        if (nbt.m_128425_("StoredMushroom", 8)) {
            String mushId = nbt.m_128461_("StoredMushroom");
            this.storedMushroom = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mushId));
        } else {
            this.storedMushroom = null;
        }
        this.consumptionPending = nbt.m_128471_("ConsumptionPending");
        this.consumptionCountdown = nbt.m_128451_("ConsumptionCountdown");
        this.pendingConsumptionType = nbt.m_128441_("PendingConsumptionType") ? ConsumptionType.valueOf(nbt.m_128461_("PendingConsumptionType")) : null;
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        ResourceLocation key;
        ResourceLocation key2;
        super.m_183515_(nbt);
        NonNullList items = NonNullList.m_122780_((int)this.container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            items.set(i, (Object)this.container.m_8020_(i));
        }
        ContainerHelper.m_18973_((CompoundTag)nbt, (NonNullList)items);
        CompoundTag settingsTag = new CompoundTag();
        NonNullList settingsItems = NonNullList.m_122780_((int)this.settingsContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.settingsContainer.m_6643_(); ++i) {
            settingsItems.set(i, (Object)this.settingsContainer.m_8020_(i));
        }
        ContainerHelper.m_18973_((CompoundTag)settingsTag, (NonNullList)settingsItems);
        nbt.m_128365_("SettingsItems", (Tag)settingsTag);
        if (this.storedFlower != null && (key2 = ForgeRegistries.ITEMS.getKey((Object)this.storedFlower)) != null) {
            nbt.m_128359_("StoredFlower", key2.toString());
        }
        if (this.storedMushroom != null && (key = ForgeRegistries.ITEMS.getKey((Object)this.storedMushroom)) != null) {
            nbt.m_128359_("StoredMushroom", key.toString());
        }
        nbt.m_128379_("ConsumptionPending", this.consumptionPending);
        nbt.m_128405_("ConsumptionCountdown", this.consumptionCountdown);
        if (this.pendingConsumptionType != null) {
            nbt.m_128359_("PendingConsumptionType", this.pendingConsumptionType.name());
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Brewing Cauldron");
    }

    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInv, @NotNull Player player) {
        return new BrewingCauldronMainMenu(windowId, playerInv, this);
    }

    public static int computeMixedPotionColor(BrewingCauldronBlockEntity entity) {
        float totalR = 0.0f;
        float totalG = 0.0f;
        float totalB = 0.0f;
        int potionCount = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = entity.getContainer().m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof PotionItem)) continue;
            int color = PotionUtils.m_43575_((ItemStack)stack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            totalR += r;
            totalG += g;
            totalB += b;
            ++potionCount;
        }
        if (potionCount > 0) {
            float avgR = totalR / (float)potionCount;
            float avgG = totalG / (float)potionCount;
            float avgB = totalB / (float)potionCount;
            return (int)(avgR * 255.0f) << 16 | (int)(avgG * 255.0f) << 8 | (int)(avgB * 255.0f);
        }
        return 6388580;
    }

    public boolean hasAnyPotion() {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof PotionItem)) continue;
            return true;
        }
        return false;
    }

    public void applyInfusionTags(@NotNull ItemStack previewItem) {
        if (previewItem.m_41619_()) {
            return;
        }
        if (this.storedFlower == Items.f_41951_) {
            CompoundTag brewData = previewItem.m_41698_("BrewChewPotionData");
            brewData.m_128359_("InfusedFlower", "none");
            if (this.storedMushroom == Items.f_41952_) {
                brewData.m_128359_("InfusedMushroom", "brown");
                brewData.m_128379_("DisableGlint", true);
                brewData.m_128473_("ForceGlint");
            } else if (this.storedMushroom == Items.f_41953_) {
                brewData.m_128359_("InfusedMushroom", "red");
                brewData.m_128473_("DisableGlint");
                brewData.m_128379_("ForceGlint", true);
            } else {
                brewData.m_128359_("InfusedMushroom", "brown");
                brewData.m_128379_("DisableGlint", true);
                brewData.m_128473_("ForceGlint");
            }
            if (previewItem.m_41782_()) {
                CompoundTag display = Objects.requireNonNull(previewItem.m_41783_()).m_128469_("display");
                display.m_128473_("Name");
                display.m_128473_("Lore");
                if (display.m_128456_()) {
                    previewItem.m_41749_("display");
                }
            }
            return;
        }
        CompoundTag brewData = previewItem.m_41698_("BrewChewPotionData");
        if (this.storedFlower != null) {
            ResourceLocation flowerRL = ForgeRegistries.ITEMS.getKey((Object)this.storedFlower);
            if (flowerRL != null) {
                brewData.m_128359_("InfusedFlower", flowerRL.toString());
            }
        } else {
            brewData.m_128359_("InfusedFlower", "none");
        }
        if (this.storedMushroom == Items.f_41952_) {
            brewData.m_128359_("InfusedMushroom", "brown");
            brewData.m_128379_("DisableGlint", true);
            brewData.m_128473_("ForceGlint");
        } else if (this.storedMushroom == Items.f_41953_) {
            brewData.m_128359_("InfusedMushroom", "red");
            brewData.m_128473_("DisableGlint");
            brewData.m_128379_("ForceGlint", true);
        } else {
            brewData.m_128359_("InfusedMushroom", "brown");
            brewData.m_128379_("DisableGlint", true);
            brewData.m_128473_("ForceGlint");
        }
        this.applyFlowerDurationBonus(previewItem, this.storedFlower);
    }

    private void applyFlowerDurationBonus(@NotNull ItemStack finishedStack, @Nullable Item flowerItem) {
        CompoundTag brewData;
        FlowerTooltipStyler.FlowerMode mode = FlowerTooltipStyler.getFlowerMode(flowerItem);
        if (mode == null) {
            mode = FlowerTooltipStyler.FlowerMode.NONE;
        }
        if (!(brewData = finishedStack.m_41784_().m_128469_("BrewChewPotionData")).m_128425_("Potions", 9)) {
            return;
        }
        ListTag potionsList = brewData.m_128437_("Potions", 10);
        for (int i = 0; i < potionsList.size(); ++i) {
            CompoundTag singlePotion = potionsList.m_128728_(i);
            if (!singlePotion.m_128425_("Effects", 9)) continue;
            ListTag effectsList = singlePotion.m_128437_("Effects", 10);
            for (int j = 0; j < effectsList.size(); ++j) {
                CompoundTag effCompound = effectsList.m_128728_(j);
                String effectLoc = effCompound.m_128461_("Effect");
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectLoc));
                if (effect == null) continue;
                int oldDuration = effCompound.m_128451_("Duration");
                int oldAmplifier = effCompound.m_128451_("Amplifier");
                FlowerEffectUtil.applyBonusIfPresent(mode, effect, effCompound, oldDuration, oldAmplifier, effectsList);
            }
        }
        LoreUtil.updateEffectsLore(finishedStack, mode.getLabelColor(), mode.getValueColor());
        LoreUtil.addInfusedFlowerLore(finishedStack, flowerItem, mode.getLabelColor(), mode.getValueColor());
        BrewingCauldronBlockEntity.colorItemName(finishedStack, mode.getTitleColor());
    }

    private static void colorItemName(@NotNull ItemStack stack, int rgb) {
        int color24 = rgb & 0xFFFFFF;
        String hex = String.format("#%06X", color24);
        String rawName = stack.m_41786_().getString().replace("\"", "\\\"");
        String jsonName = String.format("{\"text\":\"%s\",\"color\":\"%s\",\"italic\":false}", rawName, hex);
        stack.m_41698_("display").m_128359_("Name", jsonName);
    }

    public static enum ConsumptionType {
        FLOWER,
        MUSHROOM_BROWN,
        MUSHROOM_RED;

    }
}

