/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.command;

import com.eruannie_9.brewchew.capability.ModCapabilities;
import com.eruannie_9.brewchew.command.GuideCommandUtil;
import com.eruannie_9.brewchew.command.PageArgument;
import com.eruannie_9.brewchew.packethandler.PacketHandler;
import com.eruannie_9.brewchew.packethandler.pack.SyncGuideMaskPacket;
import com.eruannie_9.brewchew.util.flower.GuidePageData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="brewchew", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class GuidePagesCommand {
    private static final String MOD_NAME = ModList.get().getModContainerById("brewchew").map(c -> c.getModInfo().getDisplayName()).orElse("brewchew");
    private static final String PREFIX = "\u00a76[" + MOD_NAME + "]\u00a7r ";

    private GuidePagesCommand() {
    }

    @SubscribeEvent
    public static void onRegister(RegisterCommandsEvent e) {
        GuidePagesCommand.build((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    private static void build(CommandDispatcher<CommandSourceStack> d) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.m_82127_((String)"brewguide").requires(src -> src.m_6761_(2));
        root.executes(c -> GuidePagesCommand.show((CommandSourceStack)c.getSource(), List.of(((CommandSourceStack)c.getSource()).m_81375_())));
        GuidePagesCommand.registerGrantOrRevoke((LiteralArgumentBuilder<CommandSourceStack>)root, true);
        GuidePagesCommand.registerGrantOrRevoke((LiteralArgumentBuilder<CommandSourceStack>)root, false);
        d.register(root);
    }

    private static void registerGrantOrRevoke(LiteralArgumentBuilder<CommandSourceStack> root, boolean grant) {
        LiteralArgumentBuilder literal = Commands.m_82127_((String)(grant ? "add" : "remove"));
        literal.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"page", (ArgumentType)PageArgument.page()).executes(c -> GuidePagesCommand.change(grant, (CommandSourceStack)c.getSource(), (String)c.getArgument("page", String.class), List.of(((CommandSourceStack)c.getSource()).m_81375_())))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(c -> GuidePagesCommand.change(grant, (CommandSourceStack)c.getSource(), (String)c.getArgument("page", String.class), EntityArgument.m_91477_((CommandContext)c, (String)"targets")))));
        root.then((ArgumentBuilder)literal);
    }

    private static int show(CommandSourceStack src, Collection<ServerPlayer> targets) {
        for (ServerPlayer pl : targets) {
            LazyOptional opt = pl.getCapability(ModCapabilities.GUIDE_OBFUSCATION);
            if (!opt.isPresent()) {
                src.m_81352_((Component)Component.m_237113_((String)(PREFIX + pl.m_6302_() + " \u2013 <no cap>")));
                continue;
            }
            opt.ifPresent(cap -> {
                int total = GuidePageData.PAGES.length;
                ArrayList<CallSite> unlocked = new ArrayList<CallSite>();
                for (int i = 0; i < total; ++i) {
                    if (cap.isPageObfuscated(i)) continue;
                    unlocked.add((CallSite)((Object)(i + 1 + " \u2013 " + GuidePageData.PAGES[i].title())));
                }
                src.m_288197_(() -> Component.m_237113_((String)(PREFIX + pl.m_6302_() + " : " + unlocked.size() + " / " + total)), false);
                if (unlocked.isEmpty()) {
                    src.m_288197_(() -> Component.m_237113_((String)"  \u00a7c(no pages unlocked)"), false);
                } else {
                    unlocked.forEach(s -> src.m_288197_(() -> Component.m_237113_((String)("  \u00a7a\u2714 \u00a7r" + s)), false));
                }
            });
        }
        return 0;
    }

    private static int change(boolean grant, CommandSourceStack src, String token, Collection<ServerPlayer> targets) {
        int pageIdx;
        boolean all = token.equalsIgnoreCase("all");
        int n = pageIdx = all ? -1 : GuideCommandUtil.pageFromString(token);
        if (!(all || pageIdx >= 0 && pageIdx < GuidePageData.PAGES.length)) {
            src.m_81352_((Component)Component.m_237113_((String)(PREFIX + "Unknown page '" + token + "'")));
            return 0;
        }
        for (ServerPlayer pl : targets) {
            LazyOptional opt = pl.getCapability(ModCapabilities.GUIDE_OBFUSCATION);
            if (!opt.isPresent()) continue;
            opt.ifPresent(cap -> {
                boolean changed = false;
                if (all) {
                    for (int i = 0; i < GuidePageData.PAGES.length; ++i) {
                        boolean shouldObf;
                        boolean bl = shouldObf = !grant;
                        if (cap.isPageObfuscated(i) == shouldObf) continue;
                        cap.setPageObfuscated(i, shouldObf);
                        changed = true;
                    }
                } else {
                    boolean shouldObf;
                    boolean bl = shouldObf = !grant;
                    if (cap.isPageObfuscated(pageIdx) != shouldObf) {
                        cap.setPageObfuscated(pageIdx, shouldObf);
                        changed = true;
                    }
                }
                if (changed) {
                    PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> pl), (Object)new SyncGuideMaskPacket(cap.getRevealedMask()));
                }
                String verb = grant ? "Add " : "Remove ";
                String noChange = grant ? "already added" : "already removed";
                String whatRaw = all ? "all pages" : "page " + (pageIdx + 1) + " (" + GuidePageData.PAGES[pageIdx].title() + ")";
                String what = changed ? whatRaw : Character.toUpperCase(whatRaw.charAt(0)) + whatRaw.substring(1);
                String tgt = " for " + pl.m_6302_();
                if (changed) {
                    src.m_288197_(() -> Component.m_237113_((String)(PREFIX + verb + what + tgt)), true);
                } else {
                    src.m_288197_(() -> Component.m_237113_((String)(PREFIX + what + " " + noChange + tgt)), true);
                }
            });
        }
        return 1;
    }
}

