/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.event;

import com.eruannie_9.brewchew.util.cake.CakeData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class CakeCleanupData {
    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50145_) {
            CakeData.removeData(level, pos);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        for (BlockPos pos : event.getAffectedBlocks()) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() != Blocks.f_50145_) continue;
            CakeData.removeData(level, pos);
        }
    }

    @SubscribeEvent
    public static void onNeighbor(BlockEvent.NeighborNotifyEvent event) {
        BlockPos upPos;
        BlockState upState;
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level) || (level = (Level)levelAccessor).m_5776_()) {
            return;
        }
        BlockPos changedPos = event.getPos();
        BlockState changedState = event.getState();
        if (changedState.m_60734_() == Blocks.f_50145_ && !changedState.m_60710_((LevelReader)level, changedPos)) {
            CakeData.removeData(level, changedPos);
            return;
        }
        if (event.getNotifiedSides().contains(Direction.UP) && (upState = level.m_8055_(upPos = changedPos.m_7494_())).m_60734_() == Blocks.f_50145_ && !upState.m_60710_((LevelReader)level, upPos)) {
            CakeData.removeData(level, upPos);
        }
    }
}

