/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.event;

import com.eruannie_9.brewchew.util.cake.CakeData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public final class CakeConsume {
    @SubscribeEvent
    public static void onCakeBite(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.f_46443_) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != Blocks.f_50145_) {
            return;
        }
        Player player = event.getEntity();
        if (!player.m_36391_(false)) {
            return;
        }
        CompoundTag brewChewData = CakeData.getData(level, pos);
        if (brewChewData == null) {
            return;
        }
        int bitesSoFar = (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
        CakeConsume.applyBiteEffectsToPlayer(level, pos, player, brewChewData, bitesSoFar);
        int newBites = bitesSoFar + 1;
        player.m_36220_(Stats.f_12942_);
        if (newBites < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(newBites)), 3);
        } else {
            level.m_7471_(pos, false);
            CakeData.removeData(level, pos);
        }
        level.m_5594_(null, pos, SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        event.setUseBlock(Event.Result.DENY);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    private static void applyBiteEffectsToPlayer(Level level, BlockPos pos, Player player, CompoundTag brewChewData, int bitesSoFar) {
        if (!brewChewData.m_128425_("Potions", 9)) {
            return;
        }
        ListTag potionsList = brewChewData.m_128437_("Potions", 10);
        if (potionsList.isEmpty()) {
            return;
        }
        CompoundTag singlePotion = potionsList.m_128728_(0);
        if (!singlePotion.m_128425_("Effects", 9)) {
            return;
        }
        ListTag effectsList = singlePotion.m_128437_("Effects", 10);
        if (effectsList.isEmpty()) {
            return;
        }
        int slicesLeft = 7 - bitesSoFar;
        for (int i = 0; i < effectsList.size(); ++i) {
            int sliceDuration;
            ResourceLocation effectLoc;
            MobEffect mobEffect;
            CompoundTag eff = effectsList.m_128728_(i);
            if (!eff.m_128441_("Effect") || (mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLoc = new ResourceLocation(eff.m_128461_("Effect")))) == null) continue;
            int amplifier = eff.m_128451_("Amplifier");
            int totalDurationTicks = eff.m_128451_("Duration");
            if (mobEffect.m_8093_()) {
                MobEffectInstance instance = new MobEffectInstance(mobEffect, 1, amplifier, false, true);
                player.m_7292_(instance);
                continue;
            }
            int n = sliceDuration = slicesLeft > 0 ? totalDurationTicks / slicesLeft : totalDurationTicks;
            if (sliceDuration > 0) {
                MobEffectInstance instance = new MobEffectInstance(mobEffect, sliceDuration, amplifier, false, true);
                player.m_7292_(instance);
            }
            int newTotal = totalDurationTicks - sliceDuration;
            eff.m_128405_("Duration", Math.max(newTotal, 0));
        }
        singlePotion.m_128365_("Effects", (Tag)effectsList);
        potionsList.set(0, (Tag)singlePotion);
        brewChewData.m_128365_("Potions", (Tag)potionsList);
        CakeData.putData(level, pos, brewChewData);
    }
}

