/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.event;

import com.eruannie_9.brewchew.capability.ModCapabilities;
import com.eruannie_9.brewchew.packethandler.PacketHandler;
import com.eruannie_9.brewchew.packethandler.pack.SyncGuideMaskPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="brewchew", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class GuideSyncEvents {
    private GuideSyncEvents() {
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            GuideSyncEvents.sendMask(sp);
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            GuideSyncEvents.sendMask(sp);
        }
    }

    private static void sendMask(ServerPlayer sp) {
        sp.getCapability(ModCapabilities.GUIDE_OBFUSCATION).ifPresent(cap -> {
            int mask = cap.getRevealedMask();
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new SyncGuideMaskPacket(mask));
        });
    }
}

