/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.gui;

import com.eruannie_9.brewchew.util.flower.GuidePageData;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BrewingCauldronGuideScreen
extends Screen {
    private static final ResourceLocation BG_TEX_0 = new ResourceLocation("brewchew", "textures/gui/guide_screen.png");
    private static final ResourceLocation BG_TEX_1 = new ResourceLocation("brewchew", "textures/gui/guide_screen_2.png");
    private static final int TEX_W = 256;
    private static final int TEX_H = 256;
    private static final int BG_W = 176;
    private static final int BG_H = 227;
    private static final int COLOR = 5715460;
    private static final int MIN_W = 8;
    private static final int MIN_H = 8;
    private static final float BODY_TEXT_SCALE = 0.8f;
    private static final ResourceLocation ALT_FONT = new ResourceLocation("minecraft", "alt");
    private static final Style RUNE_STYLE = Style.f_131099_.m_131150_(ALT_FONT);
    private static int clientMask = 0;
    private final Map<ResourceLocation, ResourceLocation> obfuscatedFlowerCache = new HashMap<ResourceLocation, ResourceLocation>();
    private final Screen parent;
    private int leftPos;
    private int topPos;
    private int page = 0;
    private Button leftBtn;
    private Button rightBtn;
    private Button closeBtn;
    private int unionX1;
    private int unionY1;
    private int unionX2;
    private int unionY2;

    public BrewingCauldronGuideScreen(Screen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
    }

    private boolean isPageObfuscated() {
        if (this.page < 0 || this.page >= GuidePageData.PAGES.length) {
            return true;
        }
        return (clientMask & 1 << this.page) == 0;
    }

    public static void setClientMask(int mask) {
        clientMask = mask;
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 176) / 2;
        this.topPos = (this.f_96544_ - 227) / 2;
        this.addNavButtons();
        this.addCloseButton();
    }

    private void addNavButtons() {
        int y = this.topPos - 4 + 198;
        this.rightBtn = (Button)this.m_142416_((GuiEventListener)this.buildArrowButton(this.leftPos + 119, y, () -> {
            this.page = Mth.m_14045_((int)(this.page + 1), (int)0, (int)(GuidePageData.PAGES.length - 1));
            this.playPageTurn();
        }, 31, 7, 232));
        this.leftBtn = (Button)this.m_142416_((GuiEventListener)this.buildArrowButton(this.leftPos + 37, y, () -> {
            this.page = Mth.m_14045_((int)(this.page - 1), (int)0, (int)(GuidePageData.PAGES.length - 1));
            this.playPageTurn();
        }, 32, 7, 244));
    }

    private Button buildArrowButton(int x, int y, Runnable click, final int hoverU, final int normalU, final int v) {
        return Button.m_253074_((Component)Component.m_237119_(), b -> click.run()).m_252794_(x, y).m_253046_(18, 10).build(builder -> new Button((Button.Builder)builder){

            public void m_87963_(@NotNull GuiGraphics guiG, int mx, int my, float pt) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEX_0);
                int u = this.m_274382_() ? hoverU : normalU;
                guiG.m_280163_(BG_TEX_0, this.m_252754_(), this.m_252907_(), (float)u, (float)v, this.f_93618_, this.f_93619_, 256, 256);
            }

            public void m_7435_(@NotNull SoundManager m) {
            }
        });
    }

    private void addCloseButton() {
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), b -> this.m_7379_()).m_252794_(this.leftPos + 143, this.topPos - 4).m_253046_(11, 13).build(builder -> new Button((Button.Builder)builder){
            private float lift;
            {
                this.lift = 0.0f;
            }

            public void m_87963_(@NotNull GuiGraphics guiG, int mx, int my, float pt) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEX_0);
                boolean hovered = this.m_274382_();
                this.lift += ((hovered ? -2.0f : 0.0f) - this.lift) * 0.3f;
                guiG.m_280163_(BG_TEX_0, this.m_252754_(), this.m_252907_() + Math.round(this.lift), hovered ? 70.0f : 56.0f, 232.0f, 11, 16, 256, 256);
            }
        }));
    }

    private void playPageTurn() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiG, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiG);
        if (this.closeBtn != null) {
            this.closeBtn.m_88315_(guiG, mouseX, mouseY, partialTicks);
        }
        this.drawPageBackground(guiG);
        this.drawCombinedBackgroundAndFlower(guiG);
        boolean tmp = this.closeBtn.f_93624_;
        this.closeBtn.f_93624_ = false;
        super.m_88315_(guiG, mouseX, mouseY, partialTicks);
        this.closeBtn.f_93624_ = tmp;
        this.leftBtn.f_93624_ = this.page > 0;
        this.rightBtn.f_93624_ = this.page < GuidePageData.PAGES.length - 1;
        this.drawLabels(guiG);
        this.drawWrappedText(guiG);
    }

    private void drawPageBackground(GuiGraphics guiG) {
        guiG.m_280163_(this.page == 0 ? BG_TEX_0 : BG_TEX_1, this.leftPos, this.topPos - 4, 0.0f, 0.0f, 176, 227, 256, 256);
    }

    private void drawCombinedBackgroundAndFlower(GuiGraphics guiG) {
        PoseStack ps = guiG.m_280168_();
        GuidePageData.GuidePage p = GuidePageData.PAGES[this.page];
        int bgU = p.bgType().u;
        int bgV = p.bgType().v;
        int bgW = p.bgType().w;
        int bgH = p.bgType().h;
        boolean even = (this.page + 1) % 2 == 0;
        int bgX = this.leftPos + (even ? 64 : 28);
        int bgY = this.topPos + (even ? 82 : 34);
        if (even && p.bgType() == GuidePageData.BGType.BG2) {
            bgY += 20;
            bgX -= 3;
        } else if (even && p.bgType() == GuidePageData.BGType.BG1) {
            bgY -= 10;
        }
        if (!even && p.bgType() == GuidePageData.BGType.BG2) {
            bgY += 10;
        }
        bgX = even ? (bgX += 9) : (bgX -= 2);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEX_0);
        guiG.m_280163_(BG_TEX_0, bgX, bgY, (float)bgU, (float)bgV, bgW, bgH, 256, 256);
        int fU = p.flowerU();
        int fV = p.flowerV();
        int fW = p.flowerW();
        int fH = p.flowerH();
        int fX = bgX + (bgW - fW) / 2;
        int fY = bgY + (bgH - fH) / 2;
        ps.m_85836_();
        float scale = 0.9f * p.flowerScale();
        float cx = (float)fX + (float)fW / 2.0f;
        float cy = (float)fY + (float)fH / 2.0f;
        ps.m_252880_(cx, cy, 0.0f);
        ps.m_85841_(scale, scale, 1.0f);
        ps.m_252880_(-cx, -cy, 0.0f);
        ResourceLocation flowerTex = this.isPageObfuscated() ? this.obfuscatedFlowerCache.computeIfAbsent(p.flowerTexture(), this::flatColorMaskedTexture) : p.flowerTexture();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)flowerTex);
        guiG.m_280163_(flowerTex, fX, fY, (float)fU, (float)fV, fW, fH, 256, 256);
        RenderSystem.disableBlend();
        float tlX = ((float)fX - cx) * scale + cx;
        float tlY = ((float)fY - cy) * scale + cy;
        float brX = ((float)(fX + fW) - cx) * scale + cx;
        float brY = ((float)(fY + fH) - cy) * scale + cy;
        this.unionX1 = Math.min(bgX, Math.round(tlX));
        this.unionY1 = Math.min(bgY, Math.round(tlY));
        this.unionX2 = Math.max(bgX + bgW, Math.round(brX));
        this.unionY2 = Math.max(bgY + bgH, Math.round(brY));
        ps.m_85849_();
    }

    private ResourceLocation flatColorMaskedTexture(ResourceLocation original) {
        try {
            NativeImage img = NativeImage.m_85058_((InputStream)Minecraft.m_91087_().m_91098_().m_215595_(original));
            int w = img.m_84982_();
            int h = img.m_85084_();
            NativeImage flat = new NativeImage(NativeImage.Format.RGBA, w, h, false);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int a = img.m_84985_(x, y) >>> 24 & 0xFF;
                    flat.m_84988_(x, y, a << 24 | 0x42132);
                }
            }
            img.close();
            TextureManager tm = Minecraft.m_91087_().m_91097_();
            return tm.m_118490_("obfuscated_flower/" + original.m_135815_(), new DynamicTexture(flat));
        }
        catch (Exception e) {
            return original;
        }
    }

    private void drawLabels(GuiGraphics guiG) {
        PoseStack ps = guiG.m_280168_();
        GuidePageData.GuidePage p = GuidePageData.PAGES[this.page];
        int centerX = this.leftPos + 88;
        if (this.isPageObfuscated()) {
            String runes = this.randomMorse(7, 15, this.page * 741 + 20236);
            MutableComponent txt = Component.m_237113_((String)runes).m_130948_(RUNE_STYLE);
            guiG.m_280614_(this.f_96547_, (Component)txt, (int)((float)centerX - (float)this.f_96547_.m_92852_((FormattedText)txt) / 2.0f), this.topPos - 4 + 22, 5715460, false);
        } else {
            String title = p.title();
            guiG.m_280056_(this.f_96547_, title, (int)((float)centerX - (float)this.f_96547_.m_92895_(title) / 2.0f), this.topPos - 4 + 22, 5715460, false);
        }
        ps.m_85836_();
        ps.m_85841_(0.8888889f, 0.8888889f, 1.0f);
        String num = String.valueOf(this.page + 1);
        float cx = (float)(this.leftPos + 82 + 7) / 0.8888889f;
        float f = this.topPos - 4 + 198;
        Objects.requireNonNull(this.f_96547_);
        float cy = (f + (float)(10 - 9) / 2.0f + 0.8f + 0.5f) / 0.8888889f;
        guiG.m_280056_(this.f_96547_, num, (int)(cx - (float)this.f_96547_.m_92895_(num) / 2.0f), (int)cy, 5715460, false);
        ps.m_85849_();
    }

    private void drawWrappedText(GuiGraphics guiG) {
        int mx1 = this.leftPos + 23;
        int my1 = this.topPos - 4 + 38;
        int mx2 = this.leftPos + 151;
        int my2 = this.topPos - 4 + 189;
        int rx1 = Math.max(mx1, this.unionX1);
        int ry1 = Math.max(my1, this.unionY1);
        int rx2 = Math.min(mx2, this.unionX2);
        int ry2 = Math.min(my2, this.unionY2);
        List<String> words = Arrays.stream(BrewingCauldronGuideScreen.resolve(GuidePageData.PAGES[this.page].bodyTextKey()).replace("\r", "").replace('\n', ' ').split("\\s+")).collect(Collectors.toList());
        ArrayDeque<String> pending = new ArrayDeque<String>();
        boolean obf = this.isPageObfuscated();
        int idx = 0;
        if (ry1 > my1) {
            idx = this.drawWords(guiG, words, idx, mx1, my1, mx2, ry1, obf, pending);
        }
        if (rx1 > mx1 && ry2 > ry1) {
            idx = this.drawWords(guiG, words, idx, mx1, ry1, rx1, ry2, obf, pending);
        }
        if (rx2 < mx2 && ry2 > ry1) {
            idx = this.drawWords(guiG, words, idx, rx2, ry1, mx2, ry2, obf, pending);
        }
        if (ry2 < my2) {
            this.drawWords(guiG, words, idx, mx1, ry2, mx2, my2, obf, pending);
        }
    }

    private int drawWords(GuiGraphics guiG, List<String> words, int start, int x1, int y1, int x2, int y2, boolean obf, Deque<String> pending) {
        if (x2 <= x1 || y2 <= y1) {
            return start;
        }
        int w = x2 - x1;
        int h = y2 - y1;
        if (w < 8 || h < 8) {
            return start;
        }
        int margin = 2;
        int usableW = w - margin * 2;
        int usableH = h - margin * 2;
        float lineY = y1 + margin;
        Objects.requireNonNull(this.f_96547_);
        float lineH = 9.0f * 0.8f;
        StringBuilder line = new StringBuilder();
        int i = start;
        RandomSource rng = RandomSource.m_216335_((long)((long)this.page * 1337L));
        while (!(i >= words.size() && pending.isEmpty() || lineY + lineH > (float)(y1 + margin + usableH))) {
            String next = pending.isEmpty() ? words.get(i++) : pending.pollFirst();
            Object spaced = line.isEmpty() ? next : " " + next;
            String cand = line + (String)spaced;
            if ((float)this.f_96547_.m_92895_(cand) * 0.8f > (float)usableW) {
                if (!line.isEmpty()) {
                    this.drawLine(guiG, x1 + margin, lineY, usableW, line.toString(), obf, rng);
                    line.setLength(0);
                    lineY += lineH;
                    pending.addFirst(next);
                    continue;
                }
                List<String> chunks = this.splitWord(next, usableW);
                if (chunks.isEmpty()) continue;
                this.drawLine(guiG, x1 + margin, lineY, usableW, chunks.get(0), obf, rng);
                lineY += lineH;
                for (int c = chunks.size() - 1; c > 0; --c) {
                    pending.addFirst(chunks.get(c));
                }
                continue;
            }
            line.append((String)spaced);
        }
        if (!line.isEmpty() && lineY + lineH <= (float)(y1 + margin + usableH)) {
            this.drawLine(guiG, x1 + margin, lineY, usableW, line.toString(), obf, rng);
        }
        return i;
    }

    private void drawLine(GuiGraphics guiG, float x, float y, float usableW, String text, boolean obf, RandomSource rng) {
        if (obf) {
            char c;
            float cw;
            StringBuilder fake = new StringBuilder();
            float acc = 0.0f;
            String letters = "abcdefghijklmnopqrstuvwxyz";
            while (!(acc + (cw = (float)this.f_96547_.m_92895_(String.valueOf(c = rng.m_188503_(8) == 0 ? (char)' ' : (char)letters.charAt(rng.m_188503_(letters.length())))) * 0.8f) > usableW)) {
                fake.append(c);
                acc += cw;
            }
            this.drawScaledRune(guiG, fake.toString(), x, y);
        } else {
            this.drawScaled(guiG, text, x, y);
        }
    }

    private void drawScaledRune(GuiGraphics guiG, String txt, float x, float y) {
        PoseStack ps = guiG.m_280168_();
        ps.m_85836_();
        ps.m_252880_(x, y, 0.0f);
        ps.m_85841_(0.8f, 0.8f, 1.0f);
        guiG.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)txt).m_130948_(RUNE_STYLE), 0, 0, 5715460, false);
        ps.m_85849_();
    }

    private List<String> splitWord(String word, float usableW) {
        ArrayList<String> out = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (int pos = 0; pos < word.length(); ++pos) {
            current.append(word.charAt(pos));
            boolean hyphen = "-\u2014\u2013".indexOf(current.charAt(current.length() - 1)) >= 0;
            float widthCheck = (float)this.f_96547_.m_92895_(current + (hyphen ? "" : "-")) * 0.8f;
            if (!(widthCheck > usableW)) continue;
            if (current.length() == 1) {
                out.add(current.toString());
                current.setLength(0);
                continue;
            }
            String seg = current.substring(0, current.length() - 1);
            char carry = current.charAt(current.length() - 1);
            out.add(seg + (hyphen ? "" : "-"));
            current.setLength(0);
            current.append(carry);
        }
        if (!current.isEmpty()) {
            out.add(current.toString());
        }
        return out;
    }

    private void drawScaled(GuiGraphics guiG, String txt, float x, float y) {
        PoseStack ps = guiG.m_280168_();
        ps.m_85836_();
        ps.m_252880_(x, y, 0.0f);
        ps.m_85841_(0.8f, 0.8f, 1.0f);
        guiG.m_280056_(this.f_96547_, txt, 0, 0, 5715460, false);
        ps.m_85849_();
    }

    private static String resolve(String key) {
        return I18n.m_118936_((String)key) ? I18n.m_118938_((String)key, (Object[])new Object[0]) : key;
    }

    private String randomMorse(int min, int max, int seed) {
        RandomSource rng = RandomSource.m_216335_((long)seed);
        int len = min + rng.m_188503_(max - min + 1);
        StringBuilder sb = new StringBuilder();
        String letters = "abcdefghijklmnopqrstuvwxyz";
        for (int i = 0; i < len; ++i) {
            if (rng.m_188503_(8) == 0) {
                sb.append(' ');
                continue;
            }
            sb.append(letters.charAt(rng.m_188503_(letters.length())));
        }
        return sb.toString();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }
}

