/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.gui;

import com.eruannie_9.brewchew.block.BrewingCauldronBlockEntity;
import com.eruannie_9.brewchew.gui.ModMenuTypes;
import com.eruannie_9.brewchew.util.flower.FlowerTooltipStyler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingCauldronInfusionMenu
extends AbstractContainerMenu {
    @Nullable
    private final BrewingCauldronBlockEntity blockEntity;
    private final Container settingsContainer;
    private final BlockPos pos;
    private final Player player;

    public BrewingCauldronInfusionMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(windowId, playerInv, extraData.m_130135_());
    }

    public BrewingCauldronInfusionMenu(int windowId, Inventory playerInv, BlockPos pos) {
        super((MenuType)ModMenuTypes.BREWING_CAULDRON_INFUSION_MENU.get(), windowId);
        this.pos = pos;
        this.player = playerInv.f_35978_;
        BlockEntity be = this.player.m_9236_().m_7702_(this.pos);
        if (be instanceof BrewingCauldronBlockEntity) {
            BrewingCauldronBlockEntity bcbe;
            this.blockEntity = bcbe = (BrewingCauldronBlockEntity)be;
            this.settingsContainer = bcbe.getSettingsContainer();
        } else {
            this.blockEntity = null;
            this.settingsContainer = new SimpleContainer(2);
        }
        ContainerData data = this.createContainerData();
        this.m_38884_(data);
        this.setupSlots(playerInv);
    }

    private ContainerData createContainerData() {
        return new ContainerData(){

            public int m_6413_(int idx) {
                if (BrewingCauldronInfusionMenu.this.blockEntity == null) {
                    return 0;
                }
                return switch (idx) {
                    case 0 -> BrewingCauldronInfusionMenu.this.blockEntity.getConsumptionCountdown();
                    case 1 -> {
                        if (BrewingCauldronInfusionMenu.this.blockEntity.isConsumptionPending()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int idx, int val) {
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    private void setupSlots(Inventory playerInv) {
        this.m_38897_(new Slot(this.settingsContainer, 0, 94, 51){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return BrewingCauldronInfusionMenu.this.canInfuseItem(stack);
            }

            public void m_5852_(@NotNull ItemStack incoming) {
                BrewingCauldronBlockEntity.ConsumptionType t;
                super.m_5852_(incoming);
                if (!incoming.m_41619_() && BrewingCauldronInfusionMenu.this.blockEntity != null && (t = BrewingCauldronInfusionMenu.this.determineConsumptionType(incoming)) != null) {
                    BrewingCauldronInfusionMenu.this.blockEntity.startConsumption(t);
                }
            }

            public boolean m_8010_(@NotNull Player p) {
                if (BrewingCauldronInfusionMenu.this.blockEntity != null && BrewingCauldronInfusionMenu.this.blockEntity.isConsumptionPending()) {
                    BrewingCauldronInfusionMenu.this.blockEntity.cancelConsumption();
                }
                return super.m_8010_(p);
            }

            public int m_5866_(@NotNull ItemStack s) {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.settingsContainer, 1, 148, 51){

            public boolean m_5857_(@NotNull ItemStack s) {
                return false;
            }

            public boolean m_8010_(@NotNull Player p) {
                return false;
            }
        });
        int PX = 8;
        int PY = 122;
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.m_38897_(new Slot((Container)playerInv, 9 + c + r * 9, 8 + c * 18, 122 + r * 18));
            }
        }
        int HX = 8;
        int HY = 180;
        for (int c = 0; c < 9; ++c) {
            this.m_38897_(new Slot((Container)playerInv, c, 8 + c * 18, 180));
        }
    }

    private boolean canInfuseItem(@NotNull ItemStack stack) {
        if (this.blockEntity == null || stack.m_41619_()) {
            return false;
        }
        if (this.blockEntity.isConsumptionPending()) {
            return false;
        }
        if (BrewingCauldronInfusionMenu.isAllowedFlower(stack)) {
            Item stored = this.blockEntity.getStoredFlower();
            return stored == null || stored != stack.m_41720_();
        }
        if (stack.m_150930_(Items.f_41952_) || stack.m_150930_(Items.f_41953_)) {
            Item storedFlower = this.blockEntity.getStoredFlower();
            Item storedMush = this.blockEntity.getStoredMushroom();
            if (storedFlower == null || storedFlower != Items.f_41951_) {
                return storedMush == null || storedMush != stack.m_41720_();
            }
            if (storedMush == Items.f_41953_) {
                return !stack.m_150930_(Items.f_41953_);
            }
            if (stack.m_150930_(Items.f_41952_)) {
                return false;
            }
            return storedMush == null || storedMush != stack.m_41720_();
        }
        return false;
    }

    @Nullable
    private BrewingCauldronBlockEntity.ConsumptionType determineConsumptionType(@NotNull ItemStack stack) {
        if (BrewingCauldronInfusionMenu.isAllowedFlower(stack)) {
            return BrewingCauldronBlockEntity.ConsumptionType.FLOWER;
        }
        if (stack.m_150930_(Items.f_41952_)) {
            return BrewingCauldronBlockEntity.ConsumptionType.MUSHROOM_BROWN;
        }
        if (stack.m_150930_(Items.f_41953_)) {
            return BrewingCauldronBlockEntity.ConsumptionType.MUSHROOM_RED;
        }
        return null;
    }

    private static boolean isAllowedFlower(ItemStack stack) {
        return stack.m_150930_(Items.f_41951_) || FlowerTooltipStyler.getFlowerMode(stack.m_41720_()) != FlowerTooltipStyler.FlowerMode.NONE;
    }

    public boolean isConsumptionPending() {
        return this.blockEntity != null && this.blockEntity.isConsumptionPending();
    }

    public int getConsumptionCountdown() {
        return this.blockEntity != null ? this.blockEntity.getConsumptionCountdown() : 0;
    }

    public int getConsumptionDelay() {
        return this.blockEntity != null ? this.blockEntity.getConsumptionDelay() : 50;
    }

    public boolean m_6875_(@NotNull Player p) {
        return true;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public void m_38946_() {
        ItemStack preview;
        if (this.blockEntity != null && !this.player.m_9236_().f_46443_ && !(preview = this.settingsContainer.m_8020_(1)).m_41619_()) {
            this.blockEntity.applyInfusionTags(preview);
        }
        super.m_38946_();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack inSlot = slot.m_7993_();
        ItemStack original = inSlot.m_41777_();
        int menuSize = 2;
        if (index < menuSize) {
            if (!this.m_38903_(inSlot, menuSize, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else {
            Slot infSlot = (Slot)this.f_38839_.get(0);
            if (infSlot.m_5857_(inSlot) && !infSlot.m_6657_()) {
                ItemStack single = inSlot.m_41620_(1);
                infSlot.m_5852_(single);
            } else {
                return ItemStack.f_41583_;
            }
        }
        if (inSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return original;
    }
}

