/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.gui;

import com.eruannie_9.booklinggear.util.TabWidget;
import com.eruannie_9.brewchew.ModConfiguration;
import com.eruannie_9.brewchew.block.BrewingCauldronBlockEntity;
import com.eruannie_9.brewchew.gui.BrewingCauldronGuideScreen;
import com.eruannie_9.brewchew.gui.BrewingCauldronInfusionMenu;
import com.eruannie_9.brewchew.packethandler.PacketHandler;
import com.eruannie_9.brewchew.packethandler.pack.OpenMainMenuPacket;
import com.eruannie_9.brewchew.util.flower.FlowerAnimationRenderer;
import com.eruannie_9.brewchew.util.flower.FlowerTooltipStyler;
import com.eruannie_9.brewchew.util.render.gui.slot.AnimatedSlot;
import com.eruannie_9.brewchew.util.render.gui.slot.IconFrame;
import com.eruannie_9.brewchew.util.render.gui.tooltip.PreviewTooltipRenderer;
import com.eruannie_9.brewchew.util.render.gui.water.CauldronAnimationRenderer;
import com.eruannie_9.brewchew.util.render.gui.water.CauldronRendererManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BrewingCauldronInfusionScreen
extends AbstractContainerScreen<BrewingCauldronInfusionMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("brewchew", "textures/gui/brewing_cauldron_settings_gui.png");
    private static final ResourceLocation MAIN_ICON = new ResourceLocation("brewchew", "textures/gui/main_tab.png");
    private static final ResourceLocation INFUSION_ICON = new ResourceLocation("brewchew", "textures/gui/infusion_tab.png");
    private static final ResourceLocation GUIDE_ICON = new ResourceLocation("brewchew", "textures/gui/guide_tab_icon.png");
    private static final ResourceLocation SOUND_ON = new ResourceLocation("brewchew", "textures/gui/sound_on.png");
    private static final ResourceLocation SOUND_OFF = new ResourceLocation("brewchew", "textures/gui/sound_off.png");
    private static final ItemStack[] FLOWER_POOL = new ItemStack[]{new ItemStack((ItemLike)Items.f_41939_), new ItemStack((ItemLike)Items.f_41940_), new ItemStack((ItemLike)Items.f_41941_), new ItemStack((ItemLike)Items.f_41942_), new ItemStack((ItemLike)Items.f_41943_), new ItemStack((ItemLike)Items.f_41944_), new ItemStack((ItemLike)Items.f_41945_), new ItemStack((ItemLike)Items.f_41946_), new ItemStack((ItemLike)Items.f_41947_), new ItemStack((ItemLike)Items.f_41948_), new ItemStack((ItemLike)Items.f_41949_), new ItemStack((ItemLike)Items.f_41950_), new ItemStack((ItemLike)Items.f_41951_)};
    private static final IconFrame[] GUIDE_SLOT_FRAMES = new IconFrame[]{new IconFrame(176, 0), new IconFrame(176, 16), new IconFrame(176, 32), new IconFrame(176, 48), new IconFrame(176, 64), new IconFrame(176, 80), new IconFrame(176, 96), new IconFrame(176, 112), new IconFrame(176, 128), new IconFrame(176, 144), new IconFrame(176, 160), new IconFrame(176, 176), new IconFrame(192, 0), new IconFrame(192, 16), new IconFrame(192, 32)};
    private static final int CLIP_L = 3;
    private static final int CLIP_T = 3;
    private static final int CLIP_R = 93;
    private static final int CLIP_B = 107;
    private static final int[] DISAPPEAR_BOUNDS = new int[]{36, 48, 61, 57};
    private static final int[][] SPAWN_BOUNDS = new int[][]{{9, 8, 14, 13}, {39, 7, 45, 13}, {77, 21, 81, 25}, {87, 37, 92, 42}, {85, 85, 89, 89}, {75, 96, 80, 101}, {5, 87, 10, 92}, {14, 98, 19, 103}};
    private static final int MAX_ACTIVE_FLOWERS = 5;
    private static final float FLOWER_CYCLE_SPEED = 0.7f;
    private final AnimatedSlot slotAnimation;
    private final List<FlowerAnimationRenderer> activeFlowers = new ArrayList<FlowerAnimationRenderer>();
    private final RandomSource random = RandomSource.m_216327_();
    private final CauldronAnimationRenderer waterAnimation = CauldronRendererManager.getRenderer();
    private int ticksSinceLastSpawn = 0;
    private int spawnInterval = 0;

    public BrewingCauldronInfusionScreen(BrewingCauldronInfusionMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 204;
        this.f_97730_ = 8;
        this.f_97731_ = 111;
        this.slotAnimation = new AnimatedSlot(94, 51, 0, GUIDE_SLOT_FRAMES, this.random);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initTabs();
        this.spawnInterval = 30 + this.random.m_188503_(31);
    }

    private void initTabs() {
        boolean baseScreen = false;
        BlockPos pos = ((BrewingCauldronInfusionMenu)this.f_97732_).getBlockPos();
        this.createTabs(baseScreen, pos).forEach(x$0 -> {
            TabWidget cfr_ignored_0 = (TabWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    private List<TabWidget> createTabs(boolean baseScreen, BlockPos pos) {
        float baseScale = 0.95f;
        float hoverScale = 1.2f;
        float animSpeed = 0.08f;
        List<TabWidget.TabPictureData> data = List.of(new TabWidget.TabPictureData("Cauldron", () -> baseScreen, b -> {
            if (!baseScreen) {
                PacketHandler.CHANNEL.sendToServer((Object)new OpenMainMenuPacket(pos));
            }
        }, () -> MAIN_ICON, baseScale, hoverScale, animSpeed, null), new TabWidget.TabPictureData("Flower Extraction", () -> !baseScreen, b -> {}, () -> INFUSION_ICON, baseScale, hoverScale, animSpeed, null), new TabWidget.TabPictureData("Floriography", () -> false, btn -> Minecraft.m_91087_().m_91152_((Screen)new BrewingCauldronGuideScreen((Screen)this)), () -> GUIDE_ICON, baseScale, hoverScale, animSpeed, null), new TabWidget.TabPictureData("Boiling Sound", () -> (Boolean)ModConfiguration.CAULDRON_SOUNDS.get() == false, b -> {
            boolean cur = (Boolean)ModConfiguration.CAULDRON_SOUNDS.get();
            ModConfiguration.CAULDRON_SOUNDS.set((Object)(!cur ? 1 : 0));
            ModConfiguration.SPEC.save();
        }, () -> (Boolean)ModConfiguration.CAULDRON_SOUNDS.get() != false ? SOUND_ON : SOUND_OFF, baseScale, hoverScale, animSpeed, null));
        ResourceLocation tabTex = new ResourceLocation("brewchew", "textures/gui/guide_tab.png");
        Function<TabWidget.TabPictureData, TabWidget.SoundPlayStrategy> mapper = t -> "Boiling Sound".equals(t.label()) ? tab -> true : TabWidget.ONLY_IF_NOT_SELECTED;
        return TabWidget.createTabsFromPictureData((Screen)this, (int)this.f_97735_, (int)this.f_97736_, (int)this.f_97726_, data, (ResourceLocation)tabTex, (boolean)true, (boolean)true, mapper);
    }

    public void m_7379_() {
        TabWidget.clearScaleCache();
        super.m_7379_();
    }

    public void m_88315_(@NotNull GuiGraphics gfx, int mouseX, int mouseY, float pt) {
        this.m_280273_(gfx);
        if (this.slotAnimation != null) {
            this.slotAnimation.tick();
        }
        super.m_88315_(gfx, mouseX, mouseY, pt);
        BrewingCauldronInfusionScreen.enableScissor(this.f_97735_ + 3, this.f_97736_ + 3, 90, 104);
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        int alive = 0;
        for (FlowerAnimationRenderer fa : this.activeFlowers) {
            fa.update(0.7f);
            fa.draw(gfx, (MultiBufferSource)buf);
            if (!(fa.getProgress() < 1.0f)) continue;
            ++alive;
        }
        buf.m_109911_();
        RenderSystem.disableScissor();
        if (alive < 5 && ++this.ticksSinceLastSpawn >= this.spawnInterval) {
            this.createNewFlowers();
            this.ticksSinceLastSpawn = 0;
            this.spawnInterval = 40 + this.random.m_188503_(61);
        }
        this.m_280072_(gfx, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics gfx, float pt, int mouseX, int mouseY) {
        Slot slot;
        gfx.m_280163_(BACKGROUND_TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        if (this.slotAnimation != null && (slot = ((BrewingCauldronInfusionMenu)this.f_97732_).m_38853_(this.slotAnimation.containerSlotIndex())).m_7993_().m_41619_()) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            IconFrame f = this.slotAnimation.getCurrentBaseFrame();
            gfx.m_280163_(BACKGROUND_TEXTURE, this.f_97735_ + this.slotAnimation.x(), this.f_97736_ + this.slotAnimation.y(), (float)f.u(), (float)f.v(), 16, 16, 256, 256);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (((BrewingCauldronInfusionMenu)this.f_97732_).isConsumptionPending()) {
            int cd = ((BrewingCauldronInfusionMenu)this.f_97732_).getConsumptionCountdown();
            int delay = ((BrewingCauldronInfusionMenu)this.f_97732_).getConsumptionDelay();
            int adj = Math.max(cd - 10, 0);
            float prog = 1.0f - (float)adj / (float)delay;
            int barX = this.f_97735_ + 118;
            int barY = this.f_97736_ + 54;
            int fill = (int)(22.0f * prog);
            if (fill > 0) {
                RenderSystem.enableBlend();
                gfx.m_280163_(BACKGROUND_TEXTURE, barX, barY, 196.0f, 51.0f, fill, 10, 256, 256);
                RenderSystem.disableBlend();
            }
        }
        this.waterAnimation.render(gfx, this.f_97735_, this.f_97736_);
    }

    protected void m_280003_(@NotNull GuiGraphics gfx, int mouseX, int mouseY) {
        gfx.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    protected void m_280072_(@NotNull GuiGraphics gfx, int mouseX, int mouseY) {
        Slot hovered = this.f_97734_;
        if (hovered == null || hovered.f_40219_ != 1 || !hovered.m_6657_()) {
            super.m_280072_(gfx, mouseX, mouseY);
            return;
        }
        BlockEntity be = Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91073_).m_7702_(((BrewingCauldronInfusionMenu)this.f_97732_).getBlockPos());
        if (!(be instanceof BrewingCauldronBlockEntity)) {
            super.m_280072_(gfx, mouseX, mouseY);
            return;
        }
        BrewingCauldronBlockEntity bcbe = (BrewingCauldronBlockEntity)be;
        ItemStack stack = hovered.m_7993_();
        Item bloom = bcbe.getStoredFlower();
        if (bloom == Items.f_41951_) {
            gfx.m_280153_(this.f_96547_, stack, mouseX, mouseY);
            return;
        }
        FlowerTooltipStyler.FlowerMode mode = FlowerTooltipStyler.getFlowerMode(bloom);
        int tCol = Objects.requireNonNull(mode).getTitleColor();
        int lCol = mode.getLabelColor();
        int vCol = mode.getValueColor();
        List<MutableComponent> textLines = List.of(Component.m_237113_((String)"Example Food").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)tCol))), Component.m_237113_((String)" "), BrewingCauldronInfusionScreen.buildLine("Effect: ", "Example", lCol, vCol), BrewingCauldronInfusionScreen.buildLine("Amplifier: ", "2", lCol, vCol), BrewingCauldronInfusionScreen.buildLine("Duration: ", "1:30", lCol, vCol), Component.m_237113_((String)" "), Component.m_237113_((String)"Slot Locked!").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000))));
        List<FormattedCharSequence> formatted = textLines.stream().flatMap(c -> this.f_96547_.m_92923_((FormattedText)c, 200).stream()).collect(Collectors.toList());
        PreviewTooltipRenderer.drawVanillaTooltipWithVerticalGradient(gfx, formatted, mouseX, mouseY, this.f_96543_, this.f_96544_, this.f_96547_, mode.getBackgroundColor(), mode.getBackgroundColor(), mode.getBorderStartColor(), mode.getBorderEndColor());
    }

    private static Component buildLine(String label, String value, int labCol, int valCol) {
        return Component.m_237113_((String)label).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)labCol))).m_7220_((Component)Component.m_237113_((String)value).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)valCol))));
    }

    private void createNewFlowers() {
        int cnt = 2 + this.random.m_188503_(2);
        for (int i = 0; i < cnt; ++i) {
            ItemStack flower = FLOWER_POOL[this.random.m_188503_(FLOWER_POOL.length)].m_41777_();
            FlowerAnimationRenderer fa = new FlowerAnimationRenderer(flower);
            fa.initAvoidCollisions(this.random, this.f_97735_ + 3, this.f_97735_ + 93, this.f_97736_ + 3, this.f_97736_ + 107, SPAWN_BOUNDS, DISAPPEAR_BOUNDS, this.activeFlowers);
            this.activeFlowers.add(fa);
        }
    }

    public static void enableScissor(int x, int y, int w, int h) {
        Minecraft mc = Minecraft.m_91087_();
        double scale = mc.m_91268_().m_85449_();
        int sx = (int)((double)x * scale);
        int sy = (int)((double)(mc.m_91268_().m_85446_() - (y + h)) * scale);
        int sw = (int)((double)w * scale);
        int sh = (int)((double)h * scale);
        RenderSystem.enableScissor((int)sx, (int)sy, (int)sw, (int)sh);
    }
}

