/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.gui;

import com.eruannie_9.brewchew.block.BrewingCauldronBlockEntity;
import com.eruannie_9.brewchew.capability.ModCapabilities;
import com.eruannie_9.brewchew.gui.ModMenuTypes;
import com.eruannie_9.brewchew.packethandler.PacketHandler;
import com.eruannie_9.brewchew.packethandler.pack.SyncGuideMaskPacket;
import com.eruannie_9.brewchew.recipe.BrewingCauldronRecipe;
import com.eruannie_9.brewchew.recipe.ModRecipes;
import com.eruannie_9.brewchew.util.flower.FlowerEffectUtil;
import com.eruannie_9.brewchew.util.flower.GuidePages;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingCauldronMainMenu
extends AbstractContainerMenu {
    @Nullable
    private final BrewingCauldronBlockEntity blockEntity;
    private final Container container;
    private final Level level;

    public BrewingCauldronMainMenu(int windowId, Inventory playerInv, BrewingCauldronBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.BREWING_CAULDRON_MAIN_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.container = blockEntity.getContainer();
        this.level = blockEntity.m_58904_();
        this.addCauldronSlots();
        this.addPlayerSlots(playerInv);
    }

    public BrewingCauldronMainMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenuTypes.BREWING_CAULDRON_MAIN_MENU.get(), windowId);
        BlockPos pos = extraData.m_130135_();
        BrewingCauldronBlockEntity be = null;
        BlockEntity blkEnt = playerInv.f_35978_.m_9236_().m_7702_(pos);
        if (blkEnt instanceof BrewingCauldronBlockEntity) {
            BrewingCauldronBlockEntity bcbe;
            be = bcbe = (BrewingCauldronBlockEntity)blkEnt;
        }
        if (be == null) {
            this.blockEntity = null;
            this.container = new SimpleContainer(6);
            this.level = playerInv.f_35978_.m_9236_();
        } else {
            this.blockEntity = be;
            this.container = be.getContainer();
            this.level = be.m_58904_();
        }
        this.addCauldronSlots();
        this.addPlayerSlots(playerInv);
    }

    public Optional<BrewingCauldronBlockEntity> getBlockEntity() {
        return Optional.ofNullable(this.blockEntity);
    }

    private void addCauldronSlots() {
        if (this.container == null) {
            return;
        }
        this.m_38897_(new PotionSlot(this.container, 0, 15, 77));
        this.m_38897_(new PotionSlot(this.container, 1, 67, 77));
        this.m_38897_(new PotionSlot(this.container, 2, 67, 26));
        this.m_38897_(new PotionSlot(this.container, 3, 15, 26));
        this.m_38897_(new FoodSlot(this.container, 4, 41, 51));
        this.m_38897_(new OutputSlot(this.container, 5, 133, 51, this.blockEntity));
    }

    private void addPlayerSlots(Inventory playerInv) {
        int PLAYER_INV_X = 8;
        int PLAYER_INV_Y = 122;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int index = 9 + col + row * 9;
                this.m_38897_(new Slot((Container)playerInv, index, PLAYER_INV_X + col * 18, PLAYER_INV_Y + row * 18));
            }
        }
        int HOTBAR_X = 8;
        int HOTBAR_Y = 180;
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, HOTBAR_X + col * 18, HOTBAR_Y));
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.level == null || this.level.f_46443_) {
            return;
        }
        Container container = this.container;
        if (!(container instanceof SimpleContainer)) {
            return;
        }
        SimpleContainer simple = (SimpleContainer)container;
        Optional match = this.level.m_7465_().m_44015_((RecipeType)ModRecipes.BREWING_CAULDRON_RECIPE_TYPE, (Container)simple, this.level);
        if (match.isEmpty()) {
            simple.m_6836_(5, ItemStack.f_41583_);
            return;
        }
        ItemStack preview = ((BrewingCauldronRecipe)match.get()).assemble(simple, this.level.m_9598_()).m_41777_();
        if (this.blockEntity != null) {
            this.blockEntity.applyInfusionTags(preview);
        }
        simple.m_6836_(5, preview);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            originalStack = stackInSlot.m_41777_();
            if (index < 6 ? !this.m_38903_(stackInSlot, 6, 42, true) : (stackInSlot.m_41720_() instanceof PotionItem ? !this.m_38903_(stackInSlot, 0, 4, false) : (!(!stackInSlot.m_41614_() && !stackInSlot.m_150930_(Items.f_42502_) || stackInSlot.m_41782_() && Objects.requireNonNull(stackInSlot.m_41783_()).m_128441_("BrewChewPotionData")) ? !this.m_38903_(stackInSlot, 4, 5, false) : (index < 33 ? !this.m_38903_(stackInSlot, 33, 42, false) : index < 42 && !this.m_38903_(stackInSlot, 6, 33, false))))) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == originalStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return originalStack;
    }

    public static class PotionSlot
    extends Slot {
        public PotionSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return stack.m_41720_() instanceof PotionItem;
        }
    }

    public static class FoodSlot
    extends Slot {
        public FoodSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            boolean validType;
            boolean bl = validType = stack.m_41614_() || stack.m_150930_(Items.f_42502_);
            if (!validType) {
                return false;
            }
            return !stack.m_41782_() || !Objects.requireNonNull(stack.m_41783_()).m_128441_("BrewChewPotionData");
        }
    }

    public static class OutputSlot
    extends Slot {
        private final BrewingCauldronBlockEntity blockEntity;

        public OutputSlot(Container cont, int id, int x, int y, @Nullable BrewingCauldronBlockEntity be) {
            super(cont, id, x, y);
            this.blockEntity = be;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        public void m_142406_(@NotNull Player player, @NotNull ItemStack takenStack) {
            super.m_142406_(player, takenStack);
            Container container = this.f_40218_;
            if (!(container instanceof SimpleContainer)) {
                return;
            }
            SimpleContainer simple = (SimpleContainer)container;
            Level level = player.m_9236_();
            if (level.f_46443_) {
                return;
            }
            Optional match = level.m_7465_().m_44015_((RecipeType)ModRecipes.BREWING_CAULDRON_RECIPE_TYPE, (Container)simple, level);
            match.ifPresent(recipe -> {
                int page;
                Item infusedFlower;
                for (int i = 0; i < 4; ++i) {
                    simple.m_7407_(i, 1);
                }
                simple.m_7407_(4, 1);
                Item item = infusedFlower = this.blockEntity != null ? this.blockEntity.getStoredFlower() : null;
                if (this.blockEntity != null) {
                    this.blockEntity.setStoredFlower(null);
                    this.blockEntity.setStoredMushroom(Items.f_41952_);
                    this.blockEntity.cancelConsumption();
                    this.blockEntity.m_6596_();
                    level.m_7260_(this.blockEntity.m_58899_(), this.blockEntity.m_58900_(), this.blockEntity.m_58900_(), 3);
                }
                if (infusedFlower != null && FlowerEffectUtil.flowerMatchesEffect(infusedFlower, takenStack) && (page = GuidePages.pageFor(infusedFlower)) >= 0) {
                    player.getCapability(ModCapabilities.GUIDE_OBFUSCATION).ifPresent(cap -> {
                        if (cap.isPageObfuscated(page)) {
                            cap.revealPage(page);
                            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SyncGuideMaskPacket(cap.getRevealedMask()));
                        }
                    });
                }
            });
        }
    }
}

