/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.gui;

import com.eruannie_9.booklinggear.util.TabWidget;
import com.eruannie_9.brewchew.ModConfiguration;
import com.eruannie_9.brewchew.gui.BrewingCauldronGuideScreen;
import com.eruannie_9.brewchew.gui.BrewingCauldronMainMenu;
import com.eruannie_9.brewchew.packethandler.PacketHandler;
import com.eruannie_9.brewchew.packethandler.pack.OpenInfusionMenuPacket;
import com.eruannie_9.brewchew.util.render.gui.slot.AnimatedSlot;
import com.eruannie_9.brewchew.util.render.gui.slot.IconFrame;
import com.eruannie_9.brewchew.util.render.gui.water.CauldronAnimationRenderer;
import com.eruannie_9.brewchew.util.render.gui.water.CauldronRendererManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BrewingCauldronMainScreen
extends AbstractContainerScreen<BrewingCauldronMainMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("brewchew", "textures/gui/brewing_cauldron_gui.png");
    private static final ResourceLocation MAIN_ICON = new ResourceLocation("brewchew", "textures/gui/main_tab.png");
    private static final ResourceLocation INFUSION_ICON = new ResourceLocation("brewchew", "textures/gui/infusion_tab.png");
    private static final ResourceLocation GUIDE_ICON = new ResourceLocation("brewchew", "textures/gui/guide_tab_icon.png");
    private static final ResourceLocation SOUND_ON = new ResourceLocation("brewchew", "textures/gui/sound_on.png");
    private static final ResourceLocation SOUND_OFF = new ResourceLocation("brewchew", "textures/gui/sound_off.png");
    private static final IconFrame[] POTION_FRAMES = new IconFrame[]{new IconFrame(176, 0), new IconFrame(176, 16), new IconFrame(176, 32)};
    private static final IconFrame[] FOOD_FRAMES = new IconFrame[]{new IconFrame(176, 48), new IconFrame(176, 64), new IconFrame(176, 80), new IconFrame(176, 96), new IconFrame(176, 112)};
    private static final SlotOverlayData[] SLOTS_DATA = new SlotOverlayData[]{new SlotOverlayData(14, 25, 0.0f), new SlotOverlayData(66, 25, 90.0f), new SlotOverlayData(14, 76, 270.0f), new SlotOverlayData(66, 76, 180.0f), new SlotOverlayData(40, 50, 0.0f)};
    private final AnimatedSlot[] slotAnimations;
    private final CauldronAnimationRenderer waterAnimation = CauldronRendererManager.getRenderer();

    public BrewingCauldronMainScreen(BrewingCauldronMainMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 204;
        this.f_97730_ = 8;
        this.f_97731_ = 111;
        this.slotAnimations = new AnimatedSlot[5];
        int[] slotMapping = new int[]{3, 2, 0, 1};
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < 4; ++i) {
            this.slotAnimations[i] = new AnimatedSlot(SLOTS_DATA[i].offsetX(), SLOTS_DATA[i].offsetY(), slotMapping[i], POTION_FRAMES, random);
        }
        this.slotAnimations[4] = new AnimatedSlot(SLOTS_DATA[4].offsetX(), SLOTS_DATA[4].offsetY(), 4, FOOD_FRAMES, random);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initTabs();
    }

    private void initTabs() {
        boolean isBaseTab = true;
        Supplier<BlockPos> posSupplier = () -> ((BrewingCauldronMainMenu)this.f_97732_).getBlockEntity().map(BlockEntity::m_58899_).orElse(BlockPos.f_121853_);
        List<TabWidget> tabs = this.createTabs(isBaseTab, posSupplier);
        tabs.forEach(x$0 -> {
            TabWidget cfr_ignored_0 = (TabWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    private List<TabWidget> createTabs(boolean isBaseTab, Supplier<BlockPos> posSupplier) {
        float baseScale = 0.95f;
        float hoverScale = 1.2f;
        float animSpeed = 0.08f;
        List<TabWidget.TabPictureData> allTabs = List.of(new TabWidget.TabPictureData("Cauldron", () -> isBaseTab, btn -> {}, () -> MAIN_ICON, baseScale, hoverScale, animSpeed, null), new TabWidget.TabPictureData("Flower Extraction", () -> !isBaseTab, btn -> PacketHandler.CHANNEL.sendToServer((Object)new OpenInfusionMenuPacket((BlockPos)posSupplier.get())), () -> INFUSION_ICON, baseScale, hoverScale, animSpeed, null), new TabWidget.TabPictureData("Floriography", () -> false, btn -> Minecraft.m_91087_().m_91152_((Screen)new BrewingCauldronGuideScreen((Screen)this)), () -> GUIDE_ICON, baseScale, hoverScale, animSpeed, null), new TabWidget.TabPictureData("Boiling Sound", () -> (Boolean)ModConfiguration.CAULDRON_SOUNDS.get() == false, btn -> {
            boolean current = (Boolean)ModConfiguration.CAULDRON_SOUNDS.get();
            ModConfiguration.CAULDRON_SOUNDS.set((Object)(!current ? 1 : 0));
            ModConfiguration.SPEC.save();
        }, () -> (Boolean)ModConfiguration.CAULDRON_SOUNDS.get() != false ? SOUND_ON : SOUND_OFF, baseScale, hoverScale, animSpeed, null));
        ResourceLocation tabTexture = new ResourceLocation("brewchew", "textures/gui/guide_tab.png");
        Function<TabWidget.TabPictureData, TabWidget.SoundPlayStrategy> soundMapper = d -> "Boiling Sound".equals(d.label()) ? tab -> true : TabWidget.ONLY_IF_NOT_SELECTED;
        return TabWidget.createTabsFromPictureData((Screen)this, (int)this.f_97735_, (int)this.f_97736_, (int)this.f_97726_, allTabs, (ResourceLocation)tabTexture, (boolean)true, (boolean)true, soundMapper);
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gg);
        for (AnimatedSlot slot : this.slotAnimations) {
            slot.tick();
        }
        super.m_88315_(gg, mouseX, mouseY, partialTicks);
        this.m_280072_(gg, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        gg.m_280218_(BACKGROUND_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.waterAnimation.render(gg, this.f_97735_, this.f_97736_);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.slotAnimations.length; ++i) {
            SlotOverlayData data = SLOTS_DATA[i];
            AnimatedSlot anim = this.slotAnimations[i];
            ItemStack stack = ((BrewingCauldronMainMenu)this.f_97732_).m_38853_(anim.containerSlotIndex()).m_7993_();
            this.blitRotatedSlotOverlay(gg, data.offsetX(), data.offsetY(), data.angleDeg());
            if (!stack.m_41619_()) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            IconFrame frame = anim.getCurrentBaseFrame();
            gg.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + anim.x() + 1, this.f_97736_ + anim.y() + 1, frame.u(), frame.v(), 16, 16);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
    }

    private void blitRotatedSlotOverlay(GuiGraphics gg, int offX, int offY, float angleDeg) {
        int SLOT = 18;
        float PIV = 9.0f;
        PoseStack ps = gg.m_280168_();
        ps.m_85836_();
        ps.m_252880_((float)(this.f_97735_ + offX) + 9.0f, (float)(this.f_97736_ + offY) + 9.0f, 0.0f);
        ps.m_252781_(Axis.f_252403_.m_252977_(angleDeg));
        ps.m_252880_(-9.0f, -9.0f, 0.0f);
        gg.m_280218_(BACKGROUND_TEXTURE, 0, 0, 177, 129, 18, 18);
        ps.m_85849_();
    }

    protected void m_280003_(@NotNull GuiGraphics gg, int mouseX, int mouseY) {
        gg.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public void m_7379_() {
        TabWidget.clearScaleCache();
        super.m_7379_();
    }

    private record SlotOverlayData(int offsetX, int offsetY, float angleDeg) {
    }
}

